/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.core.AppEng;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.fallout.Fallout;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_5312;
import net.minecraft.class_5314;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6626;
import net.minecraft.class_6834;

public class MeteoriteStructure
extends class_3195<class_3111> {
    public static final class_5314 PLACEMENT_CONFIG = new class_5314(32, 8, 124895654);
    public static final class_2960 ID = AppEng.makeId("meteorite");
    public static final class_5321<class_5312<?, ?>> KEY = class_5321.method_29179((class_5321)class_2378.field_25915, (class_2960)ID);
    public static final class_3195<class_3111> INSTANCE = new MeteoriteStructure((Codec<class_3111>)class_3111.field_24893);
    public static final class_5312<class_3111, ? extends class_3195<class_3111>> CONFIGURED_INSTANCE = INSTANCE.method_28659((class_3037)class_3111.field_24894);

    public MeteoriteStructure(Codec<class_3111> configCodec) {
        super(configCodec, class_6834.simple(MeteoriteStructure::checkLocation, MeteoriteStructure::generatePieces));
    }

    private static boolean checkLocation(class_6834.class_6835<class_3111> context) {
        if (!context.method_39848(class_2902.class_2903.field_13194)) {
            return false;
        }
        class_2919 worldgenRandom = new class_2919((class_5819)new class_5820(0L));
        worldgenRandom.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        return worldgenRandom.nextBoolean();
    }

    private static void generatePieces(class_6626 piecesBuilder, class_6622.class_6623<class_3111> context) {
        class_1923 chunkPos = context.comp_127();
        class_2919 random = context.comp_130();
        class_5539 heightAccessor = context.comp_129();
        class_2794 generator = context.comp_125();
        int centerX = chunkPos.method_8326() + random.nextInt(16);
        int centerZ = chunkPos.method_8328() + random.nextInt(16);
        float meteoriteRadius = random.nextFloat() * 6.0f + 2.0f;
        int yOffset = (int)Math.ceil(meteoriteRadius) + 1;
        Set t2 = generator.method_12098().method_8763(centerX, generator.method_16398(), centerZ, 0, generator.method_38276());
        class_1959 spawnBiome = (class_1959)t2.stream().findFirst().orElseThrow();
        boolean isOcean = spawnBiome.method_8688() == class_1959.class_1961.field_9367;
        class_2902.class_2903 heightmapType = isOcean ? class_2902.class_2903.field_13195 : class_2902.class_2903.field_13194;
        StatsAccumulator stats = new StatsAccumulator();
        int scanRadius = (int)Math.max(1.0f, meteoriteRadius * 2.0f);
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                int h = generator.method_16397(centerX + x, centerZ + z, heightmapType, heightAccessor);
                stats.add((double)h);
            }
        }
        int centerY = (int)stats.mean();
        if (stats.populationVariance() > 5.0) {
            centerY = (int)((double)centerY - (stats.mean() - stats.min()) * 0.75);
        }
        centerY -= yOffset;
        centerY = Math.max(heightAccessor.method_31607() + yOffset, centerY);
        class_2338 actualPos = new class_2338(centerX, centerY, centerZ);
        boolean craterLake = MeteoriteStructure.locateWaterAroundTheCrater(actualPos, meteoriteRadius, context);
        CraterType craterType = MeteoriteStructure.determineCraterType(spawnBiome, (Random)random);
        boolean pureCrater = random.nextFloat() > 0.9f;
        FalloutMode fallout = Fallout.fromBiome(spawnBiome);
        piecesBuilder.method_35462((class_3443)new MeteoriteStructurePiece(actualPos, meteoriteRadius, craterType, fallout, pureCrater, craterLake));
    }

    private static boolean locateWaterAroundTheCrater(class_2338 pos, float radius, class_6622.class_6623<?> context) {
        class_2794 generator = context.comp_125();
        class_5539 heightAccessor = context.comp_129();
        int seaLevel = generator.method_16398();
        int maxY = seaLevel - 1;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        blockPos.method_33098(maxY);
        for (int i = pos.method_10263() - 32; i <= pos.method_10263() + 32; ++i) {
            blockPos.method_33097(i);
            for (int k = pos.method_10260() - 32; k <= pos.method_10260() + 32; ++k) {
                int heigth;
                blockPos.method_33099(k);
                double dx = i - pos.method_10263();
                double dz = k - pos.method_10260();
                double h = (float)pos.method_10264() - radius + 1.0f;
                double distanceFrom = dx * dx + dz * dz;
                if (!((double)maxY > h + distanceFrom * 0.0175) || !((double)maxY < h + distanceFrom * 0.02) || (heigth = generator.method_16397(blockPos.method_10263(), blockPos.method_10260(), class_2902.class_2903.field_13200, heightAccessor)) >= seaLevel) continue;
                return true;
            }
        }
        return false;
    }

    private static CraterType determineCraterType(class_1959 biome, Random random) {
        boolean lava;
        boolean lake;
        boolean specialMeteor;
        float temp = biome.method_8712();
        class_1959.class_1961 category = biome.method_8688();
        if (category == class_1959.class_1961.field_9367) {
            return CraterType.NONE;
        }
        boolean bl = specialMeteor = random.nextFloat() > 0.5f;
        if (!specialMeteor) {
            return CraterType.NORMAL;
        }
        if (temp >= 1.0f) {
            boolean lava2 = random.nextFloat() > 0.5f;
            switch (biome.method_8694()) {
                case field_9384: {
                    return lava2 ? CraterType.LAVA : CraterType.NORMAL;
                }
                case field_9382: {
                    boolean obsidian = random.nextFloat() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    return lava2 ? alternativObsidian : CraterType.NORMAL;
                }
            }
        }
        if (temp < 1.0f && (double)temp >= 0.2) {
            lake = random.nextFloat() > 0.25f;
            lava = random.nextFloat() > 0.8f;
            switch (biome.method_8694()) {
                case field_9384: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case field_9382: {
                    boolean obsidian = random.nextFloat() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    CraterType craterLake = lake ? CraterType.WATER : CraterType.NORMAL;
                    return lava ? alternativObsidian : craterLake;
                }
                case field_9383: {
                    boolean snow = random.nextFloat() > 0.75f;
                    CraterType water = lake ? CraterType.WATER : CraterType.NORMAL;
                    return snow ? CraterType.SNOW : water;
                }
            }
        }
        if ((double)temp < 0.2) {
            lake = random.nextFloat() > 0.25f;
            lava = random.nextFloat() > 0.95f;
            boolean frozen = random.nextFloat() > 0.25f;
            switch (biome.method_8694()) {
                case field_9384: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case field_9382: {
                    CraterType frozenLake = frozen ? CraterType.ICE : CraterType.WATER;
                    CraterType craterLake = lake ? frozenLake : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : craterLake;
                }
                case field_9383: {
                    CraterType snowCovered = lake ? CraterType.SNOW : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : snowCovered;
                }
            }
        }
        return CraterType.NORMAL;
    }
}

