/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.api.parts.IPartItem;
import appeng.core.definitions.AEBlockEntities;
import appeng.core.definitions.AEBlocks;
import appeng.siteexport.SceneRenderSettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1160;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2804;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_638;

class Scene {
    private static final int PADDING = 1;
    SceneRenderSettings settings;
    String filename;
    Map<class_2338, class_2680> blocks = new HashMap<class_2338, class_2680>();
    Map<class_2338, IPartItem<?>> cables = new HashMap();
    Consumer<class_3218> postSetup;
    Consumer<class_638> beforeRender;
    int waitTicks = 1;
    class_1160 centerOn = class_1160.field_29501;
    int rotationY;

    public Scene(SceneRenderSettings settings, String filename) {
        this.settings = settings;
        this.filename = filename;
    }

    public class_2338 getMin() {
        return class_3341.method_35411(this.blocks.keySet()).map(bb -> new class_2338(bb.method_35415(), bb.method_35416(), bb.method_35417())).orElseThrow();
    }

    public class_2338 getMax() {
        return class_3341.method_35411(this.blocks.keySet()).map(bb -> new class_2338(bb.method_35418(), bb.method_35419(), bb.method_35420())).orElseThrow();
    }

    public void clearArea(class_1937 level) {
        class_2338 min = this.getMin().method_10069(-1, -1, -1);
        class_2338 max = this.getMax().method_10069(1, 1, 1);
        for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }

    public void clearLighting(class_638 level) {
        class_2338 min = this.getMin().method_10069(-1, -1, -1);
        class_2338 max = this.getMax().method_10069(1, 1, 1);
        class_3568 lightEngine = level.method_22336();
        byte[] nibbles = new byte[2048];
        Arrays.fill(nibbles, (byte)-1);
        class_2804 dataLayer = new class_2804(nibbles);
        class_4076 secMin = class_4076.method_18682((class_2338)min);
        class_4076 secMax = class_4076.method_18682((class_2338)max);
        class_4076.method_20438((int)secMin.method_18674(), (int)secMin.method_18683(), (int)secMin.method_18687(), (int)secMax.method_18674(), (int)secMax.method_18683(), (int)secMax.method_18687()).forEach(sectionPos -> {
            lightEngine.method_15558(class_1944.field_9284, sectionPos, dataLayer, true);
            lightEngine.method_15558(class_1944.field_9282, sectionPos, dataLayer, true);
            lightEngine.method_15516(Integer.MAX_VALUE, true, true);
        });
    }

    public void setUp(class_3218 level) {
        class_2338 pos;
        for (Map.Entry<class_2338, class_2680> entry : this.blocks.entrySet()) {
            pos = entry.getKey();
            class_2680 state = entry.getValue();
            level.method_8652(pos, state, 11);
        }
        for (Map.Entry<class_2338, Object> entry : this.cables.entrySet()) {
            pos = entry.getKey();
            level.method_35230(pos, AEBlockEntities.CABLE_BUS).ifPresent(cableBus -> cableBus.addPart((IPartItem)entry.getValue(), null, null));
        }
        if (this.postSetup != null) {
            this.postSetup.accept(level);
        }
    }

    public void putCable(class_2338 blockPos, IPartItem<?> item) {
        this.blocks.put(blockPos, AEBlocks.CABLE_BUS.block().method_9564());
        this.cables.put(blockPos, item);
    }
}

