/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.core.AELog;
import appeng.items.parts.PartModels;
import appeng.parts.AEBasePart;
import appeng.parts.BasicStatePart;
import appeng.parts.PartModel;
import java.util.EnumSet;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class ToggleBusPart
extends BasicStatePart {
    @PartModels
    public static final class_2960 MODEL_BASE = new class_2960("ae2", "part/toggle_bus_base");
    @PartModels
    public static final class_2960 MODEL_STATUS_OFF = new class_2960("ae2", "part/toggle_bus_status_off");
    @PartModels
    public static final class_2960 MODEL_STATUS_ON = new class_2960("ae2", "part/toggle_bus_status_on");
    @PartModels
    public static final class_2960 MODEL_STATUS_HAS_CHANNEL = new class_2960("ae2", "part/toggle_bus_status_has_channel");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_STATUS_HAS_CHANNEL);
    private static final int REDSTONE_FLAG = 4;
    private final IManagedGridNode outerNode = GridHelper.createManagedNode(this, AEBasePart.NodeListener.INSTANCE).setTagName("outer").setInWorldNode(true).setIdlePowerUsage(0.0).setFlags(new GridFlags[0]);
    private IGridConnection connection;
    private boolean hasRedstone = false;

    public ToggleBusPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage(0.0);
        this.getMainNode().setFlags(new GridFlags[0]);
    }

    @Override
    protected int calculateClientFlags() {
        return super.calculateClientFlags() | (this.getIntention() ? 4 : 0);
    }

    public boolean hasRedstoneFlag() {
        return (this.getClientFlags() & 4) == 4;
    }

    protected boolean getIntention() {
        return this.getHost().hasRedstone();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 16.0);
    }

    @Override
    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        boolean oldHasRedstone = this.hasRedstone;
        this.hasRedstone = this.getHost().hasRedstone();
        if (this.hasRedstone != oldHasRedstone) {
            this.updateInternalState();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(class_2487 extra) {
        super.readFromNBT(extra);
        this.getOuterNode().loadFromNBT(extra);
    }

    @Override
    public void writeToNBT(class_2487 extra) {
        super.writeToNBT(extra);
        this.getOuterNode().saveToNBT(extra);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.getOuterNode().destroy();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.getOuterNode().create(this.getLevel(), this.getBlockEntity().method_11016());
        this.hasRedstone = this.getHost().hasRedstone();
        this.updateInternalState();
    }

    @Override
    public void setPartHostInfo(class_2350 side, IPartHost host, class_2586 blockEntity) {
        super.setPartHostInfo(side, host, blockEntity);
        this.outerNode.setExposedOnSides(EnumSet.of(side));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.getOuterNode().getNode();
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    public void onPlacement(class_1657 player) {
        super.onPlacement(player);
        this.getOuterNode().setOwningPlayer(player);
    }

    private void updateInternalState() {
        boolean intention = this.getIntention();
        if (intention == (this.connection == null) && this.getMainNode().getNode() != null && this.getOuterNode().getNode() != null) {
            if (intention) {
                try {
                    this.connection = GridHelper.createGridConnection(this.getMainNode().getNode(), this.getOuterNode().getNode());
                }
                catch (FailedConnectionException e) {
                    AELog.debug(e);
                }
            } else {
                this.connection.destroy();
                this.connection = null;
            }
        }
    }

    IManagedGridNode getOuterNode() {
        return this.outerNode;
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.hasRedstoneFlag() && this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.hasRedstoneFlag() && this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

