/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageHelper;
import appeng.util.IVariantConversion;
import appeng.util.Platform;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

class StorageExportStrategy<V extends TransferVariant<?>>
implements StackExportStrategy {
    private final BlockApiCache<Storage<V>, class_2350> apiCache;
    private final class_2350 fromSide;
    private final IVariantConversion<V> conversion;

    public StorageExportStrategy(BlockApiLookup<Storage<V>, class_2350> apiLookup, IVariantConversion<V> conversion, class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        this.apiCache = BlockApiCache.create(apiLookup, (class_3218)level, (class_2338)fromPos);
        this.fromSide = fromSide;
        this.conversion = conversion;
    }

    @Override
    public long transfer(StackTransferContext context, AEKey what, long amount, Actionable mode) {
        V variant = this.conversion.getVariant(what);
        if (variant.isBlank()) {
            return 0L;
        }
        Storage adjacentStorage = (Storage)this.apiCache.find((Object)this.fromSide);
        if (adjacentStorage == null) {
            return 0L;
        }
        IStorageService inv = context.getInternalStorage();
        long extracted = StorageHelper.poweredExtraction(context.getEnergySource(), inv.getInventory(), what, amount, context.getActionSource(), Actionable.SIMULATE);
        try (Transaction tx = Platform.openOrJoinTx();){
            long wasInserted = adjacentStorage.insert(variant, extracted, (TransactionContext)tx);
            if (wasInserted > 0L) {
                if (mode == Actionable.MODULATE) {
                    StorageHelper.poweredExtraction(context.getEnergySource(), inv.getInventory(), what, wasInserted, context.getActionSource(), Actionable.MODULATE);
                    tx.commit();
                }
                long l = wasInserted;
                return l;
            }
        }
        return 0L;
    }

    @Override
    public long push(AEKey what, long amount, Actionable mode) {
        V variant = this.conversion.getVariant(what);
        if (variant.isBlank()) {
            return 0L;
        }
        Storage adjacentStorage = (Storage)this.apiCache.find((Object)this.fromSide);
        if (adjacentStorage == null) {
            return 0L;
        }
        try (Transaction tx = Platform.openOrJoinTx();){
            long wasInserted = adjacentStorage.insert(variant, amount, (TransactionContext)tx);
            if (wasInserted > 0L) {
                if (mode == Actionable.MODULATE) {
                    tx.commit();
                }
                long l = wasInserted;
                return l;
            }
        }
        return 0L;
    }

    public static StackExportStrategy createItem(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        return new StorageExportStrategy<ItemVariant>(ItemStorage.SIDED, IVariantConversion.ITEM, level, fromPos, fromSide);
    }

    public static StackExportStrategy createFluid(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        return new StorageExportStrategy<FluidVariant>(FluidStorage.SIDED, IVariantConversion.FLUID, level, fromPos, fromSide);
    }
}

