/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartHelper;
import appeng.core.AELog;
import appeng.core.definitions.AEBlocks;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_3419;

public class PartPlacement {
    public static class_1269 place(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1799 partStack = context.method_8041();
        class_2350 side = context.method_8038();
        class_1792 class_17922 = partStack.method_7909();
        if (!(class_17922 instanceof IPartItem)) {
            return class_1269.field_5811;
        }
        IPartItem partItem = (IPartItem)class_17922;
        Placement placement = PartPlacement.getPartPlacement(player, level, partStack, pos, side);
        if (placement == null) {
            return class_1269.field_5814;
        }
        Object part = PartPlacement.placePart(player, level, partItem, partStack.method_7969(), placement.pos(), placement.side());
        if (part == null) {
            Platform.sendImmediateBlockEntityUpdate(player, pos);
            return class_1269.field_5814;
        }
        if (!level.field_9236 && player != null && !player.method_7337()) {
            partStack.method_7934(1);
            if (partStack.method_7947() == 0) {
                player.method_6122(context.method_20287(), class_1799.field_8037);
            }
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    @Nullable
    public static <T extends IPart> T placePart(@Nullable class_1657 player, class_1937 level, IPartItem<T> partItem, @Nullable class_2487 configTag, class_2338 pos, class_2350 side) {
        IPartHost host = PartHelper.getOrPlacePartHost(level, pos, false, player);
        if (host == null) {
            return null;
        }
        T addedPart = host.addPart(partItem, side, player);
        if (addedPart == null) {
            if (host.isEmpty()) {
                host.cleanup();
            }
            return null;
        }
        if (configTag != null) {
            try {
                addedPart.importSettings(SettingsFrom.DISMANTLE_ITEM, configTag, player);
            }
            catch (Exception e) {
                AELog.warn(e, "Failed to import part settings during placement.");
            }
        }
        class_2498 ss = AEBlocks.CABLE_BUS.block().method_9573(AEBlocks.CABLE_BUS.block().method_9564());
        level.method_8396(null, pos, ss.method_10598(), class_3419.field_15245, (ss.method_10597() + 1.0f) / 2.0f, ss.method_10599() * 0.8f);
        return addedPart;
    }

    @Nullable
    public static Placement getPartPlacement(@Nullable class_1657 player, class_1937 level, class_1799 partStack, class_2338 pos, class_2350 side) {
        if (PartPlacement.canPlacePartOnBlock(player, level, partStack, pos, side)) {
            return new Placement(pos, side);
        }
        if (PartPlacement.canPlacePartOnBlock(player, level, partStack, pos = pos.method_10093(side), side = side.method_10153())) {
            return new Placement(pos, side);
        }
        return null;
    }

    public static boolean canPlacePartOnBlock(@Nullable class_1657 player, class_1937 level, class_1799 partStack, class_2338 pos, class_2350 side) {
        IPartHost host = PartHelper.getPartHost(level, pos);
        if (host == null && !PartHelper.canPlacePartHost(player, level, pos)) {
            return false;
        }
        return host == null || host.canAddPart(partStack, side);
    }

    public record Placement(class_2338 pos, class_2350 side) {
    }
}

