/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.config.SecurityPermissions;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.ITerminalHost;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.NullMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.slot.CraftingMatrixSlot;
import appeng.menu.slot.CraftingTermSlot;
import appeng.parts.reporting.CraftingTerminalPart;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3917;
import net.minecraft.class_3956;

public class CraftingTermMenu
extends MEStorageMenu
implements IMenuCraftingPacket {
    public static final class_3917<CraftingTermMenu> TYPE = MenuTypeBuilder.create(CraftingTermMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftingterm");
    private final ISegmentedInventory craftingInventoryHost;
    private final CraftingMatrixSlot[] craftingSlots = new CraftingMatrixSlot[9];
    private final CraftingTermSlot outputSlot;
    private class_1860<class_1715> currentRecipe;

    public CraftingTermMenu(int id, class_1661 ip, ITerminalHost host) {
        this(TYPE, id, ip, host, true);
    }

    public CraftingTermMenu(class_3917<?> menuType, int id, class_1661 ip, ITerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, host, bindInventory);
        this.craftingInventoryHost = (ISegmentedInventory)((Object)host);
        InternalInventory craftingGridInv = this.craftingInventoryHost.getSubInventory(CraftingTerminalPart.INV_CRAFTING);
        for (int i = 0; i < 9; ++i) {
            this.craftingSlots[i] = new CraftingMatrixSlot(this, craftingGridInv, i);
            this.addSlot(this.craftingSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.outputSlot = new CraftingTermSlot(this.getPlayerInventory().field_7546, this.getActionSource(), this.powerSource, host.getInventory(), craftingGridInv, craftingGridInv, this);
        this.addSlot(this.outputSlot, SlotSemantics.CRAFTING_RESULT);
        this.method_7609(craftingGridInv.toContainer());
    }

    public void method_7609(class_1263 inventory) {
        NullMenu cn = new NullMenu();
        class_1715 ic = new class_1715((class_1703)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.method_5447(x, this.craftingSlots[x].method_7677());
        }
        class_1937 level = this.getPlayerInventory().field_7546.field_6002;
        if (this.currentRecipe == null || !this.currentRecipe.method_8115((class_1263)ic, level)) {
            this.currentRecipe = level.method_8433().method_8132(class_3956.field_17545, (class_1263)ic, level).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.outputSlot.method_7673(class_1799.field_8037);
        } else {
            this.outputSlot.method_7673(this.currentRecipe.method_8116((class_1263)ic));
        }
    }

    @Override
    public InternalInventory getCraftingMatrix() {
        return this.craftingInventoryHost.getSubInventory(CraftingTerminalPart.INV_CRAFTING);
    }

    @Override
    public boolean useRealItems() {
        return true;
    }

    public class_1860<class_1715> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void clearCraftingGrid() {
        Preconditions.checkState((boolean)this.isClientSide());
        CraftingMatrixSlot slot = this.craftingSlots[0];
        InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slot.field_7874, 0L);
        NetworkHandler.instance().sendToServer(p);
    }

    @Override
    public boolean hasItemType(class_1799 itemStack, int amount) {
        for (class_1735 slot : this.getSlots(SlotSemantics.CRAFTING_GRID)) {
            class_1799 stackInSlot = slot.method_7677();
            if (stackInSlot.method_7960() || !class_1799.method_31577((class_1799)itemStack, (class_1799)stackInSlot)) continue;
            if (itemStack.method_7947() >= amount) {
                return true;
            }
            amount -= itemStack.method_7947();
        }
        return super.hasItemType(itemStack, amount);
    }

    public Set<Integer> findMissingIngredients(Map<Integer, class_1856> ingredients) {
        HashSet<Integer> missingSlots = new HashSet<Integer>();
        Object2IntOpenHashMap reservedGridAmounts = new Object2IntOpenHashMap();
        class_2371 playerItems = this.getPlayerInventory().field_7547;
        int[] reservedPlayerItems = new int[playerItems.size()];
        for (Map.Entry<Integer, class_1856> entry : ingredients.entrySet()) {
            class_1856 ingredient = entry.getValue();
            boolean found = false;
            for (int i = 0; i < playerItems.size(); ++i) {
                class_1799 stack = (class_1799)playerItems.get(i);
                if (stack.method_7947() - reservedPlayerItems[i] <= 0 || !ingredient.method_8093(stack)) continue;
                int n = i;
                reservedPlayerItems[n] = reservedPlayerItems[n] + 1;
                found = true;
                break;
            }
            if (!found) {
                for (class_1799 stack : ingredient.method_8105()) {
                    AEItemKey itemKey = AEItemKey.of(stack);
                    int reservedAmount = reservedGridAmounts.getOrDefault((Object)itemKey, 0) + 1;
                    if (!this.hasItemType(stack, reservedAmount)) continue;
                    reservedGridAmounts.put((Object)itemKey, reservedAmount);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            missingSlots.add(entry.getKey());
        }
        return missingSlots;
    }
}

