/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.interaction;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.menu.me.interaction.ContainerItemContext;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.FluidContainerItemStrategy;
import appeng.util.CowMap;
import com.google.common.base.Preconditions;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class StackInteractions {
    private static final CowMap<AEKeyType, ContainerItemStrategy<?, ?>> strategies = CowMap.identityHashMap();

    public static <T extends AEKey> void register(AEKeyType type, Class<T> keyClass, ContainerItemStrategy<T, ?> strategy) {
        Preconditions.checkArgument((type.getKeyClass() == keyClass ? 1 : 0) != 0, (String)"%s != %s", type.getKeyClass(), keyClass);
        Preconditions.checkArgument((type != AEKeyType.items() ? 1 : 0) != 0, (Object)"Can't register container items for AEItemKey");
        strategies.putIfAbsent(type, strategy);
    }

    @Nullable
    public static GenericStack getContainedStack(class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        for (Map.Entry<AEKeyType, ContainerItemStrategy<?, ?>> entry : strategies.getMap().entrySet()) {
            GenericStack content = entry.getValue().getContainedStack(stack);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    @Nullable
    public static EmptyingAction getEmptyingAction(class_1799 stack) {
        GenericStack contents = StackInteractions.getContainedStack(stack);
        if (contents == null) {
            return null;
        }
        class_2561 description = contents.what().getDisplayName();
        return new EmptyingAction(description, contents.what(), contents.amount());
    }

    @Nullable
    public static ContainerItemContext findCarriedContext(class_1657 player, class_1703 menu) {
        for (Map.Entry<AEKeyType, ContainerItemStrategy<?, ?>> entry : strategies.getMap().entrySet()) {
            Object context = entry.getValue().findCarriedContext(player, menu);
            if (context == null) continue;
            return new ContainerItemContext(entry.getValue(), context);
        }
        return null;
    }

    static {
        StackInteractions.register(AEKeyType.fluids(), AEFluidKey.class, new FluidContainerItemStrategy());
    }
}

