/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.blockentity.spatial.SpatialPylonBlockEntity;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.MBCalculator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class SpatialPylonCluster
implements IAECluster {
    private final class_3218 level;
    private final class_2338 boundsMin;
    private final class_2338 boundsMax;
    private final List<SpatialPylonBlockEntity> line = new ArrayList<SpatialPylonBlockEntity>();
    private boolean isDestroyed = false;
    private Axis currentAxis = Axis.UNFORMED;
    private boolean isValid;

    public SpatialPylonCluster(class_3218 level, class_2338 boundsMin, class_2338 boundsMax) {
        this.level = level;
        this.boundsMin = boundsMin.method_10062();
        this.boundsMax = boundsMax.method_10062();
        if (this.getBoundsMin().method_10263() != this.getBoundsMax().method_10263()) {
            this.setCurrentAxis(Axis.X);
        } else if (this.getBoundsMin().method_10264() != this.getBoundsMax().method_10264()) {
            this.setCurrentAxis(Axis.Y);
        } else if (this.getBoundsMin().method_10260() != this.getBoundsMax().method_10260()) {
            this.setCurrentAxis(Axis.Z);
        } else {
            this.setCurrentAxis(Axis.UNFORMED);
        }
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        for (SpatialPylonBlockEntity r : this.getLine()) {
            r.recalculateDisplay();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        MBCalculator.setModificationInProgress(this);
        try {
            for (SpatialPylonBlockEntity r : this.getLine()) {
                r.updateStatus(null);
            }
        }
        finally {
            MBCalculator.setModificationInProgress(null);
        }
    }

    public Iterator<SpatialPylonBlockEntity> getBlockEntities() {
        return this.getLine().iterator();
    }

    public int size() {
        return this.getLine().size();
    }

    public Axis getCurrentAxis() {
        return this.currentAxis;
    }

    private void setCurrentAxis(Axis currentAxis) {
        this.currentAxis = currentAxis;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public class_3218 setLevel() {
        return this.level;
    }

    @Override
    public class_2338 getBoundsMax() {
        return this.boundsMax;
    }

    @Override
    public class_2338 getBoundsMin() {
        return this.boundsMin;
    }

    List<SpatialPylonBlockEntity> getLine() {
        return this.line;
    }

    public static enum Axis {
        X,
        Y,
        Z,
        UNFORMED;

    }
}

