/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster;

import appeng.core.AELog;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import java.lang.ref.WeakReference;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public abstract class MBCalculator<TBlockEntity extends IAEMultiBlock<TCluster>, TCluster extends IAECluster> {
    private static WeakReference<IAECluster> modificationInProgress = new WeakReference<Object>(null);
    protected final TBlockEntity target;

    public MBCalculator(TBlockEntity t) {
        this.target = t;
    }

    public static void setModificationInProgress(IAECluster cluster) {
        IAECluster inProgress = (IAECluster)modificationInProgress.get();
        if (inProgress == cluster) {
            return;
        }
        if (inProgress != null && cluster != null) {
            throw new IllegalStateException("A modification is already in-progress for: " + inProgress);
        }
        modificationInProgress = new WeakReference<IAECluster>(cluster);
    }

    public static boolean isModificationInProgress() {
        return modificationInProgress.get() != null;
    }

    public void updateMultiblockAfterNeighborUpdate(class_3218 level, class_2338 loc, class_2338 changedPos) {
        Object cluster = this.target.getCluster();
        boolean recheck = cluster != null ? (MBCalculator.isWithinBounds(changedPos, cluster.getBoundsMin(), cluster.getBoundsMax()) ? true : this.isValidBlockEntityAt((class_1937)level, changedPos.method_10263(), changedPos.method_10264(), changedPos.method_10260())) : true;
        if (recheck) {
            this.calculateMultiblock(level, loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateMultiblock(class_3218 level, class_2338 loc) {
        block20: {
            if (MBCalculator.isModificationInProgress()) {
                return;
            }
            Object currentCluster = this.target.getCluster();
            if (currentCluster != null && currentCluster.isDestroyed()) {
                return;
            }
            try {
                class_2338.class_2339 min = loc.method_25503();
                class_2338.class_2339 max = loc.method_25503();
                while (this.isValidBlockEntityAt((class_1937)level, min.method_10263() - 1, min.method_10264(), min.method_10260())) {
                    min.method_33097(min.method_10263() - 1);
                }
                while (this.isValidBlockEntityAt((class_1937)level, min.method_10263(), min.method_10264() - 1, min.method_10260())) {
                    min.method_33098(min.method_10264() - 1);
                }
                while (this.isValidBlockEntityAt((class_1937)level, min.method_10263(), min.method_10264(), min.method_10260() - 1)) {
                    min.method_33099(min.method_10260() - 1);
                }
                while (this.isValidBlockEntityAt((class_1937)level, max.method_10263() + 1, max.method_10264(), max.method_10260())) {
                    max.method_33097(max.method_10263() + 1);
                }
                while (this.isValidBlockEntityAt((class_1937)level, max.method_10263(), max.method_10264() + 1, max.method_10260())) {
                    max.method_33098(max.method_10264() + 1);
                }
                while (this.isValidBlockEntityAt((class_1937)level, max.method_10263(), max.method_10264(), max.method_10260() + 1)) {
                    max.method_33099(max.method_10260() + 1);
                }
                if (!this.checkMultiblockScale((class_2338)min, (class_2338)max) || !this.verifyUnownedRegion(level, (class_2338)min, (class_2338)max)) break block20;
                try {
                    if (!this.verifyInternalStructure(level, (class_2338)min, (class_2338)max)) {
                        this.disconnect();
                        return;
                    }
                }
                catch (Exception err) {
                    this.disconnect();
                    return;
                }
                boolean updateGrid = false;
                Object cluster = this.target.getCluster();
                if (cluster == null || !cluster.getBoundsMin().equals((Object)min) || !cluster.getBoundsMax().equals((Object)max)) {
                    cluster = this.createCluster(level, (class_2338)min, (class_2338)max);
                    MBCalculator.setModificationInProgress(cluster);
                    this.updateBlockEntities(cluster, level, (class_2338)min, (class_2338)max);
                    updateGrid = true;
                } else {
                    MBCalculator.setModificationInProgress(cluster);
                }
                cluster.updateStatus(updateGrid);
                return;
            }
            catch (Throwable err) {
                AELog.debug(err);
            }
            finally {
                MBCalculator.setModificationInProgress(null);
            }
        }
        this.disconnect();
    }

    private static boolean isWithinBounds(class_2338 pos, class_2338 boundsMin, class_2338 boundsMax) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        return x >= boundsMin.method_10263() && y >= boundsMin.method_10264() && z >= boundsMin.method_10260() && x <= boundsMax.method_10263() && y <= boundsMax.method_10264() && z <= boundsMax.method_10260();
    }

    private boolean isValidBlockEntityAt(class_1937 level, int x, int y, int z) {
        return this.isValidBlockEntity(level.method_8321(new class_2338(x, y, z)));
    }

    public abstract boolean checkMultiblockScale(class_2338 var1, class_2338 var2);

    private boolean verifyUnownedRegion(class_3218 level, class_2338 min, class_2338 max) {
        for (class_2350 side : class_2350.values()) {
            if (!this.verifyUnownedRegionInner(level, min.method_10263(), min.method_10264(), min.method_10260(), max.method_10263(), max.method_10264(), max.method_10260(), side)) continue;
            return false;
        }
        return true;
    }

    public abstract TCluster createCluster(class_3218 var1, class_2338 var2, class_2338 var3);

    public abstract boolean verifyInternalStructure(class_3218 var1, class_2338 var2, class_2338 var3);

    public void disconnect() {
        this.target.disconnect(true);
    }

    public abstract void updateBlockEntities(TCluster var1, class_3218 var2, class_2338 var3, class_2338 var4);

    public abstract boolean isValidBlockEntity(class_2586 var1);

    private boolean verifyUnownedRegionInner(class_3218 level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2350 side) {
        switch (side) {
            case field_11039: {
                maxX = --minX;
                break;
            }
            case field_11034: {
                minX = ++maxX;
                break;
            }
            case field_11033: {
                maxY = --minY;
                break;
            }
            case field_11043: {
                minZ = ++maxZ;
                break;
            }
            case field_11035: {
                maxZ = --minZ;
                break;
            }
            case field_11036: {
                minY = ++maxY;
                break;
            }
            default: {
                return false;
            }
        }
        for (class_2338 p : class_2338.method_10094((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            class_2586 te = level.method_8321(p);
            if (!this.isValidBlockEntity(te)) continue;
            return true;
        }
        return false;
    }
}

