/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cells;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class BasicCellInventory
implements StorageCell {
    private static final int MAX_ITEM_TYPES = 63;
    private static final String ITEM_COUNT_TAG = "ic";
    private static final String STACK_KEYS = "keys";
    private static final String STACK_AMOUNTS = "amts";
    private final ISaveProvider container;
    private final AEKeyType keyType;
    private IPartitionList partitionList;
    private IncludeExclude partitionListMode;
    private int maxItemTypes;
    private short storedItems;
    private long storedItemCount;
    private Object2LongMap<AEKey> storedAmounts;
    private final class_1799 i;
    private final IBasicCellItem cellType;
    private boolean isPersisted = true;

    private BasicCellInventory(IBasicCellItem cellType, class_1799 o, ISaveProvider container) {
        this.i = o;
        this.cellType = cellType;
        this.maxItemTypes = this.cellType.getTotalTypes(this.i);
        if (this.maxItemTypes > 63) {
            this.maxItemTypes = 63;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        this.container = container;
        this.storedItems = (short)this.getTag().method_10565(STACK_AMOUNTS).length;
        this.storedItemCount = this.getTag().method_10537(ITEM_COUNT_TAG);
        this.storedAmounts = null;
        this.keyType = cellType.getKeyType();
        this.updateFilter();
    }

    private void updateFilter() {
        IPartitionList.Builder builder = IPartitionList.builder();
        IUpgradeInventory upgrades = this.getUpgradesInventory();
        ConfigInventory config = this.getConfigInventory();
        boolean hasInverter = upgrades.isInstalled(AEItems.INVERTER_CARD);
        if (upgrades.isInstalled(AEItems.FUZZY_CARD)) {
            builder.fuzzyMode(this.getFuzzyMode());
        }
        builder.addAll(config.keySet());
        this.partitionListMode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.partitionList = builder.build();
    }

    public IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    public boolean isPreformatted() {
        return !this.partitionList.isEmpty();
    }

    public boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    private class_2487 getTag() {
        return this.i.method_7948();
    }

    public static BasicCellInventory createInventory(class_1799 o, ISaveProvider container) {
        Objects.requireNonNull(o, "Cannot create cell inventory for null itemstack");
        class_1792 class_17922 = o.method_7909();
        if (!(class_17922 instanceof IBasicCellItem)) {
            return null;
        }
        IBasicCellItem cellType = (IBasicCellItem)class_17922;
        if (!cellType.isStorageCell(o)) {
            return null;
        }
        return new BasicCellInventory(cellType, o, container);
    }

    public static boolean isCell(class_1799 input) {
        return BasicCellInventory.getStorageCell(input) != null;
    }

    private boolean isStorageCell(AEItemKey key) {
        IBasicCellItem type = BasicCellInventory.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    private static IBasicCellItem getStorageCell(class_1799 input) {
        class_1792 class_17922;
        if (input != null && (class_17922 = input.method_7909()) instanceof IBasicCellItem) {
            IBasicCellItem basicCellItem = (IBasicCellItem)class_17922;
            return basicCellItem;
        }
        return null;
    }

    private static IBasicCellItem getStorageCell(AEItemKey itemKey) {
        class_1792 class_17922 = itemKey.getItem();
        if (class_17922 instanceof IBasicCellItem) {
            IBasicCellItem basicCellItem = (IBasicCellItem)class_17922;
            return basicCellItem;
        }
        return null;
    }

    private static boolean isCellEmpty(BasicCellInventory inv) {
        if (inv != null) {
            return inv.getAvailableStacks().isEmpty();
        }
        return true;
    }

    protected Object2LongMap<AEKey> getCellItems() {
        if (this.storedAmounts == null) {
            this.storedAmounts = new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.storedAmounts;
    }

    @Override
    public void persist() {
        if (this.isPersisted) {
            return;
        }
        long itemCount = 0L;
        LongArrayList amounts = new LongArrayList(this.storedAmounts.size());
        class_2499 keys = new class_2499();
        for (Object2LongMap.Entry entry : this.storedAmounts.object2LongEntrySet()) {
            long amount = entry.getLongValue();
            if (amount <= 0L) continue;
            itemCount += amount;
            keys.add((Object)((AEKey)entry.getKey()).toTagGeneric());
            amounts.add(amount);
        }
        if (keys.isEmpty()) {
            this.getTag().method_10551(STACK_KEYS);
            this.getTag().method_10551(STACK_AMOUNTS);
        } else {
            this.getTag().method_10566(STACK_KEYS, (class_2520)keys);
            this.getTag().method_10564(STACK_AMOUNTS, amounts.toArray(new long[0]));
        }
        this.storedItems = (short)this.storedAmounts.size();
        this.storedItemCount = itemCount;
        if (itemCount == 0L) {
            this.getTag().method_10551(ITEM_COUNT_TAG);
        } else {
            this.getTag().method_10544(ITEM_COUNT_TAG, itemCount);
        }
        this.isPersisted = true;
    }

    protected void saveChanges() {
        this.storedItems = (short)this.storedAmounts.size();
        this.storedItemCount = 0L;
        for (Long storedAmount : this.storedAmounts.values()) {
            this.storedItemCount += storedAmount.longValue();
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    private void loadCellItems() {
        class_2499 tags;
        boolean corruptedTag = false;
        long[] amounts = this.getTag().method_10565(STACK_AMOUNTS);
        if (amounts.length != (tags = this.getTag().method_10554(STACK_KEYS, 10)).size()) {
            AELog.warn("Loading storage cell with mismatched amounts/tags: %d != %d", amounts.length, tags.size());
        }
        for (int i = 0; i < amounts.length; ++i) {
            long amount = amounts[i];
            AEKey key = AEKey.fromTagGeneric(tags.method_10602(i));
            if (amount <= 0L || key == null) {
                corruptedTag = true;
                continue;
            }
            this.storedAmounts.put((Object)key, amount);
        }
        if (corruptedTag) {
            this.saveChanges();
        }
    }

    @Override
    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.getCellItems().object2LongEntrySet()) {
            out.add((AEKey)entry.getKey(), entry.getLongValue());
        }
    }

    @Override
    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public FuzzyMode getFuzzyMode() {
        return this.cellType.getFuzzyMode(this.i);
    }

    public ConfigInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.i);
    }

    public IUpgradeInventory getUpgradesInventory() {
        return this.cellType.getUpgrades(this.i);
    }

    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.i);
    }

    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    public long getTotalBytes() {
        return this.cellType.getBytes(this.i);
    }

    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    public long getStoredItemTypes() {
        return this.storedItems;
    }

    public long getRemainingItemTypes() {
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        long baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes();
        return Math.min(basedOnStorage, baseOnTotal);
    }

    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / (long)this.keyType.getAmountPerByte();
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)this.keyType.getAmountPerByte() + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % 8L);
        if (div == 0) {
            return 0;
        }
        return this.keyType.getAmountPerByte() - div;
    }

    @Override
    public CellState getStatus() {
        if (this.getStoredItemTypes() == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        if (this.getRemainingItemCount() > 0L) {
            return CellState.TYPES_FULL;
        }
        return CellState.FULL;
    }

    @Override
    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        BasicCellInventory meInventory;
        AEItemKey itemKey;
        if (amount == 0L || !this.keyType.contains(what)) {
            return 0L;
        }
        if (!this.partitionList.matchesFilter(what, this.partitionListMode)) {
            return 0L;
        }
        if (this.cellType.isBlackListed(this.i, what)) {
            return 0L;
        }
        if (what instanceof AEItemKey && this.isStorageCell(itemKey = (AEItemKey)what) && !BasicCellInventory.isCellEmpty(meInventory = BasicCellInventory.createInventory(itemKey.toStack(), null))) {
            return 0L;
        }
        long currentAmount = this.getCellItems().getLong((Object)what);
        long remainingItemCount = this.getRemainingItemCount();
        if (currentAmount <= 0L) {
            if (!this.canHoldNewItem()) {
                return 0L;
            }
            if ((remainingItemCount -= (long)this.getBytesPerType() * (long)this.keyType.getAmountPerByte()) <= 0L) {
                return 0L;
            }
        }
        if (amount > remainingItemCount) {
            amount = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            this.getCellItems().put((Object)what, currentAmount + amount);
            this.saveChanges();
        }
        return amount;
    }

    @Override
    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentAmount = this.getCellItems().getLong((Object)what);
        if (currentAmount > 0L) {
            if (extractAmount >= currentAmount) {
                if (mode == Actionable.MODULATE) {
                    this.getCellItems().remove((Object)what, currentAmount);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                this.getCellItems().put((Object)what, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    @Override
    public class_2561 getDescription() {
        return this.i.method_7964();
    }
}

