/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.block.networking.CableBusBlock;
import appeng.block.paint.PaintSplotchesBlock;
import appeng.blockentity.misc.PaintSplotchesBlockEntity;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.misc.PaintBallItem;
import appeng.items.tools.powered.BlockRecolorer;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.cells.BasicCellHandler;
import appeng.me.cells.BasicCellInventory;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.PlayerSource;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1823;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3494;
import net.minecraft.class_5250;

public class ColorApplicatorItem
extends AEBasePoweredItem
implements IBasicCellItem,
IBlockTool,
IMouseWheelItem {
    private static final double POWER_PER_USE = 100.0;
    private static final Map<class_3494.class_5123<class_1792>, AEColor> TAG_TO_COLOR = AEColor.VALID_COLORS.stream().collect(Collectors.toMap(aeColor -> ConventionTags.dye(aeColor.dye), Function.identity()));
    private static final BiMap<class_1767, class_1792> VANILLA_DYES = EnumHashBiMap.create(class_1767.class);
    private static final String TAG_COLOR = "color";

    public ColorApplicatorItem(class_1792.class_1793 props) {
        super(AEConfig.instance().getColorApplicatorBattery(), props);
    }

    @Override
    public double getChargeRate(class_1799 stack) {
        return 80.0 + 80.0 * (double)this.getUpgrades(stack).getInstalledUpgrades(AEItems.ENERGY_CARD);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1799 is = context.method_8041();
        class_2350 side = context.method_8038();
        class_1657 p = context.method_8036();
        if (p == null && level instanceof class_3218) {
            p = Platform.getPlayer((class_3218)level);
        }
        class_2248 blk = level.method_8320(pos).method_26204();
        class_1799 paintBall = this.getColor(is);
        AEItemKey paintBallKey = AEItemKey.of(paintBall);
        PlayerSource source = new PlayerSource(p);
        StorageCell inv = StorageCells.getCellInventory(is, null);
        if (inv != null) {
            AEColor color;
            long extracted = inv.extract(paintBallKey, 1L, Actionable.SIMULATE, source);
            if (extracted > 0L) {
                paintBall = paintBall.method_7972();
                paintBall.method_7939(1);
            } else {
                paintBall = class_1799.field_8037;
            }
            if (p != null && !Platform.hasPermissions(new DimensionalBlockPos(level, pos), p)) {
                return class_1269.field_5814;
            }
            if (!paintBall.method_7960() && paintBall.method_7909() instanceof class_1823) {
                class_2586 be = level.method_8321(pos);
                if (p != null && be instanceof IColorableBlockEntity) {
                    IColorableBlockEntity colorableBlockEntity = (IColorableBlockEntity)be;
                    if (this.getAECurrentPower(is) > 100.0 && colorableBlockEntity.getColor() != AEColor.TRANSPARENT && colorableBlockEntity.recolourBlock(side, AEColor.TRANSPARENT, p)) {
                        this.consumeItem(is, paintBallKey, false);
                        return class_1269.method_29236((boolean)level.method_8608());
                    }
                }
                class_2248 testBlk = level.method_8320(pos.method_10093(side)).method_26204();
                class_2586 painted = level.method_8321(pos.method_10093(side));
                if (this.getAECurrentPower(is) > 100.0 && testBlk instanceof PaintSplotchesBlock && painted instanceof PaintSplotchesBlockEntity) {
                    this.consumeItem(is, paintBallKey, false);
                    ((PaintSplotchesBlockEntity)painted).cleanSide(side.method_10153());
                    return class_1269.method_29236((boolean)level.method_8608());
                }
            } else if (!paintBall.method_7960() && (color = this.getColorFromItem(paintBall)) != null && this.getAECurrentPower(is) > 100.0 && color != AEColor.TRANSPARENT && this.recolourBlock(blk, side, level, pos, color, p)) {
                this.consumeItem(is, paintBallKey, false);
                return class_1269.method_29236((boolean)level.method_8608());
            }
        }
        if (p != null && InteractionUtil.isInAlternateUseMode(p)) {
            this.cycleColors(is, paintBall, 1);
        }
        return class_1269.field_5814;
    }

    public class_2561 method_7864(class_1799 is) {
        class_5250 extra = GuiText.Empty.text();
        AEColor selected = this.getActiveColor(is);
        if (selected != null && Platform.isClient()) {
            extra = new class_2588(selected.translationKey);
        }
        return super.method_7864(is).method_27661().method_27693(" - ").method_10852((class_2561)extra);
    }

    public AEColor getActiveColor(class_1799 tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    public boolean consumeColor(class_1799 applicator, AEColor color, boolean simulate) {
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return false;
        }
        KeyCounter availableItems = inv.getAvailableStacks();
        AEItemKey paintItem = null;
        for (AEKey what : availableItems.keySet()) {
            AEItemKey itemKey;
            if (!(what instanceof AEItemKey) || this.getColorFromItem((itemKey = (AEItemKey)what).getItem()) != color) continue;
            paintItem = itemKey;
            break;
        }
        if (paintItem != null) {
            return this.consumeItem(applicator, paintItem, simulate);
        }
        return false;
    }

    public boolean consumeItem(class_1799 applicator, AEItemKey paintItem, boolean simulate) {
        boolean success;
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return false;
        }
        Actionable mode = simulate ? Actionable.SIMULATE : Actionable.MODULATE;
        boolean bl = success = inv.extract(paintItem, 1L, mode, new BaseActionSource()) >= 1L && this.extractAEPower(applicator, 100.0, mode) >= 100.0;
        if (success && !simulate && paintItem.matches(this.getColor(applicator)) && inv.getAvailableStacks().get(paintItem) == 0L) {
            this.setColor(applicator, class_1799.field_8037);
        }
        return success;
    }

    private AEColor getColorFromItem(class_1799 paintBall) {
        if (paintBall.method_7960()) {
            return null;
        }
        return this.getColorFromItem(paintBall.method_7909());
    }

    private AEColor getColorFromItem(class_1792 paintBall) {
        if (paintBall instanceof class_1823) {
            return AEColor.TRANSPARENT;
        }
        if (paintBall instanceof PaintBallItem) {
            PaintBallItem ipb = (PaintBallItem)paintBall;
            return ipb.getColor();
        }
        class_1767 vanillaDye = (class_1767)VANILLA_DYES.inverse().get((Object)paintBall);
        if (vanillaDye != null) {
            return AEColor.fromDye(vanillaDye);
        }
        for (Map.Entry<class_3494.class_5123<class_1792>, AEColor> entry : TAG_TO_COLOR.entrySet()) {
            if (!entry.getKey().method_15141((Object)paintBall)) continue;
            return entry.getValue();
        }
        return null;
    }

    public class_1799 getColor(class_1799 is) {
        class_2487 color;
        class_1799 oldColor;
        class_2487 c = is.method_7969();
        if (c != null && c.method_10545(TAG_COLOR) && !(oldColor = class_1799.method_7915((class_2487)(color = c.method_10562(TAG_COLOR)))).method_7960()) {
            return oldColor;
        }
        return this.findNextColor(is, class_1799.field_8037, 0);
    }

    private class_1799 findNextColor(class_1799 is, class_1799 anchor, int scrollOffset) {
        class_1799 newColor = class_1799.field_8037;
        StorageCell inv = StorageCells.getCellInventory(is, null);
        if (inv != null) {
            KeyCounter itemList = inv.getAvailableStacks();
            if (anchor.method_7960()) {
                AEItemKey firstItem = itemList.getFirstKey(AEItemKey.class);
                if (firstItem != null) {
                    newColor = firstItem.toStack();
                }
            } else {
                LinkedList<AEItemKey> list = new LinkedList<AEItemKey>();
                for (Object2LongMap.Entry<AEKey> i : itemList) {
                    Object object = i.getKey();
                    if (!(object instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)object;
                    list.add(itemKey);
                }
                if (list.isEmpty()) {
                    return class_1799.field_8037;
                }
                list.sort(Comparator.comparingInt(a -> {
                    AEColor color = this.getColorFromItem(a.getItem());
                    return color != null ? color.ordinal() : Integer.MAX_VALUE;
                }));
                AEItemKey where = (AEItemKey)list.getFirst();
                AEColor anchorColor = this.getColorFromItem(anchor);
                for (int cycles = 1 + list.size(); cycles > 0 && this.getColorFromItem(where.getItem()) != anchorColor; --cycles) {
                    list.addLast((AEItemKey)list.removeFirst());
                    where = (AEItemKey)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((AEItemKey)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((AEItemKey)list.removeLast());
                }
                return ((AEItemKey)list.get(0)).toStack();
            }
        }
        if (!newColor.method_7960()) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    private void setColor(class_1799 is, class_1799 newColor) {
        class_2487 data = is.method_7948();
        if (newColor.method_7960()) {
            data.method_10551(TAG_COLOR);
        } else {
            class_2487 color = new class_2487();
            newColor.method_7953(color);
            data.method_10566(TAG_COLOR, (class_2520)color);
        }
    }

    private boolean recolourBlock(class_2248 blk, class_2350 side, class_1937 level, class_2338 pos, AEColor newColor, @Nullable class_1657 p) {
        IColorableBlockEntity ct;
        class_2586 be;
        class_2680 state = level.method_8320(pos);
        class_2248 recolored = BlockRecolorer.recolor(blk, newColor);
        if (recolored != blk) {
            class_2680 newState = recolored.method_9564();
            for (class_2769 prop : newState.method_28501()) {
                newState = ColorApplicatorItem.copyProp(state, newState, prop);
            }
            return level.method_8501(pos, newState);
        }
        if (blk instanceof CableBusBlock) {
            CableBusBlock cableBusBlock = (CableBusBlock)blk;
            if (p != null) {
                return cableBusBlock.recolorBlock((class_1922)level, pos, side, newColor.dye, p);
            }
        }
        if ((be = level.method_8321(pos)) instanceof IColorableBlockEntity && (ct = (IColorableBlockEntity)be).getColor() != newColor) {
            ct.recolourBlock(side, newColor, p);
            return true;
        }
        return false;
    }

    private static <T extends Comparable<T>> class_2680 copyProp(class_2680 oldState, class_2680 newState, class_2769<T> prop) {
        if (newState.method_28498(prop)) {
            return (class_2680)newState.method_11657(prop, oldState.method_11654(prop));
        }
        return newState;
    }

    public void cycleColors(class_1799 is, class_1799 paintBall, int i) {
        if (paintBall.method_7960()) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(class_1799 cellItem, AEKey requestedAddition) {
        if (requestedAddition instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)requestedAddition;
            return this.getColorFromItem(itemKey.getItem()) == null;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public AEKeyType getKeyType() {
        return AEKeyType.items();
    }

    @Override
    public boolean isEditable(class_1799 is) {
        return true;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 is) {
        return UpgradeInventories.forItem(is, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(class_1799 stack, IUpgradeInventory upgrades) {
        int energyCards = upgrades.getInstalledUpgrades(AEItems.ENERGY_CARD);
        this.setAEMaxPowerMultiplier(stack, 1 + energyCards * 8);
    }

    @Override
    public ConfigInventory getConfigInventory(class_1799 is) {
        return CellConfig.create(AEItemKey.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        if (fz.isEmpty()) {
            return FuzzyMode.IGNORE_ALL;
        }
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    @Override
    public void onWheel(class_1799 is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }

    @Override
    public void method_7850(class_1761 group, class_2371<class_1799> items) {
        super.method_7850(group, items);
        if (this.method_7877(group)) {
            items.add((Object)ColorApplicatorItem.createFullColorApplicator());
        }
    }

    public static class_1799 createFullColorApplicator() {
        ColorApplicatorItem item = AEItems.COLOR_APPLICATOR.method_8389();
        class_1799 applicator = new class_1799((class_1935)item);
        BasicCellInventory dyeStorage = BasicCellHandler.INSTANCE.getCellInventory(applicator, null);
        for (class_1792 dyeItem : VANILLA_DYES.values()) {
            dyeStorage.insert(AEItemKey.of((class_1935)dyeItem), 128L, Actionable.MODULATE, new BaseActionSource());
        }
        dyeStorage.insert(AEItemKey.of((class_1935)class_1802.field_8543), 128L, Actionable.MODULATE, new BaseActionSource());
        IUpgradeInventory upgrades = item.getUpgrades(applicator);
        upgrades.addItems(AEItems.ENERGY_CARD.stack());
        upgrades.addItems(AEItems.ENERGY_CARD.stack());
        item.injectAEPower(applicator, item.getAEMaxPower(applicator), Actionable.MODULATE);
        return applicator;
    }

    public boolean setActiveColor(class_1799 applicator, @Nullable AEColor color) {
        if (color == null) {
            this.setColor(applicator, class_1799.field_8037);
            return true;
        }
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return false;
        }
        for (Object2LongMap.Entry<AEKey> entry : inv.getAvailableStacks()) {
            AEItemKey itemKey;
            Object object = entry.getKey();
            if (!(object instanceof AEItemKey) || this.getColorFromItem((itemKey = (AEItemKey)object).getItem()) != color) continue;
            this.setColor(applicator, itemKey.toStack());
            return true;
        }
        return false;
    }

    static {
        VANILLA_DYES.put((Object)class_1767.field_7952, (Object)class_1802.field_8446);
        VANILLA_DYES.put((Object)class_1767.field_7946, (Object)class_1802.field_8492);
        VANILLA_DYES.put((Object)class_1767.field_7958, (Object)class_1802.field_8669);
        VANILLA_DYES.put((Object)class_1767.field_7951, (Object)class_1802.field_8273);
        VANILLA_DYES.put((Object)class_1767.field_7947, (Object)class_1802.field_8192);
        VANILLA_DYES.put((Object)class_1767.field_7961, (Object)class_1802.field_8131);
        VANILLA_DYES.put((Object)class_1767.field_7954, (Object)class_1802.field_8330);
        VANILLA_DYES.put((Object)class_1767.field_7944, (Object)class_1802.field_8298);
        VANILLA_DYES.put((Object)class_1767.field_7967, (Object)class_1802.field_8851);
        VANILLA_DYES.put((Object)class_1767.field_7955, (Object)class_1802.field_8632);
        VANILLA_DYES.put((Object)class_1767.field_7945, (Object)class_1802.field_8296);
        VANILLA_DYES.put((Object)class_1767.field_7966, (Object)class_1802.field_8345);
        VANILLA_DYES.put((Object)class_1767.field_7957, (Object)class_1802.field_8099);
        VANILLA_DYES.put((Object)class_1767.field_7942, (Object)class_1802.field_8408);
        VANILLA_DYES.put((Object)class_1767.field_7964, (Object)class_1802.field_8264);
        VANILLA_DYES.put((Object)class_1767.field_7963, (Object)class_1802.field_8226);
    }
}

