/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.util.AEColor;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class MemoryCardItem
extends AEBaseItem
implements IMemoryCard,
AEToolItem {
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};

    public MemoryCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        String firstLineKey = this.getFirstValidTranslationKey(this.getSettingsName(stack) + ".name", this.getSettingsName(stack));
        lines.add((class_2561)Tooltips.of(new class_2588(firstLineKey)));
        class_2487 data = this.getData(stack);
        if (data.method_10545("tooltip")) {
            String tooltipKey = this.getFirstValidTranslationKey(data.method_10558("tooltip") + ".name", data.method_10558("tooltip"));
            lines.add((class_2561)Tooltips.of(new class_2588(tooltipKey)));
        }
        if (data.method_10545("freq")) {
            short freq = data.method_10568("freq");
            String freqTooltip = class_124.field_1067 + Platform.p2p().toHexString(freq);
            lines.add((class_2561)Tooltips.of(new class_2588("gui.tooltips.ae2.P2PFrequency", new Object[]{freqTooltip})));
        }
    }

    private String getFirstValidTranslationKey(String ... name) {
        for (String n3 : name) {
            if (!class_1074.method_4663((String)n3)) continue;
            return n3;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(class_1799 is, String settingsName, class_2487 data) {
        class_2487 c = is.method_7948();
        c.method_10582("Config", settingsName);
        c.method_10566("Data", (class_2520)data);
    }

    @Override
    public String getSettingsName(class_1799 is) {
        class_2487 c = is.method_7948();
        String name = c.method_10558("Config");
        return name.isEmpty() ? GuiText.Blank.getTranslationKey() : name;
    }

    @Override
    public class_2487 getData(class_1799 is) {
        class_2487 c = is.method_7948();
        class_2487 o = c.method_10562("Data");
        return o.method_10553();
    }

    @Override
    public AEColor[] getColorCode(class_1799 is) {
        class_2487 tag = this.getData(is);
        if (tag.method_10573("colorCode", 11)) {
            int[] frequency = tag.method_10561("colorCode");
            AEColor[] colorArray = AEColor.values();
            if (frequency.length == 8) {
                return new AEColor[]{colorArray[frequency[0]], colorArray[frequency[1]], colorArray[frequency[2]], colorArray[frequency[3]], colorArray[frequency[4]], colorArray[frequency[5]], colorArray[frequency[6]], colorArray[frequency[7]]};
            }
        }
        return DEFAULT_COLOR_CODE;
    }

    @Override
    public void notifyUser(class_1657 player, MemoryCardMessages msg) {
        if (player.method_5770().method_8608()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.method_9203((class_2561)PlayerMessages.SettingCleared.text(), class_156.field_25140);
                break;
            }
            case INVALID_MACHINE: {
                player.method_9203((class_2561)PlayerMessages.InvalidMachine.text(), class_156.field_25140);
                break;
            }
            case SETTINGS_LOADED: {
                player.method_9203((class_2561)PlayerMessages.LoadedSettings.text(), class_156.field_25140);
                break;
            }
            case SETTINGS_SAVED: {
                player.method_9203((class_2561)PlayerMessages.SavedSettings.text(), class_156.field_25140);
                break;
            }
            case SETTINGS_RESET: {
                player.method_9203((class_2561)PlayerMessages.ResetSettings.text(), class_156.field_25140);
                break;
            }
        }
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        class_1657 player = context.method_8036();
        if (player != null && InteractionUtil.isInAlternateUseMode(player)) {
            class_2680 state;
            class_1269 useResult;
            class_1937 level = context.method_8045();
            if (!level.method_8608() && !(useResult = (state = context.method_8045().method_8320(context.method_8037())).method_26174(context.method_8045(), context.method_8036(), context.method_20287(), new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699()))).method_23665()) {
                this.clearCard(context.method_8036(), context.method_8045(), context.method_20287());
            }
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (InteractionUtil.isInAlternateUseMode(player) && !level.field_9236) {
            this.clearCard(player, level, hand);
        }
        return super.method_7836(level, player, hand);
    }

    private void clearCard(class_1657 player, class_1937 level, class_1268 hand) {
        IMemoryCard mem = (IMemoryCard)player.method_5998(hand).method_7909();
        mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
        player.method_5998(hand).method_7980(null);
    }
}

