/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.stacks.AEItemKey;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class BiometricCardItem
extends AEBaseItem
implements IBiometricCard {
    public BiometricCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 p, class_1268 hand) {
        if (InteractionUtil.isInAlternateUseMode(p)) {
            this.encode(p.method_5998(hand), p);
            p.method_6104(hand);
            return class_1271.method_22427((Object)p.method_5998(hand));
        }
        return class_1271.method_22430((Object)p.method_5998(hand));
    }

    public class_1269 method_7847(class_1799 is, class_1657 player, class_1309 target, class_1268 hand) {
        if (target instanceof class_1657 && !InteractionUtil.isInAlternateUseMode(player)) {
            if (player.method_7337()) {
                is = player.method_5998(hand);
            }
            this.encode(is, (class_1657)target);
            player.method_6104(hand);
            return class_1269.method_29236((boolean)player.method_5770().method_8608());
        }
        return class_1269.field_5811;
    }

    public class_2561 method_7864(class_1799 is) {
        GameProfile profile = this.getProfile(is);
        return profile != null ? super.method_7864(is).method_27661().method_27693(" - " + profile.getName()) : super.method_7864(is);
    }

    private void encode(class_1799 is, class_1657 p) {
        GameProfile profile = this.getProfile(is);
        if (profile != null && profile.equals((Object)p.method_7334())) {
            this.setProfile(is, null);
        } else {
            this.setProfile(is, p.method_7334());
        }
    }

    @Override
    public void setProfile(class_1799 itemStack, GameProfile profile) {
        class_2487 tag = itemStack.method_7948();
        if (profile != null) {
            class_2487 pNBT = new class_2487();
            class_2512.method_10684((class_2487)pNBT, (GameProfile)profile);
            tag.method_10566("profile", (class_2520)pNBT);
        } else {
            tag.method_10551("profile");
        }
    }

    @Override
    public GameProfile getProfile(class_1799 is) {
        return this.getProfile(is.method_7969());
    }

    @Nullable
    public GameProfile getProfile(AEItemKey key) {
        return this.getProfile(key.getTag());
    }

    private GameProfile getProfile(@Nullable class_2487 tag) {
        if (tag != null && tag.method_10545("profile")) {
            return class_2512.method_10683((class_2487)tag.method_10562("profile"));
        }
        return null;
    }

    @Override
    public EnumSet<SecurityPermissions> getPermissions(class_1799 is) {
        return this.getPermissions(is.method_7969());
    }

    public EnumSet<SecurityPermissions> getPermissions(@Nullable class_2487 tag) {
        EnumSet<SecurityPermissions> result = EnumSet.noneOf(SecurityPermissions.class);
        if (tag != null) {
            for (SecurityPermissions sp : SecurityPermissions.values()) {
                if (!tag.method_10577(sp.name())) continue;
                result.add(sp);
            }
        }
        return result;
    }

    @Override
    public boolean hasPermission(class_1799 is, SecurityPermissions permission) {
        class_2487 tag = is.method_7948();
        return tag.method_10577(permission.name());
    }

    @Override
    public void removePermission(class_1799 itemStack, SecurityPermissions permission) {
        class_2487 tag = itemStack.method_7948();
        if (tag.method_10545(permission.name())) {
            tag.method_10551(permission.name());
        }
    }

    @Override
    public void addPermission(class_1799 itemStack, SecurityPermissions permission) {
        class_2487 tag = itemStack.method_7948();
        tag.method_10556(permission.name(), true);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        EnumSet<SecurityPermissions> perms = this.getPermissions(stack);
        if (perms.isEmpty()) {
            lines.add((class_2561)Tooltips.of(GuiText.NoPermissions, new Object[0]));
        } else {
            class_2561 msg = null;
            for (SecurityPermissions sp : perms) {
                if (msg == null) {
                    msg = sp.getDisplayName();
                    continue;
                }
                msg = msg.method_27661().method_27693(", ").method_10852(sp.getDisplayName());
            }
            lines.add((class_2561)msg.method_27661().method_10862(Tooltips.GREEN));
        }
    }
}

