/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.definitions.AEItems;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import appeng.util.prioritylist.MergedPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import java.util.Collection;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class ViewCellItem
extends AEBaseItem
implements ICellWorkbenchItem {
    public ViewCellItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static IPartitionList createItemFilter(Collection<class_1799> list) {
        return ViewCellItem.createFilter(AEItemKey.filter(), list);
    }

    public static IPartitionList createFilter(AEKeyFilter filter, Collection<class_1799> list) {
        MergedPriorityList myPartitionList = null;
        MergedPriorityList myMergedList = new MergedPriorityList();
        for (class_1799 currentViewCell : list) {
            if (currentViewCell == null || !(currentViewCell.method_7909() instanceof ViewCellItem)) continue;
            KeyCounter priorityList = new KeyCounter();
            ICellWorkbenchItem vc = (ICellWorkbenchItem)currentViewCell.method_7909();
            ConfigInventory config = vc.getConfigInventory(currentViewCell);
            FuzzyMode fzMode = vc.getFuzzyMode(currentViewCell);
            for (int i = 0; i < config.size(); ++i) {
                AEKey what = config.getKey(i);
                if (what == null || !filter.matches(what)) continue;
                priorityList.add(what, 1L);
            }
            if (priorityList.isEmpty()) continue;
            IUpgradeInventory upgrades = vc.getUpgrades(currentViewCell);
            boolean hasInverter = upgrades.isInstalled(AEItems.INVERTER_CARD);
            if (upgrades.isInstalled(AEItems.FUZZY_CARD)) {
                myMergedList.addNewList(new FuzzyPriorityList(priorityList, fzMode), !hasInverter);
            } else {
                myMergedList.addNewList(new PrecisePriorityList(priorityList), !hasInverter);
            }
            myPartitionList = myMergedList;
        }
        return myPartitionList;
    }

    @Override
    public boolean isEditable(class_1799 is) {
        return true;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 is) {
        return UpgradeInventories.forItem(is, 2);
    }

    @Override
    public ConfigInventory getConfigInventory(class_1799 is) {
        return CellConfig.create(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }
}

