/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.networking.energy.IAEPowerStorage;
import appeng.core.localization.InGameTooltip;
import appeng.integration.modules.waila.BaseDataProvider;
import appeng.util.Platform;
import java.util.List;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public final class PowerStorageDataProvider
extends BaseDataProvider {
    private static final String TAG_CURRENT_POWER = "currentPower";
    private static final String TAG_MAX_POWER = "maxPower";

    @Override
    public void appendBody(List<class_2561> tooltip, IBlockAccessor accessor, IPluginConfig config) {
        class_2487 tag = accessor.getServerData();
        if (tag.method_10573(TAG_MAX_POWER, 6)) {
            double currentPower = tag.method_10574(TAG_CURRENT_POWER);
            double maxPower = tag.method_10574(TAG_MAX_POWER);
            String formatCurrentPower = Platform.formatPower(currentPower, false);
            String formatMaxPower = Platform.formatPower(maxPower, false);
            tooltip.add((class_2561)InGameTooltip.Stored.text(formatCurrentPower, formatMaxPower));
        }
    }

    @Override
    public void appendServerData(class_2487 tag, class_3222 player, class_1937 level, class_2586 blockEntity) {
        IAEPowerStorage storage;
        if (blockEntity instanceof IAEPowerStorage && (storage = (IAEPowerStorage)blockEntity).getAEMaxPower() > 0.0) {
            tag.method_10549(TAG_CURRENT_POWER, storage.getAECurrentPower());
            tag.method_10549(TAG_MAX_POWER, storage.getAEMaxPower());
        }
    }
}

