/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.networking.IGridNode;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.parts.IPart;
import appeng.core.localization.InGameTooltip;
import appeng.integration.modules.waila.part.IPartDataProvider;
import appeng.me.service.AdHocNetworkError;
import appeng.me.service.PathingService;
import appeng.parts.networking.IUsedChannelProvider;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class ChannelDataProvider
implements IPartDataProvider {
    private static final String TAG_MAX_CHANNELS = "maxChannels";
    private static final String TAG_USED_CHANNELS = "usedChannels";
    private static final String TAG_ERROR = "channelError";

    @Override
    public void appendBody(IPart part, class_2487 partTag, List<class_2561> tooltip) {
        if (partTag.method_10573(TAG_ERROR, 8)) {
            ChannelError error = ChannelError.valueOf(partTag.method_10558(TAG_ERROR));
            tooltip.add((class_2561)error.text.text().method_27692(class_124.field_1061));
            return;
        }
        if (partTag.method_10573(TAG_MAX_CHANNELS, 3)) {
            int usedChannels = partTag.method_10550(TAG_USED_CHANNELS);
            int maxChannels = partTag.method_10550(TAG_MAX_CHANNELS);
            if (maxChannels <= 0) {
                tooltip.add((class_2561)InGameTooltip.Channels.text(usedChannels));
            } else {
                tooltip.add((class_2561)InGameTooltip.ChannelsOf.text(usedChannels, maxChannels));
            }
        }
    }

    @Override
    public void appendServerData(class_3222 player, IPart part, class_2487 partTag) {
        if (part instanceof IUsedChannelProvider) {
            IUsedChannelProvider usedChannelProvider = (IUsedChannelProvider)part;
            IGridNode gridNode = part.getGridNode();
            if (gridNode != null) {
                PathingService pathingService = (PathingService)gridNode.getGrid().getPathingService();
                if (pathingService.getControllerState() == ControllerState.NO_CONTROLLER) {
                    AdHocNetworkError adHocError = pathingService.getAdHocNetworkError();
                    if (adHocError != null) {
                        partTag.method_10582(TAG_ERROR, switch (adHocError) {
                            default -> throw new IncompatibleClassChangeError();
                            case AdHocNetworkError.NESTED_P2P_TUNNEL -> ChannelError.AD_HOC_NESTED_P2P_TUNNEL.name();
                            case AdHocNetworkError.TOO_MANY_CHANNELS -> ChannelError.AD_HOC_TOO_MANY_CHANNELS.name();
                        });
                        return;
                    }
                } else if (pathingService.getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                    partTag.method_10582(TAG_ERROR, ChannelError.CONTROLLER_CONFLICT.name());
                }
            }
            partTag.method_10569(TAG_USED_CHANNELS, usedChannelProvider.getUsedChannelsInfo());
            partTag.method_10569(TAG_MAX_CHANNELS, usedChannelProvider.getMaxChannelsInfo());
        }
    }

    static enum ChannelError {
        AD_HOC_NESTED_P2P_TUNNEL(InGameTooltip.ErrorNestedP2PTunnel),
        AD_HOC_TOO_MANY_CHANNELS(InGameTooltip.ErrorTooManyChannels),
        CONTROLLER_CONFLICT(InGameTooltip.ErrorControllerConflict);

        final InGameTooltip text;

        private ChannelError(InGameTooltip text) {
            this.text = text;
        }
    }
}

