/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.iface;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.helpers.externalstorage.GenericStackInv;
import java.util.List;
import net.minecraft.class_1799;

public class PatternProviderReturnInventory
extends GenericStackInv {
    public static int NUMBER_OF_SLOTS = 9;
    private boolean injectingIntoNetwork = false;

    public PatternProviderReturnInventory(Runnable listener) {
        super(listener, NUMBER_OF_SLOTS);
        this.useRegisteredCapacities();
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canInsert() {
        return !this.injectingIntoNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean injectIntoNetwork(MEStorage storage, IActionSource src) {
        boolean didSomething = false;
        this.injectingIntoNetwork = true;
        try {
            for (int i = 0; i < this.stacks.length; ++i) {
                GenericStack stack = this.stacks[i];
                if (stack == null) continue;
                long sizeBefore = stack.amount();
                long inserted = storage.insert(stack.what(), stack.amount(), Actionable.MODULATE, src);
                this.stacks[i] = inserted >= stack.amount() ? null : new GenericStack(stack.what(), stack.amount() - inserted);
                if (GenericStack.getStackSizeOrZero(this.stacks[i]) == sizeBefore) continue;
                didSomething = true;
            }
        }
        finally {
            this.injectingIntoNetwork = false;
        }
        return didSomething;
    }

    public void addDrops(List<class_1799> drops) {
        for (GenericStack stack : this.stacks) {
            AEKey aEKey;
            if (stack == null || !((aEKey = stack.what()) instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)aEKey;
            drops.add(itemKey.toStack((int)Math.min(Integer.MAX_VALUE, stack.amount())));
        }
    }
}

