/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.core.definitions.AEItems;
import appeng.facade.IFacadeItem;
import appeng.items.parts.FacadeItem;
import appeng.parts.CableBusStorage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class FacadeContainer
implements IFacadeContainer {
    private final CableBusStorage storage;
    private final Runnable changeCallback;

    public FacadeContainer(CableBusStorage cbs, Runnable changeCallback) {
        this.storage = cbs;
        this.changeCallback = changeCallback;
    }

    @Override
    public boolean canAddFacade(IFacadePart a) {
        return this.getFacade(a.getSide()) == null;
    }

    @Override
    public boolean addFacade(IFacadePart a) {
        if (this.canAddFacade(a)) {
            this.storage.setFacade(a.getSide(), a);
            this.notifyChange();
            return true;
        }
        return false;
    }

    @Override
    public void removeFacade(IPartHost host, class_2350 side) {
        if (side != null && this.storage.getFacade(side) != null) {
            this.storage.removeFacade(side);
            this.notifyChange();
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    @Override
    public IFacadePart getFacade(class_2350 side) {
        return this.storage.getFacade(side);
    }

    private String getNbtKey(class_2350 side) {
        return "facade:" + side.ordinal();
    }

    @Override
    public void readFromNBT(class_2487 c) {
        for (class_2350 side : class_2350.values()) {
            class_1792 class_17922;
            class_1799 is;
            this.storage.removeFacade(side);
            String key = this.getNbtKey(side);
            if (!c.method_10573(key, 10) || (is = class_1799.method_7915((class_2487)c.method_10562(key))).method_7960() || !((class_17922 = is.method_7909()) instanceof IFacadeItem)) continue;
            IFacadeItem facadeItem = (IFacadeItem)class_17922;
            this.storage.setFacade(side, facadeItem.createPartFromItemStack(is, side));
        }
    }

    @Override
    public void writeToNBT(class_2487 c) {
        for (class_2350 side : class_2350.values()) {
            if (this.storage.getFacade(side) == null) continue;
            class_2487 data = new class_2487();
            this.storage.getFacade(side).getItemStack().method_7953(data);
            c.method_10566(this.getNbtKey(side), (class_2520)data);
        }
    }

    @Override
    public boolean readFromStream(class_2540 out) {
        byte facadeSides = out.readByte();
        boolean changed = false;
        for (class_2350 side : class_2350.values()) {
            int ix = 1 << side.ordinal();
            if ((facadeSides & ix) == ix) {
                int id = out.method_10816();
                FacadeItem ifa = AEItems.FACADE.method_8389();
                class_1799 facade = ifa.createFromID(id);
                if (facade == null) continue;
                changed = changed || this.storage.getFacade(side) == null;
                this.storage.setFacade(side, ifa.createPartFromItemStack(facade, side));
                continue;
            }
            changed = changed || this.storage.getFacade(side) != null;
            this.storage.removeFacade(side);
        }
        return changed;
    }

    @Override
    public void writeToStream(class_2540 out) {
        int facadeSides = 0;
        for (class_2350 side : class_2350.values()) {
            if (this.getFacade(side) == null) continue;
            facadeSides |= 1 << side.ordinal();
        }
        out.writeByte((int)((byte)facadeSides));
        for (class_2350 side : class_2350.values()) {
            IFacadePart part = this.getFacade(side);
            if (part == null) continue;
            int itemID = class_1792.method_7880((class_1792)part.getItem());
            out.method_10804(itemID);
        }
    }

    @Override
    public boolean isEmpty() {
        for (class_2350 side : class_2350.values()) {
            if (this.storage.getFacade(side) == null) continue;
            return false;
        }
        return true;
    }

    private void notifyChange() {
        this.changeCallback.run();
    }
}

