/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.AELog;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.CraftingPatternEncoding;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.menu.NullMenu;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class CraftingPatternItem
extends EncodedPatternItem {
    public CraftingPatternItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    @Nullable
    public AECraftingPattern decode(class_1799 stack, class_1937 level, boolean tryRecovery) {
        class_2487 tag;
        if (stack.method_7909() != this || !stack.method_7985() || level == null) {
            return null;
        }
        AECraftingPattern result = this.decode(AEItemKey.of(stack), level);
        if (tryRecovery && result == null && this.attemptRecovery(tag = stack.method_7948(), level)) {
            result = this.decode(stack, level, false);
        }
        return result;
    }

    @Override
    public AECraftingPattern decode(AEItemKey what, class_1937 level) {
        if (what == null || !what.hasTag()) {
            return null;
        }
        try {
            return new AECraftingPattern(what, level);
        }
        catch (Exception e) {
            AELog.warn("Could not decode an invalid crafting pattern %s: %s", what.getTag(), e);
            return null;
        }
    }

    public class_1799 encode(class_3955 recipe, class_1799[] in, class_1799 out, boolean allowSubstitutes, boolean allowFluidSubstitutes) {
        class_1799 stack = new class_1799((class_1935)this);
        CraftingPatternEncoding.encodeCraftingPattern(stack.method_7948(), recipe, in, out, allowSubstitutes, allowFluidSubstitutes);
        return stack;
    }

    private boolean attemptRecovery(class_2487 tag, class_1937 level) {
        class_1863 recipeManager = level.method_8433();
        GenericStack[] ingredients = CraftingPatternEncoding.getCraftingInputs(tag);
        class_1799 product = CraftingPatternEncoding.getCraftingResult(tag);
        if (product.method_7960()) {
            return false;
        }
        class_2960 currentRecipeId = CraftingPatternEncoding.getRecipeId(tag);
        class_1715 testInventory = new class_1715((class_1703)new NullMenu(), 3, 3);
        for (int x = 0; x < 9; ++x) {
            GenericStack ais = x < ingredients.length ? ingredients[x] : null;
            AEKey aEKey = ais.what();
            if (!(aEKey instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)aEKey;
            testInventory.method_5447(x, itemKey.toStack());
        }
        class_3955 potentialRecipe = recipeManager.method_8132(class_3956.field_17545, (class_1263)testInventory, level).orElse(null);
        if (potentialRecipe != null && class_1799.method_31577((class_1799)product, (class_1799)potentialRecipe.method_8116((class_1263)testInventory))) {
            AELog.debug("Re-Encoding pattern from %s -> %s", currentRecipeId, potentialRecipe.method_8114());
            class_1799[] in = (class_1799[])Arrays.stream(ingredients).map(stack -> {
                class_1799 class_17992;
                AEKey patt3554$temp = stack.what();
                if (patt3554$temp instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)patt3554$temp;
                    class_17992 = itemKey.toStack();
                } else {
                    class_17992 = class_1799.field_8037;
                }
                return class_17992;
            }).toArray(class_1799[]::new);
            CraftingPatternEncoding.encodeCraftingPattern(tag, potentialRecipe, in, product, CraftingPatternEncoding.canSubstitute(tag), CraftingPatternEncoding.canSubstituteFluids(tag));
        }
        AELog.debug("Failed to recover encoded crafting pattern for recipe %s", currentRecipeId);
        return false;
    }
}

