/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEPatternHelper;
import appeng.crafting.pattern.CraftingPatternEncoding;
import appeng.crafting.pattern.IAEPatternDetails;
import appeng.helpers.FluidContainerHelper;
import appeng.menu.NullMenu;
import appeng.util.CraftingRemainders;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class AECraftingPattern
implements IAEPatternDetails {
    public static final int CRAFTING_GRID_DIMENSION = 3;
    public static final int CRAFTING_GRID_SLOTS = 9;
    private final AEItemKey definition;
    public final boolean canSubstitute;
    public final boolean canSubstituteFluids;
    private final class_3955 recipe;
    private final class_1715 testFrame;
    private final GenericStack[] sparseInputs;
    private final int[] sparseToCompressed = new int[9];
    private final Input[] inputs;
    private final class_1799 output;
    private final GenericStack[] outputsArray;
    private final Map<class_1792, Boolean>[] isValidCache = new Map[9];

    public AECraftingPattern(AEItemKey definition, class_1937 level) {
        this.definition = definition;
        class_2487 tag = Objects.requireNonNull(definition.getTag());
        this.canSubstitute = CraftingPatternEncoding.canSubstitute(tag);
        this.canSubstituteFluids = CraftingPatternEncoding.canSubstituteFluids(tag);
        this.sparseInputs = CraftingPatternEncoding.getCraftingInputs(tag);
        class_2960 recipeId = CraftingPatternEncoding.getRecipeId(tag);
        class_1860 recipe = (class_1860)level.method_8433().method_17717(class_3956.field_17545).get(recipeId);
        if (!(recipe instanceof class_3955)) {
            throw new IllegalStateException("recipe id '" + recipeId + "' is not a valid crafting recipe");
        }
        class_3955 craftingRecipe = (class_3955)recipe;
        this.recipe = craftingRecipe;
        this.testFrame = new class_1715((class_1703)new NullMenu(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            if (this.sparseInputs[i] == null) continue;
            AEItemKey itemKey = (AEItemKey)this.sparseInputs[i].what();
            this.testFrame.method_5447(i, itemKey.toStack());
        }
        if (!this.recipe.method_8115((class_1263)this.testFrame, level)) {
            throw new IllegalStateException("The recipe " + recipe + " no longer matches the encoded input.");
        }
        this.output = this.recipe.method_8116((class_1263)this.testFrame);
        if (this.output.method_7960()) {
            throw new IllegalStateException("The recipe " + recipeId + " produced an empty item stack result.");
        }
        this.outputsArray = new GenericStack[]{Objects.requireNonNull(GenericStack.fromItemStack(this.output))};
        GenericStack[] condensedInputs = AEPatternHelper.condenseStacks(this.sparseInputs);
        this.inputs = new Input[condensedInputs.length];
        for (int i = 0; i < 9; ++i) {
            this.sparseToCompressed[i] = -1;
        }
        for (int j = 0; j < condensedInputs.length; ++j) {
            GenericStack condensedInput = condensedInputs[j];
            for (int i = 0; i < 9; ++i) {
                if (this.sparseInputs[i] == null || !this.sparseInputs[i].what().equals(condensedInput.what())) continue;
                if (this.inputs[j] == null) {
                    this.inputs[j] = new Input(i, condensedInput);
                }
                this.sparseToCompressed[i] = j;
            }
        }
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AECraftingPattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.outputsArray;
    }

    private class_1856 getRecipeIngredient(int slot) {
        class_3955 class_39552 = this.recipe;
        if (class_39552 instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)class_39552;
            return this.getShapedRecipeIngredient(slot, shapedRecipe.method_8150());
        }
        return this.getShapelessRecipeIngredient(slot);
    }

    private class_1856 getShapedRecipeIngredient(int slot, int recipeWidth) {
        int topOffset = 0;
        if (this.sparseInputs[0] == null && this.sparseInputs[1] == null && this.sparseInputs[2] == null) {
            ++topOffset;
            if (this.sparseInputs[3] == null && this.sparseInputs[4] == null && this.sparseInputs[5] == null) {
                ++topOffset;
            }
        }
        int leftOffset = 0;
        if (this.sparseInputs[0] == null && this.sparseInputs[3] == null && this.sparseInputs[6] == null) {
            ++leftOffset;
            if (this.sparseInputs[1] == null && this.sparseInputs[4] == null && this.sparseInputs[7] == null) {
                ++leftOffset;
            }
        }
        int slotX = slot % 3 - leftOffset;
        int slotY = slot / 3 - topOffset;
        int ingredientIndex = slotY * recipeWidth + slotX;
        class_2371 ingredients = this.recipe.method_8117();
        if (ingredientIndex < 0 || ingredientIndex > ingredients.size()) {
            return class_1856.field_9017;
        }
        return (class_1856)ingredients.get(ingredientIndex);
    }

    private class_1856 getShapelessRecipeIngredient(int slot) {
        int ingredientIndex = 0;
        for (int i = 0; i < slot; ++i) {
            if (this.sparseInputs[i] == null) continue;
            ++ingredientIndex;
        }
        class_2371 ingredients = this.recipe.method_8117();
        if (ingredientIndex < ingredients.size()) {
            return (class_1856)ingredients.get(ingredientIndex);
        }
        return class_1856.field_9017;
    }

    @Nullable
    public GenericStack getValidFluid(int slot) {
        GenericStack itemOrFluid;
        int compressed = this.sparseToCompressed[slot];
        if (compressed != -1 && (itemOrFluid = this.inputs[compressed].possibleInputs[0]).what() instanceof AEFluidKey) {
            return itemOrFluid;
        }
        return null;
    }

    public boolean isItemValid(int slot, AEItemKey key, class_1937 level) {
        if (!this.canSubstitute) {
            return this.sparseInputs[slot] == null && key == null || this.sparseInputs[slot] != null && this.sparseInputs[slot].what().equals(key);
        }
        if (key == null) {
            return this.sparseInputs[slot] == null;
        }
        Boolean result = this.getTestResult(slot, key);
        if (result != null) {
            return result;
        }
        class_1799 previousStack = this.testFrame.method_5441(slot);
        this.testFrame.method_5447(slot, key.toStack());
        boolean newResult = this.recipe.method_8115((class_1263)this.testFrame, level) && class_1799.method_7973((class_1799)this.output, (class_1799)this.recipe.method_8116((class_1263)this.testFrame));
        this.setTestResult(slot, key, newResult);
        this.testFrame.method_5447(slot, previousStack);
        return newResult;
    }

    @Nullable
    private Boolean getTestResult(int slot, AEItemKey what) {
        if (what == null || what.hasTag()) {
            return null;
        }
        Map<class_1792, Boolean> cache = this.isValidCache[slot];
        if (cache == null) {
            return null;
        }
        return cache.get(what.getItem());
    }

    private void setTestResult(int slot, AEItemKey what, boolean result) {
        if (what != null && !what.hasTag()) {
            Map<class_1792, Boolean> cache = this.isValidCache[slot];
            if (cache == null) {
                cache = this.isValidCache[slot] = new IdentityHashMap<class_1792, Boolean>();
            }
            cache.put(what.getItem(), result);
        }
    }

    @Override
    public GenericStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    @Override
    public GenericStack[] getSparseOutputs() {
        return this.outputsArray;
    }

    public int getCompressedIndexFromSparse(int sparse) {
        return this.sparseToCompressed[sparse];
    }

    public class_1799 getOutput(class_1715 craftingContainer, class_1937 level) {
        for (int x = 0; x < craftingContainer.method_5439(); ++x) {
            GenericStack validFluid;
            class_1799 item = craftingContainer.method_5438(x);
            GenericStack stack = GenericStack.unwrapItemStack(item);
            if (stack != null && (validFluid = this.getValidFluid(x)) != null && validFluid.equals(stack) || this.isItemValid(x, AEItemKey.of(item), level)) continue;
            return class_1799.field_8037;
        }
        return this.output;
    }

    private GenericStack getItemOrFluidInput(int slot, GenericStack item) {
        AEKey aEKey = item.what();
        if (!(aEKey instanceof AEItemKey)) {
            return item;
        }
        AEItemKey itemKey = (AEItemKey)aEKey;
        GenericStack containedFluid = FluidContainerHelper.getContainedStack(itemKey.toStack());
        if (this.canSubstituteFluids && containedFluid != null && itemKey.getItem() instanceof class_1755) {
            class_1715 testFrameCopy = new class_1715((class_1703)new NullMenu(), 3, 3);
            for (int i = 0; i < 9; ++i) {
                testFrameCopy.method_5447(i, this.testFrame.method_5438(i).method_7972());
            }
            class_2371 remainingItems = this.recipe.method_8111((class_1263)testFrameCopy);
            class_1799 slotRemainder = (class_1799)remainingItems.get(slot);
            if (class_1799.method_7973((class_1799)slotRemainder, (class_1799)CraftingRemainders.getRemainder(itemKey.toStack()))) {
                return new GenericStack(containedFluid.what(), containedFluid.amount());
            }
        }
        return item;
    }

    private class Input
    implements IPatternDetails.IInput {
        private final int slot;
        private final GenericStack[] possibleInputs;
        private final long multiplier;

        private Input(int slot, GenericStack condensedInput) {
            this.slot = slot;
            this.multiplier = condensedInput.amount();
            GenericStack itemOrFluidInput = AECraftingPattern.this.getItemOrFluidInput(slot, AECraftingPattern.this.sparseInputs[slot]);
            if (!AECraftingPattern.this.canSubstitute) {
                this.possibleInputs = new GenericStack[]{itemOrFluidInput};
            } else {
                class_1799[] matchingStacks = AECraftingPattern.this.getRecipeIngredient(slot).method_8105();
                this.possibleInputs = new GenericStack[matchingStacks.length + 1];
                this.possibleInputs[0] = itemOrFluidInput;
                for (int i = 0; i < matchingStacks.length; ++i) {
                    this.possibleInputs[i + 1] = GenericStack.fromItemStack(matchingStacks[i]);
                }
            }
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.possibleInputs;
        }

        @Override
        public long getMultiplier() {
            return this.multiplier;
        }

        @Override
        public boolean isValid(AEKey input, class_1937 level) {
            if (input.matches(this.possibleInputs[0])) {
                return true;
            }
            if (AECraftingPattern.this.canSubstitute() && input instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)input;
                return AECraftingPattern.this.isItemValid(this.slot, itemKey, level);
            }
            return false;
        }

        @Override
        @Nullable
        public AEKey getContainerItem(AEKey template) {
            return CraftingRemainders.getRemainder(template);
        }
    }
}

