/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.packets.ICustomEntity;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public class SpawnEntityPacket
extends BasePacket {
    public static final double MAGICAL_QUANTIZATION = 8000.0;
    private int id;
    private UUID uuid;
    private double x;
    private double y;
    private double z;
    private int xa;
    private int ya;
    private int za;
    private int xRot;
    private int yRot;
    private class_1299<?> type;
    public static final double LIMIT = 3.9;
    private class_2540 extraData;

    public SpawnEntityPacket(class_2540 friendlyByteBuf) {
        this.id = friendlyByteBuf.method_10816();
        this.uuid = friendlyByteBuf.method_10790();
        this.type = (class_1299)class_2378.field_11145.method_10200(friendlyByteBuf.method_10816());
        this.x = friendlyByteBuf.readDouble();
        this.y = friendlyByteBuf.readDouble();
        this.z = friendlyByteBuf.readDouble();
        this.xRot = friendlyByteBuf.readByte();
        this.yRot = friendlyByteBuf.readByte();
        this.xa = friendlyByteBuf.readShort();
        this.ya = friendlyByteBuf.readShort();
        this.za = friendlyByteBuf.readShort();
        this.extraData = new class_2540(friendlyByteBuf.copy());
    }

    public SpawnEntityPacket(int id, UUID uuid, double x, double y, double z, float pitch, float yaw, class_1299<?> type, class_243 velocity, Consumer<class_2540> extraSpawnData) {
        this.id = id;
        this.uuid = uuid;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xRot = class_3532.method_15375((float)(pitch * 256.0f / 360.0f));
        this.yRot = class_3532.method_15375((float)(yaw * 256.0f / 360.0f));
        this.type = type;
        this.xa = (int)(class_3532.method_15350((double)velocity.field_1352, (double)-3.9, (double)3.9) * 8000.0);
        this.ya = (int)(class_3532.method_15350((double)velocity.field_1351, (double)-3.9, (double)3.9) * 8000.0);
        this.za = (int)(class_3532.method_15350((double)velocity.field_1350, (double)-3.9, (double)3.9) * 8000.0);
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.method_10804(this.id);
        data.method_10797(this.uuid);
        data.method_10804(class_2378.field_11145.method_10206(this.type));
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
        data.writeByte(this.xRot);
        data.writeByte(this.yRot);
        data.writeShort(this.xa);
        data.writeShort(this.ya);
        data.writeShort(this.za);
        extraSpawnData.accept(data);
        this.configureWrite(data);
    }

    public SpawnEntityPacket(class_1297 entity, Consumer<class_2540> extraSpawnData) {
        this(entity.method_5628(), entity.method_5667(), entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36455(), entity.method_36454(), entity.method_5864(), entity.method_18798(), extraSpawnData);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientPacketData(INetworkInfo network, class_1657 player) {
        class_638 world = (class_638)player.field_6002;
        class_1297 entity = this.type.method_5883((class_1937)world);
        if (entity != null) {
            entity.method_18003(this.x, this.y, this.z);
            entity.method_18800((double)this.xa, (double)this.ya, (double)this.za);
            entity.method_18003(this.x, this.y, this.z);
            entity.method_24203(this.x, this.y, this.z);
            entity.method_36457((float)(this.xRot * 360) / 256.0f);
            entity.method_36456((float)(this.yRot * 360) / 256.0f);
            entity.method_5838(this.id);
            entity.method_5826(this.uuid);
            if (entity instanceof ICustomEntity) {
                ((ICustomEntity)entity).readAdditionalSpawnData(this.extraData);
            }
            world.method_2942(this.id, entity);
        }
    }

    public static <T extends class_1297> class_2596<?> create(T entity) {
        ICustomEntity customEntity = (ICustomEntity)entity;
        SpawnEntityPacket packet = new SpawnEntityPacket(entity, customEntity::writeAdditionalSpawnData);
        return packet.toPacket(class_2598.field_11942);
    }
}

