/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.util.Platform;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class InventoryActionPacket
extends BasePacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final class_1799 slotItem;

    public InventoryActionPacket(class_2540 stream) {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        this.slotItem = stream.method_10819();
    }

    public InventoryActionPacket(InventoryAction action, int slot, class_1799 slotItem) {
        if (Platform.isClient() && action != InventoryAction.SET_FILTER) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem.method_7972();
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        data.method_10793(this.slotItem);
        this.configureWrite(data);
    }

    public InventoryActionPacket(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.method_10793(class_1799.field_8037);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_3222 player) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof AEBaseMenu) {
            AEBaseMenu baseMenu = (AEBaseMenu)class_17032;
            if (this.action == InventoryAction.SET_FILTER) {
                baseMenu.setFilter(this.slot, this.slotItem);
            } else {
                baseMenu.doAction(player, this.action, this.slot, this.id);
            }
        }
    }
}

