/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.client.render.FacingToRotation;
import java.util.EnumMap;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_793;

public class QuadRotator
implements RenderContext.QuadTransform {
    public static final RenderContext.QuadTransform NULL_TRANSFORM = quad -> true;
    private static final EnumMap<FacingToRotation, RenderContext.QuadTransform> TRANSFORMS = new EnumMap(FacingToRotation.class);
    private final FacingToRotation rotation;
    private final class_1158 quaternion;

    private QuadRotator(FacingToRotation rotation) {
        this.rotation = rotation;
        this.quaternion = rotation.getRot();
    }

    public static RenderContext.QuadTransform get(class_2350 newForward, class_2350 newUp) {
        return QuadRotator.get(QuadRotator.getRotation(newForward, newUp));
    }

    public static RenderContext.QuadTransform get(FacingToRotation rotation) {
        if (rotation.isRedundant()) {
            return NULL_TRANSFORM;
        }
        return TRANSFORMS.get((Object)rotation);
    }

    public boolean transform(MutableQuadView quad) {
        class_1160 tmp = new class_1160();
        for (int i = 0; i < 4; ++i) {
            quad.copyPos(i, tmp);
            tmp.method_4948(-0.5f, -0.5f, -0.5f);
            tmp.method_19262(this.quaternion);
            tmp.method_4948(0.5f, 0.5f, 0.5f);
            quad.pos(i, tmp);
            if (!quad.hasNormal(i)) continue;
            quad.copyNormal(i, tmp);
            tmp.method_19262(this.quaternion);
            quad.normal(i, tmp);
        }
        class_2350 nominalFace = quad.nominalFace();
        class_2350 cullFace = quad.cullFace();
        if (cullFace != null) {
            quad.cullFace(this.rotation.rotate(cullFace));
        }
        class_2350 rotatedNominalFace = this.rotation.rotate(nominalFace);
        quad.nominalFace(rotatedNominalFace);
        int[] data = new int[class_290.field_1590.method_1359() * 4];
        quad.toVanilla(0, data, 0, false);
        class_793.field_4249.method_3462(data, rotatedNominalFace);
        quad.fromVanilla(data, 0, false);
        return true;
    }

    private static FacingToRotation getRotation(class_2350 forward, class_2350 up) {
        if (forward.method_10166() == up.method_10166()) {
            up = up.method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11043 : class_2350.field_11036;
        }
        return FacingToRotation.get(forward, up);
    }

    static {
        for (FacingToRotation rotation : FacingToRotation.values()) {
            if (rotation.isRedundant()) {
                TRANSFORMS.put(rotation, NULL_TRANSFORM);
                continue;
            }
            TRANSFORMS.put(rotation, new QuadRotator(rotation));
        }
    }
}

