/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.inventories.IDynamicPartBakedModel;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.util.Platform;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class P2PTunnelFrequencyBakedModel
implements IDynamicPartBakedModel {
    private final Renderer renderer = RendererAccess.INSTANCE.getRenderer();
    private final class_1058 texture;
    private static final Cache<Long, Mesh> modelCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private static final int[][] QUAD_OFFSETS = new int[][]{{4, 10, 2}, {10, 10, 2}, {4, 4, 2}, {10, 4, 2}};

    public P2PTunnelFrequencyBakedModel(class_1058 texture) {
        this.texture = texture;
    }

    @Override
    public void emitQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context, class_2350 partSide, @Nullable Object modelData) {
        if (!(modelData instanceof Long)) {
            return;
        }
        long frequency = (Long)modelData;
        Mesh frequencyMesh = this.getFrequencyModel(frequency);
        if (frequencyMesh != null) {
            context.meshConsumer().accept(frequencyMesh);
        }
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    private Mesh createFrequencyMesh(short frequency, boolean active) {
        MeshBuilder meshBuilder = this.renderer.meshBuilder();
        AEColor[] colors = Platform.p2p().toColors(frequency);
        CubeBuilder cb = new CubeBuilder(meshBuilder.getEmitter());
        cb.setTexture(this.texture);
        cb.useStandardUV();
        cb.setEmissiveMaterial(active);
        for (int i = 0; i < 4; ++i) {
            int[] offs = QUAD_OFFSETS[i];
            for (int j = 0; j < 4; ++j) {
                AEColor col = colors[j];
                if (active) {
                    cb.setColorRGB(col.mediumVariant);
                } else {
                    float scale = 0.0011764707f;
                    cb.setColorRGB((float)(col.blackVariant >> 16 & 0xFF) * 0.0011764707f, (float)(col.blackVariant >> 8 & 0xFF) * 0.0011764707f, (float)(col.blackVariant & 0xFF) * 0.0011764707f);
                }
                int startx = j % 2;
                int starty = 1 - j / 2;
                cb.addCube(offs[0] + startx, offs[1] + starty, offs[2], offs[0] + startx + 1, offs[1] + starty + 1, offs[2] + 1);
            }
        }
        cb.setEmissiveMaterial(false);
        return meshBuilder.build();
    }

    private Mesh getFrequencyModel(long partFlags) {
        try {
            return (Mesh)modelCache.get((Object)partFlags, () -> {
                short frequency = (short)(partFlags & 0xFFFFL);
                boolean active = (partFlags & 0x10000L) != 0L;
                return this.createFrequencyMesh(frequency, active);
            });
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public boolean method_4708() {
        return false;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return false;
    }

    public boolean method_4713() {
        return true;
    }

    public class_1058 method_4711() {
        return this.texture;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }
}

