/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.interfaceterminal;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.stacks.AEItemKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.interfaceterminal.InterfaceRecord;
import appeng.client.gui.me.interfaceterminal.InterfaceSlot;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.AEConfig;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.implementations.InterfaceTerminalMenu;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_768;

public class InterfaceTerminalScreen<C extends InterfaceTerminalMenu>
extends AEBaseScreen<C> {
    private static final int GUI_WIDTH = 195;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 17;
    private static final int GUI_FOOTER_HEIGHT = 97;
    private static final int INTERFACE_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int DEFAULT_ROW_COUNT = 6;
    private static final int MIN_ROW_COUNT = 3;
    private static final int SLOT_SIZE = 18;
    private static final class_768 HEADER_BBOX = new class_768(0, 0, 195, 17);
    private static final class_768 ROW_TEXT_TOP_BBOX = new class_768(0, 17, 195, 18);
    private static final class_768 ROW_TEXT_MIDDLE_BBOX = new class_768(0, 53, 195, 18);
    private static final class_768 ROW_TEXT_BOTTOM_BBOX = new class_768(0, 89, 195, 18);
    private static final class_768 ROW_INVENTORY_TOP_BBOX = new class_768(0, 35, 195, 18);
    private static final class_768 ROW_INVENTORY_MIDDLE_BBOX = new class_768(0, 71, 195, 18);
    private static final class_768 ROW_INVENTORY_BOTTOM_BBOX = new class_768(0, 107, 195, 18);
    private static final class_768 FOOTER_BBOX = new class_768(0, 125, 195, 97);
    private final HashMap<Long, InterfaceRecord> byId = new HashMap();
    private final HashMultimap<String, InterfaceRecord> byName = HashMultimap.create();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");
    private final AETextField searchField;
    private boolean refreshList = false;
    private int numLines = 0;

    public InterfaceTerminalScreen(C menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.field_2792 = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar(new SettingToggleButton<TerminalStyle>(Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        this.searchField = this.widgets.addTextField("search");
        this.searchField.method_1863(str -> this.refreshList());
    }

    @Override
    public void method_25426() {
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        int maxLines = terminalStyle == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
        this.numLines = (this.field_22790 - 17 - 97) / 18;
        this.numLines = class_3532.method_15340((int)this.numLines, (int)3, (int)maxLines);
        this.field_2779 = 114 + this.numLines * 18;
        super.method_25426();
        this.method_20085((class_364)this.searchField);
        this.resetScrollbar();
    }

    @Override
    public void drawFG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((InterfaceTerminalMenu)this.field_2797).field_7761.removeIf(slot -> slot instanceof InterfaceSlot);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.numLines; ++i) {
            if (scrollLevel + i >= this.lines.size()) continue;
            Object lineObj = this.lines.get(scrollLevel + i);
            if (lineObj instanceof InterfaceRecord) {
                InterfaceRecord inv = (InterfaceRecord)lineObj;
                for (int z = 0; z < inv.getInventory().size(); ++z) {
                    ((InterfaceTerminalMenu)this.field_2797).field_7761.add((Object)new InterfaceSlot(inv, z, z * 18 + 8, (i + 1) * 18));
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            Object name = (String)lineObj;
            int rows = this.byName.get(name).size();
            if (rows > 1) {
                name = (String)name + " (" + rows + ")";
            }
            name = this.field_22793.method_27524((String)name, 155, true);
            this.field_22793.method_1729(poseStack, (String)name, 10.0f, (float)(23 + i * 18), textColor);
        }
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.method_25405(xCoord, yCoord)) {
            this.searchField.method_1852("");
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotIdx, int mouseButton, class_1713 clickType) {
        if (slot instanceof InterfaceSlot) {
            InventoryAction action = null;
            switch (clickType) {
                case field_7790: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case field_7794: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case field_7796: {
                    if (!this.getPlayer().method_31549().field_7477) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InterfaceSlot machineSlot = (InterfaceSlot)slot;
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.field_7875, machineSlot.getMachineInv().getServerId());
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        super.method_2383(slot, slotIdx, mouseButton, clickType);
    }

    @Override
    public void drawBG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture("guis/interfaceterminal.png");
        this.blit(poseStack, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 17;
        this.blit(poseStack, offsetX, currentY + this.numLines * 18, FOOTER_BBOX);
        for (int i = 0; i < this.numLines; ++i) {
            boolean firstLine = i == 0;
            boolean lastLine = i == this.numLines - 1;
            boolean isInvLine = false;
            if (scrollLevel + i < this.lines.size()) {
                Object lineObj = this.lines.get(scrollLevel + i);
                isInvLine = lineObj instanceof InterfaceRecord;
            }
            class_768 bbox = this.selectRowBackgroundBox(isInvLine, firstLine, lastLine);
            this.blit(poseStack, offsetX, currentY, bbox);
            currentY += 18;
        }
    }

    private class_768 selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean method_25400(char character, int key) {
        if (character == ' ' && this.searchField.method_1882().isEmpty()) {
            return true;
        }
        return super.method_25400(character, key);
    }

    public boolean method_25404(int keyCode, int scanCode, int p_keyPressed_3_) {
        return super.method_25404(keyCode, scanCode, p_keyPressed_3_);
    }

    public void postInventoryUpdate(boolean clearExistingData, long inventoryId, class_2487 invData) {
        if (clearExistingData) {
            this.byId.clear();
            this.refreshList = true;
        } else {
            class_5250 un = class_2561.class_2562.method_10877((String)invData.method_10558("un"));
            InterfaceRecord current = this.getById(inventoryId, invData.method_10537("sortBy"), (class_2561)un);
            for (int x = 0; x < current.getInventory().size(); ++x) {
                String which = Integer.toString(x);
                if (!invData.method_10545(which)) continue;
                current.getInventory().setItemDirect(x, class_1799.method_7915((class_2487)invData.method_10562(which)));
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        String searchFilterLowerCase = this.searchField.method_1882().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (InterfaceRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found) {
                class_1799 itemStack;
                Iterator<class_1799> iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getSearchName().contains(searchFilterLowerCase)) {
                this.byName.put((Object)entry.getDisplayName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.numLines * 18 - 2);
        this.scrollbar.setRange(0, this.lines.size() - this.numLines, 2);
    }

    private boolean itemStackMatchesSearchTerm(class_1799 itemStack, String searchTerm) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_2487 encodedValue = itemStack.method_7969();
        if (encodedValue == null) {
            return false;
        }
        class_2499 outTag = encodedValue.method_10554("out", 10);
        for (int i = 0; i < outTag.size(); ++i) {
            String displayName;
            class_1799 parsedItemStack = class_1799.method_7915((class_2487)outTag.method_10602(i));
            AEItemKey itemKey = AEItemKey.of(parsedItemStack);
            if (itemKey == null || !(displayName = itemKey.getDisplayName().getString().toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.method_25396().removeAll(this.field_33816);
        this.field_33816.clear();
        this.method_25426();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set(next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private InterfaceRecord getById(long id, long sortBy, class_2561 name) {
        InterfaceRecord o = this.byId.get(id);
        if (o == null) {
            o = new InterfaceRecord(id, 9, sortBy, name);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }

    private void blit(class_4587 poseStack, int offsetX, int offsetY, class_768 srcRect) {
        this.method_25302(poseStack, offsetX, offsetY, srcRect.method_3321(), srcRect.method_3322(), srcRect.method_3319(), srcRect.method_3320());
    }
}

