/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.spatial;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.events.statistics.GridChunkEvent;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.client.render.overlay.IOverlayDataSource;
import appeng.client.render.overlay.OverlayManager;
import appeng.me.service.StatisticsService;
import appeng.server.services.ChunkLoadingService;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerListener;
import com.google.common.collect.Multiset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class SpatialAnchorBlockEntity
extends AENetworkBlockEntity
implements IGridTickable,
IConfigManagerListener,
IConfigurableObject,
IOverlayDataSource {
    private static final int SPATIAL_TRANSFER_TEMPORARY_CHUNK_RANGE = 4;
    private final ConfigManager manager = new ConfigManager(this);
    private final Set<class_1923> chunks = new HashSet<class_1923>();
    private int powerlessTicks = 0;
    private boolean initialized = false;
    private boolean displayOverlay = false;
    private boolean isActive = false;

    public SpatialAnchorBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL).addService(IGridTickable.class, this);
        this.manager.registerSetting(Settings.OVERLAY_MODE, YesNo.NO);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.manager.writeToNBT(data);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.manager.readFromNBT(data);
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isActive());
        data.writeBoolean(this.displayOverlay);
        if (this.displayOverlay) {
            data.method_10789(this.chunks.stream().mapToLong(class_1923::method_8324).toArray());
        }
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean ret = super.readFromStream(data);
        boolean isActive = data.readBoolean();
        ret = isActive != this.isActive || ret;
        this.isActive = isActive;
        boolean newDisplayOverlay = data.readBoolean();
        ret = newDisplayOverlay != this.displayOverlay || ret;
        this.displayOverlay = newDisplayOverlay;
        this.chunks.clear();
        OverlayManager.getInstance().removeHandlers(this);
        if (this.displayOverlay) {
            this.chunks.addAll(Arrays.stream(data.method_10801(null)).mapToObj(class_1923::new).collect(Collectors.toSet()));
            OverlayManager.getInstance().showArea(this);
        }
        return ret;
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }

    @Override
    public Set<class_1923> getOverlayChunks() {
        return this.chunks;
    }

    @Override
    public class_2586 getOverlayBlockEntity() {
        return this;
    }

    @Override
    public DimensionalBlockPos getOverlaySourceLocation() {
        return new DimensionalBlockPos(this);
    }

    @Override
    public int getOverlayColor() {
        return Integer.MIN_VALUE | AEColor.TRANSPARENT.mediumVariant;
    }

    public void chunkAdded(GridChunkEvent.GridChunkAdded changed) {
        if (changed.getLevel() == this.getServerLevel()) {
            this.force(changed.getChunkPos());
        }
    }

    public void chunkRemoved(GridChunkEvent.GridChunkRemoved changed) {
        if (changed.getLevel() == this.getServerLevel()) {
            this.release(changed.getChunkPos(), true);
            this.wakeUp();
        }
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.markForUpdate();
            this.wakeUp();
        }
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.OVERLAY_MODE) {
            this.displayOverlay = manager.getSetting(setting) == YesNo.YES;
            this.markForUpdate();
        }
    }

    @Override
    public void method_11012() {
        super.method_11012();
        if (this.isClientSide()) {
            OverlayManager.getInstance().removeHandlers(this);
        } else {
            this.releaseAll();
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    private void wakeUp() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(20, 20, false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.initialized && this.getMainNode().isActive() && this.getMainNode().isPowered()) {
            this.forceAll();
            this.initialized = true;
        } else {
            this.cleanUp();
        }
        if (this.powerlessTicks > 200) {
            if (!this.getMainNode().isPowered() || !this.getMainNode().isActive()) {
                this.releaseAll();
            }
            this.powerlessTicks = 0;
            return TickRateModulation.SLEEP;
        }
        if (!this.getMainNode().isPowered() || !this.getMainNode().isActive()) {
            this.powerlessTicks += ticksSinceLastCall;
            return TickRateModulation.SAME;
        }
        return TickRateModulation.SLEEP;
    }

    public Set<class_1923> getLoadedChunks() {
        return this.chunks;
    }

    public int countLoadedChunks() {
        return this.chunks.size();
    }

    public boolean isPowered() {
        return this.getMainNode().isActive() && this.getMainNode().isPowered();
    }

    public boolean isActive() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            return this.isPowered();
        }
        return this.isActive;
    }

    public void registerChunk(class_1923 chunkPos) {
        this.chunks.add(chunkPos);
        this.updatePowerConsumption();
    }

    private void updatePowerConsumption() {
        int energy = 80 + this.chunks.size() * (this.chunks.size() + 1) / 2;
        this.getMainNode().setIdlePowerUsage(energy);
    }

    private void cleanUp() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        Multiset<class_1923> requiredChunks = grid.getService(StatisticsService.class).getChunks().get(this.getServerLevel());
        Iterator<class_1923> iterator = this.chunks.iterator();
        while (iterator.hasNext()) {
            class_1923 chunkPos = iterator.next();
            if (requiredChunks.contains((Object)chunkPos)) continue;
            this.release(chunkPos, false);
            iterator.remove();
        }
        for (class_1923 chunkPos : requiredChunks) {
            if (this.chunks.contains(chunkPos)) continue;
            this.force(chunkPos);
        }
    }

    private boolean force(class_1923 chunkPos) {
        if (this.method_11015()) {
            return false;
        }
        class_3218 level = this.getServerLevel();
        boolean forced = ChunkLoadingService.getInstance().forceChunk(level, this.method_11016(), chunkPos, true);
        if (forced) {
            this.chunks.add(chunkPos);
        }
        this.updatePowerConsumption();
        this.markForUpdate();
        return forced;
    }

    private boolean release(class_1923 chunkPos, boolean remove) {
        class_3218 level = this.getServerLevel();
        boolean removed = ChunkLoadingService.getInstance().releaseChunk(level, this.method_11016(), chunkPos, true);
        if (removed && remove) {
            this.chunks.remove(chunkPos);
        }
        this.updatePowerConsumption();
        this.markForUpdate();
        return removed;
    }

    private void forceAll() {
        this.getMainNode().ifPresent(grid -> {
            StatisticsService statistics = grid.getService(StatisticsService.class);
            for (class_1923 chunkPos : statistics.getChunks().get(this.getServerLevel()).elementSet()) {
                this.force(chunkPos);
            }
        });
    }

    void releaseAll() {
        for (class_1923 chunk : this.chunks) {
            this.release(chunk, false);
        }
        this.chunks.clear();
    }

    private class_3218 getServerLevel() {
        if (this.method_10997() instanceof class_3218) {
            return (class_3218)this.method_10997();
        }
        throw new IllegalStateException("Cannot be called on a client");
    }

    void doneMoving() {
        this.initialized = false;
        int d = 4;
        class_1923 center = new class_1923(this.method_11016());
        for (int x = center.field_9181 - d; x <= center.field_9181 + d; ++x) {
            for (int z = center.field_9180 - d; z <= center.field_9180 + d; ++z) {
                this.force(new class_1923(x, z));
            }
        }
    }

    static {
        GridHelper.addNodeOwnerEventHandler(GridChunkEvent.GridChunkAdded.class, SpatialAnchorBlockEntity.class, SpatialAnchorBlockEntity::chunkAdded);
        GridHelper.addNodeOwnerEventHandler(GridChunkEvent.GridChunkRemoved.class, SpatialAnchorBlockEntity.class, SpatialAnchorBlockEntity::chunkRemoved);
    }
}

