/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICrystalGrowthAccelerator;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import java.util.EnumSet;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class QuartzGrowthAcceleratorBlockEntity
extends AENetworkBlockEntity
implements IPowerChannelState,
ICrystalGrowthAccelerator {
    private boolean hasPower = false;

    public QuartzGrowthAcceleratorBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(class_2350.class));
        this.getMainNode().setFlags(new GridFlags[0]);
        this.getMainNode().setIdlePowerUsage(8.0);
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason == IGridNodeListener.State.POWER) {
            this.markForUpdate();
        }
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean hadPower = this.isPowered();
        this.setPowered(data.readBoolean());
        return this.isPowered() != hadPower || c;
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.getMainNode().isPowered());
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getUp(), this.getUp().method_10153()));
    }

    @Override
    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getUp(), this.getUp().method_10153()));
        super.onReady();
    }

    @Override
    public boolean isPowered() {
        if (!this.isClientSide()) {
            return this.getMainNode().isPowered();
        }
        return this.hasPower;
    }

    @Override
    public boolean isActive() {
        return this.isPowered();
    }

    private void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }
}

