/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.inventories;

import appeng.api.config.FuzzyMode;
import appeng.api.inventories.ContainerAdapter;
import appeng.api.inventories.EmptyInternalInventory;
import appeng.api.inventories.InternalInventoryIterator;
import appeng.api.inventories.InternalInventoryStorage;
import appeng.api.inventories.ItemTransfer;
import appeng.api.inventories.PlatformInventoryWrapper;
import appeng.api.inventories.SubInventoryProxy;
import appeng.util.helpers.ItemComparisonHelper;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.ApiStatus;

public interface InternalInventory
extends Iterable<class_1799>,
ItemTransfer {
    @Nullable
    public static ItemTransfer wrapExternal(@Nullable class_2586 be, class_2350 side) {
        if (be == null) {
            return null;
        }
        Storage storage = (Storage)ItemStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)side);
        if (storage != null) {
            return new PlatformInventoryWrapper((Storage<ItemVariant>)storage);
        }
        return null;
    }

    @Nullable
    public static ItemTransfer wrapExternal(class_1937 level, class_2338 pos, class_2350 side) {
        return InternalInventory.wrapExternal(level.method_8321(pos), side);
    }

    public static InternalInventory empty() {
        return EmptyInternalInventory.INSTANCE;
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public Storage<ItemVariant> toStorage() {
        return new InternalInventoryStorage(this);
    }

    default public class_1263 toContainer() {
        return new ContainerAdapter(this);
    }

    public int size();

    default public int getSlotLimit(int slot) {
        return 64;
    }

    public class_1799 getStackInSlot(int var1);

    public void setItemDirect(int var1, class_1799 var2);

    default public boolean isItemValid(int slot, class_1799 stack) {
        return true;
    }

    default public InternalInventory getSubInventory(int fromSlotInclusive, int toSlotExclusive) {
        return new SubInventoryProxy(this, fromSlotInclusive, toSlotExclusive);
    }

    default public InternalInventory getSlotInv(int slotIndex) {
        Preconditions.checkArgument((slotIndex >= 0 && slotIndex < this.size() ? 1 : 0) != 0, (Object)"slot out of range");
        return new SubInventoryProxy(this, slotIndex, slotIndex + 1);
    }

    default public int getRedstoneSignal() {
        ContainerAdapter adapter = new ContainerAdapter(this);
        return class_1703.method_7618((class_1263)adapter);
    }

    @Override
    default public Iterator<class_1799> iterator() {
        return new InternalInventoryIterator(this);
    }

    @Override
    default public class_1799 addItems(class_1799 stack) {
        return this.addItems(stack, false);
    }

    @Override
    default public class_1799 simulateAdd(class_1799 stack) {
        return this.addItems(stack, true);
    }

    @Override
    default public class_1799 addItems(class_1799 stack, boolean simulate) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (this.size() <= 54) {
            return this.addItemSlow(stack, simulate);
        }
        return this.addItemFast(stack, simulate);
    }

    private class_1799 addItemSlow(class_1799 stack, boolean simulate) {
        class_1799 remainder = stack.method_7972();
        for (int pass = 0; pass < 2; ++pass) {
            boolean fillEmptySlots = pass == 1;
            for (int slot = 0; slot < this.size(); ++slot) {
                if (this.getStackInSlot(slot).method_7960() == fillEmptySlots) {
                    remainder = this.insertItem(slot, remainder, simulate);
                }
                if (!remainder.method_7960()) continue;
                return class_1799.field_8037;
            }
        }
        return remainder;
    }

    private class_1799 addItemFast(class_1799 stack, boolean simulate) {
        class_1799 remainder = stack.method_7972();
        for (int slot = 0; slot < this.size(); ++slot) {
            if (!(remainder = this.insertItem(slot, remainder, simulate)).method_7960()) continue;
            return class_1799.field_8037;
        }
        return remainder;
    }

    @Override
    default public class_1799 removeItems(int amount, class_1799 filter, @Nullable Predicate<class_1799> destination) {
        int slots = this.size();
        class_1799 rv = class_1799.field_8037;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            class_1799 extracted;
            class_1799 is = this.getStackInSlot(slot);
            if (is.method_7960() || !filter.method_7960() && !class_1799.method_31577((class_1799)is, (class_1799)filter) || destination != null && ((extracted = this.extractItem(slot, amount, true)).method_7960() || !destination.test(extracted)) || (extracted = this.extractItem(slot, amount, false)).method_7960()) continue;
            if (rv.method_7960()) {
                rv = extracted;
                filter = extracted;
            } else {
                rv.method_7933(extracted.method_7947());
            }
            amount -= extracted.method_7947();
        }
        return rv;
    }

    @Override
    default public class_1799 simulateRemove(int amount, class_1799 filter, Predicate<class_1799> destination) {
        int slots = this.size();
        class_1799 rv = class_1799.field_8037;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            class_1799 extracted;
            class_1799 is = this.getStackInSlot(slot);
            if (is.method_7960() || !filter.method_7960() && !class_1799.method_31577((class_1799)is, (class_1799)filter) || (extracted = this.extractItem(slot, amount, true)).method_7960() || destination != null && !destination.test(extracted)) continue;
            if (rv.method_7960()) {
                rv = extracted.method_7972();
                filter = extracted;
            } else {
                rv.method_7933(extracted.method_7947());
            }
            amount -= extracted.method_7947();
        }
        return rv;
    }

    @Override
    default public class_1799 removeSimilarItems(int amount, class_1799 filter, FuzzyMode fuzzyMode, Predicate<class_1799> destination) {
        int slots = this.size();
        class_1799 extracted = class_1799.field_8037;
        for (int slot = 0; slot < slots && extracted.method_7960(); ++slot) {
            class_1799 simulated;
            class_1799 is = this.getStackInSlot(slot);
            if (is.method_7960() || !filter.method_7960() && !ItemComparisonHelper.isFuzzyEqualItem(is, filter, fuzzyMode) || destination != null && ((simulated = this.extractItem(slot, amount, true)).method_7960() || !destination.test(simulated))) continue;
            extracted = this.extractItem(slot, amount, false);
        }
        return extracted;
    }

    @Override
    default public class_1799 simulateSimilarRemove(int amount, class_1799 filter, FuzzyMode fuzzyMode, Predicate<class_1799> destination) {
        int slots = this.size();
        class_1799 extracted = class_1799.field_8037;
        for (int slot = 0; slot < slots && extracted.method_7960(); ++slot) {
            class_1799 is = this.getStackInSlot(slot);
            if (is.method_7960() || !filter.method_7960() && !ItemComparisonHelper.isFuzzyEqualItem(is, filter, fuzzyMode) || (extracted = this.extractItem(slot, amount, true)).method_7960() || destination == null || destination.test(extracted)) continue;
            extracted = class_1799.field_8037;
        }
        return extracted;
    }

    default public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        Preconditions.checkArgument((slot >= 0 && slot < this.size() ? 1 : 0) != 0, (Object)"slot out of range");
        if (stack.method_7960() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        class_1799 inSlot = this.getStackInSlot(slot);
        if (!inSlot.method_7960() && !class_1799.method_31577((class_1799)inSlot, (class_1799)stack)) {
            return stack;
        }
        int maxSpace = Math.min(this.getSlotLimit(slot), stack.method_7914());
        int freeSpace = maxSpace - inSlot.method_7947();
        if (freeSpace <= 0) {
            return stack;
        }
        int insertAmount = Math.min(stack.method_7947(), freeSpace);
        if (!simulate) {
            class_1799 newItem = inSlot.method_7960() ? stack.method_7972() : inSlot.method_7972();
            newItem.method_7939(inSlot.method_7947() + insertAmount);
            this.setItemDirect(slot, newItem);
        }
        if (freeSpace >= stack.method_7947()) {
            return class_1799.field_8037;
        }
        class_1799 r = stack.method_7972();
        r.method_7934(insertAmount);
        return r;
    }

    default public class_1799 extractItem(int slot, int amount, boolean simulate) {
        class_1799 item = this.getStackInSlot(slot);
        if (item.method_7960()) {
            return class_1799.field_8037;
        }
        if (amount >= item.method_7947()) {
            if (!simulate) {
                this.setItemDirect(slot, class_1799.field_8037);
                return item;
            }
            return item.method_7972();
        }
        class_1799 result = item.method_7972();
        result.method_7939(amount);
        if (!simulate) {
            class_1799 reduced = item.method_7972();
            reduced.method_7934(amount);
            this.setItemDirect(slot, reduced);
        }
        return result;
    }

    @Override
    default public boolean mayAllowTransfer() {
        return this.size() > 0;
    }

    @ApiStatus.Internal
    default public void sendChangeNotification(int slot) {
    }
}

