/*
 * Decompiled with CFR 0.152.
 */
package draylar.staffofbuilding.api;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_4538;

public class SelectionCalculator {
    public static List<class_2338> calculateSelection(class_1937 world, class_2338 originPos, class_2350 direction, int maxChecks) {
        class_2338 offsetPos = originPos.method_10093(direction);
        class_2680 originState = world.method_8320(originPos);
        ArrayList selectedPositions = new ArrayList();
        int checks = 1;
        ArrayList<Object> storedNeighbors = new ArrayList<Object>();
        if (world.method_8628(originState, offsetPos, class_3726.method_16194())) {
            storedNeighbors.add(offsetPos);
        }
        while (checks < maxChecks && !storedNeighbors.isEmpty()) {
            selectedPositions.addAll(storedNeighbors);
            ArrayList<class_2338> newNeighbors = new ArrayList<class_2338>();
            for (class_2338 class_23382 : storedNeighbors) {
                List<class_2338> facingNeighbors = SelectionCalculator.getValidNeighbors(world, class_23382, direction, originState);
                for (class_2338 facingNeighbor : facingNeighbors) {
                    if (checks >= maxChecks || selectedPositions.contains(facingNeighbor) || storedNeighbors.contains(facingNeighbor) || newNeighbors.contains(facingNeighbor)) continue;
                    newNeighbors.add(facingNeighbor);
                    ++checks;
                }
            }
            storedNeighbors.clear();
            storedNeighbors.addAll(newNeighbors);
        }
        selectedPositions.addAll(storedNeighbors);
        return selectedPositions.stream().filter(pos -> originState.method_26184((class_4538)world, pos)).collect(Collectors.toList());
    }

    private static List<class_2338> getValidNeighbors(class_1937 world, class_2338 startPos, class_2350 facingDirection, class_2680 originState) {
        ArrayList<class_2338> foundNeighbors = new ArrayList<class_2338>();
        for (class_2382 checkDirection : SelectionCalculator.getPotentialNeighbors(facingDirection)) {
            class_2338 offsetPos = startPos.method_10081(checkDirection);
            class_2680 innerState = world.method_8320(offsetPos.method_10093(facingDirection.method_10153()));
            class_2680 newState = world.method_8320(offsetPos);
            if (!innerState.equals(originState) || !newState.method_26215() && newState.method_26227().method_15769() || !world.method_8628(originState, offsetPos, class_3726.method_16194())) continue;
            foundNeighbors.add(offsetPos);
        }
        return foundNeighbors;
    }

    private static List<class_2382> getPotentialNeighbors(class_2350 direction) {
        ArrayList<class_2382> directions = new ArrayList<class_2382>();
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            directions.add(class_2350.field_11043.method_10163());
            directions.add(class_2350.field_11034.method_10163());
            directions.add(class_2350.field_11035.method_10163());
            directions.add(class_2350.field_11039.method_10163());
            directions.add(class_2350.field_11039.method_10163().method_23226(class_2350.field_11043, 1));
            directions.add(class_2350.field_11043.method_10163().method_23226(class_2350.field_11034, 1));
            directions.add(class_2350.field_11034.method_10163().method_23226(class_2350.field_11035, 1));
            directions.add(class_2350.field_11035.method_10163().method_23226(class_2350.field_11039, 1));
        } else {
            directions.add(direction.method_10170().method_10163());
            directions.add(direction.method_10160().method_10163());
            directions.add(class_2350.field_11036.method_10163());
            directions.add(class_2350.field_11033.method_10163());
        }
        return directions;
    }
}

