/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.mixin;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.config.ScrollTypeConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public class ServerPlayerEntityMixin {
    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void onRespawn(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (alive) {
            return;
        }
        class_3222 player = (class_3222)this;
        UUID userId = player.method_5667();
        if (player.method_14220().method_8450().method_8355(class_1928.field_19389)) {
            return;
        }
        player.method_31548().method_5448();
        for (YigdApi yigdApi : Yigd.apiMods) {
            yigdApi.dropAll((class_1657)player);
        }
        List<Object> modSoulbounds = DeadPlayerData.Soulbound.getModdedSoulbound(userId);
        class_2371<class_1799> soulboundItems = DeadPlayerData.Soulbound.getSoulboundInventory(userId);
        if (soulboundItems != null || modSoulbounds != null) {
            if (soulboundItems != null && soulboundItems.size() > 0) {
                int i;
                List armorInventory = soulboundItems.subList(36, 40);
                List mainInventory = soulboundItems.subList(0, 36);
                for (class_1799 itemStack : armorInventory) {
                    class_1304 equipmentSlot = class_1308.method_32326((class_1799)itemStack);
                    if (itemStack.method_7960()) continue;
                    player.method_5673(equipmentSlot, itemStack);
                }
                player.method_5673(class_1304.field_6171, (class_1799)soulboundItems.get(40));
                class_1661 inventory = player.method_31548();
                for (i = 0; i < Math.min(inventory.method_5439(), mainInventory.size()); ++i) {
                    inventory.method_5447(i, (class_1799)mainInventory.get(i));
                }
                if (soulboundItems.size() > 41) {
                    for (i = 41; i < Math.min(soulboundItems.size(), inventory.method_5439()); ++i) {
                        inventory.method_5447(i, (class_1799)soulboundItems.get(i));
                    }
                }
            }
            Yigd.NEXT_TICK.add(() -> {
                if (modSoulbounds != null && modSoulbounds.size() > 0) {
                    for (int i = 0; i < Math.min(Yigd.apiMods.size(), modSoulbounds.size()); ++i) {
                        YigdApi yigdApi = Yigd.apiMods.get(i);
                        Object modSoulbound = modSoulbounds.get(i);
                        yigdApi.setInventory(modSoulbound, (class_1657)player);
                    }
                }
            });
            DeadPlayerData.Soulbound.dropModdedSoulbound(userId);
            DeadPlayerData.Soulbound.dropSoulbound(userId);
        }
        try {
            List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(userId);
            if (deadPlayerData != null && deadPlayerData.size() > 0) {
                DeadPlayerData latestDeath = deadPlayerData.get(deadPlayerData.size() - 1);
                class_2338 deathPos = latestDeath.gravePos;
                this.giveScroll((class_1657)player, deathPos);
                if (deathPos != null && YigdConfig.getConfig().graveSettings.tellDeathPos) {
                    player.method_7353((class_2561)new class_2588("text.yigd.message.grave_location_info", new Object[]{deathPos.method_10263(), deathPos.method_10264(), deathPos.method_10260(), latestDeath.dimensionName}), false);
                }
            }
        }
        catch (Exception e) {
            Yigd.LOGGER.warn("Death data did not generate\n" + e);
        }
    }

    private void giveScroll(class_1657 player, class_2338 refPos) {
        YigdConfig.UtilitySettings utilityConfig = YigdConfig.getConfig().utilitySettings;
        if (utilityConfig.scrollItem.scrollType == ScrollTypeConfig.DISABLED || !utilityConfig.scrollItem.retrieveOnRespawn) {
            return;
        }
        class_1799 stack = Yigd.SCROLL_ITEM.method_7854();
        class_2487 posNbt = class_2512.method_10692((class_2338)refPos);
        stack.method_7959("ref", (class_2520)posNbt);
        player.method_7270(stack);
    }

    @Redirect(method={"createEndSpawnPlatform"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z"))
    private boolean createEndSpawnPlatform(class_3218 world, class_2338 blockPos, class_2680 blockState) {
        GraveBlockEntity grave;
        class_2586 be = world.method_8321(blockPos);
        if (!(be instanceof GraveBlockEntity) || (grave = (GraveBlockEntity)be).getGraveOwner() == null) {
            return world.method_8501(blockPos, blockState);
        }
        return false;
    }
}

