/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.core;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.GraveHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class YigdCommand {
    public static void registerCommands() {
        YigdConfig.CommandToggles config = YigdConfig.getConfig().commandToggles;
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"yigd").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restore").requires(source -> source.method_9259(4) && config.retrieveGrave)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> YigdCommand.restoreGrave((class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"), (class_1657)((class_2168)ctx.getSource()).method_9207())))).executes(ctx -> YigdCommand.restoreGrave((class_1657)((class_2168)ctx.getSource()).method_9207(), (class_1657)((class_2168)ctx.getSource()).method_9207())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rob").requires(source -> source.method_9259(4) && config.robGrave)).then(class_2170.method_9244((String)"victim", (ArgumentType)class_2186.method_9305()).executes(ctx -> YigdCommand.robGrave((class_1657)class_2186.method_9315((CommandContext)ctx, (String)"victim"), (class_1657)((class_2168)ctx.getSource()).method_9207()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"grave").requires(source -> config.selfView || source.method_9259(4))).executes(ctx -> YigdCommand.viewGrave((class_1657)((class_2168)ctx.getSource()).method_9207(), (class_1657)((class_2168)ctx.getSource()).method_9207()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(4) && config.adminView)).executes(ctx -> YigdCommand.viewGrave((class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"), (class_1657)((class_2168)ctx.getSource()).method_9207()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"moderate").requires(source -> source.method_9259(4) && config.moderateGraves)).executes(ctx -> YigdCommand.moderateGraves(((class_2168)ctx.getSource()).method_9207())))));
    }

    private static int moderateGraves(class_3222 player) {
        boolean existsGraves = false;
        for (List<DeadPlayerData> data : DeathInfoManager.INSTANCE.data.values()) {
            if (data.size() <= 0) continue;
            existsGraves = true;
            break;
        }
        if (!existsGraves) {
            player.method_7353((class_2561)new class_2588("text.yigd.message.grave_not_found"), false);
            return 0;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(DeathInfoManager.INSTANCE.data.size());
        DeathInfoManager.INSTANCE.data.forEach((uuid, deadPlayerData) -> {
            buf.method_10797(uuid);
            buf.writeInt(deadPlayerData.size());
            for (DeadPlayerData data : deadPlayerData) {
                buf.method_10794(data.toNbt());
            }
        });
        ServerPlayNetworking.send((class_3222)player, (class_2960)new class_2960("yigd", "all_dead_people"), (class_2540)buf);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int viewGrave(class_1657 player, class_1657 commandUser) {
        UUID userId = player.method_5667();
        if (commandUser instanceof class_3222) {
            class_3222 spe = (class_3222)commandUser;
            if (DeathInfoManager.INSTANCE.data.containsKey(userId) && DeathInfoManager.INSTANCE.data.get(userId).size() > 0) {
                List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(userId);
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(deadPlayerData.size());
                Iterator<DeadPlayerData> iterator = deadPlayerData.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        ServerPlayNetworking.send((class_3222)spe, (class_2960)new class_2960("yigd", "single_dead_guy"), (class_2540)buf);
                        Yigd.LOGGER.info("Sending packet to " + spe.method_5476().method_10851() + " with grave info");
                        return 1;
                    }
                    DeadPlayerData data = iterator.next();
                    buf.method_10794(data.toNbt());
                }
            }
        }
        commandUser.method_7353((class_2561)new class_2588("text.yigd.message.view_command.fail", new Object[]{player.method_5476().method_10851()}).method_27694(style -> style.method_36139(0xFF0000)), false);
        return 0;
    }

    private static class_3218 worldFromId(@Nullable MinecraftServer server, class_2960 worldId) {
        class_3218 world;
        block1: {
            class_3218 serverWorld;
            world = null;
            if (server == null) break block1;
            Iterator iterator = server.method_3738().iterator();
            while (iterator.hasNext() && (world = (serverWorld = (class_3218)iterator.next())).method_27983().method_29177() != worldId) {
            }
        }
        return world;
    }

    private static int robGrave(class_1657 victim, class_1657 stealer) {
        UUID userId = victim.method_5667();
        if (!DeathInfoManager.INSTANCE.data.containsKey(userId)) {
            stealer.method_7353((class_2561)new class_2588("text.yigd.message.rob_command.fail"), true);
            return 0;
        }
        List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(userId);
        if (deadPlayerData.size() <= 0) {
            stealer.method_7353((class_2561)new class_2588("text.yigd.message.unclaimed_grave_missing", new Object[]{victim.method_5476().method_10851()}).method_27694(style -> style.method_36139(0xFF0000)), true);
            return 0;
        }
        DeadPlayerData latestDeath = deadPlayerData.remove(deadPlayerData.size() - 1);
        DeathInfoManager.INSTANCE.method_80();
        HashMap<String, Object> modInv = new HashMap<String, Object>();
        for (int i = 0; i < Yigd.apiMods.size(); ++i) {
            YigdApi yigdApi = Yigd.apiMods.get(i);
            modInv.put(yigdApi.getModName(), latestDeath.modInventories.get(i));
        }
        class_3218 world = YigdCommand.worldFromId(stealer.method_5682(), latestDeath.worldId);
        if (world != null && latestDeath.gravePos != null && !world.method_8320(latestDeath.gravePos).method_26204().equals((Object)Yigd.GRAVE_BLOCK)) {
            world.method_8650(latestDeath.gravePos, false);
            if (YigdConfig.getConfig().graveSettings.dropGraveBlock) {
                class_1264.method_5449((class_1937)world, (double)latestDeath.gravePos.method_10263(), (double)latestDeath.gravePos.method_10264(), (double)latestDeath.gravePos.method_10260(), (class_1799)Yigd.GRAVE_BLOCK.method_8389().method_7854());
            }
        }
        GraveHelper.RetrieveItems(stealer, latestDeath.inventory, modInv, latestDeath.xp, true);
        stealer.method_7353((class_2561)new class_2588("text.yigd.message.rob_command.success"), true);
        victim.method_7353((class_2561)new class_2588("text.yigd.message.rob_command.victim"), false);
        return 1;
    }

    private static int restoreGrave(class_1657 player, class_1657 commandUser) {
        UUID userId = player.method_5667();
        if (!DeathInfoManager.INSTANCE.data.containsKey(userId)) {
            commandUser.method_7353((class_2561)new class_2588("text.yigd.message.restore_command.fail"), true);
            return -1;
        }
        List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(userId);
        if (deadPlayerData.size() <= 0) {
            commandUser.method_7353((class_2561)new class_2588("text.yigd.message.unclaimed_grave_missing", new Object[]{player.method_5476().method_10851()}).method_27694(style -> style.method_36139(0xFF0000)), false);
            return -1;
        }
        DeadPlayerData latestDeath = deadPlayerData.remove(deadPlayerData.size() - 1);
        DeathInfoManager.INSTANCE.method_80();
        HashMap<String, Object> modInv = new HashMap<String, Object>();
        for (int i = 0; i < Yigd.apiMods.size(); ++i) {
            YigdApi yigdApi = Yigd.apiMods.get(i);
            modInv.put(yigdApi.getModName(), latestDeath.modInventories.get(i));
        }
        class_3218 world = YigdCommand.worldFromId(player.method_5682(), latestDeath.worldId);
        if (world != null && latestDeath.gravePos != null && !world.method_8320(latestDeath.gravePos).method_26204().equals((Object)Yigd.GRAVE_BLOCK)) {
            world.method_8650(latestDeath.gravePos, false);
            if (YigdConfig.getConfig().graveSettings.dropGraveBlock) {
                class_1264.method_5449((class_1937)world, (double)latestDeath.gravePos.method_10263(), (double)latestDeath.gravePos.method_10264(), (double)latestDeath.gravePos.method_10260(), (class_1799)Yigd.GRAVE_BLOCK.method_8389().method_7854());
            }
        }
        GraveHelper.RetrieveItems(player, latestDeath.inventory, modInv, latestDeath.xp, false);
        commandUser.method_7353((class_2561)new class_2588("text.yigd.message.restore_command.success"), true);
        return 1;
    }
}

