/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.gui;

import com.b1n_ry.yigd.client.gui.GraveSelectScreen;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class PlayerSelectScreen
extends class_437 {
    private final class_2960 GRAVE_SELECT_TEXTURE = new class_2960("yigd", "textures/gui/select_menu.png");
    private final class_2960 SELECT_ELEMENT_TEXTURE = new class_2960("yigd", "textures/gui/select_elements.png");
    private final List<UUID> playerIds;
    private final Map<UUID, List<DeadPlayerData>> data;
    private final Map<UUID, class_2960> playerSkinTextures;
    private final Map<UUID, GameProfile> graveOwners;
    private final int page;
    private boolean mouseIsClicked = false;
    private String hoveredElement = null;

    public PlayerSelectScreen(Map<UUID, List<DeadPlayerData>> data, int page) {
        super((class_2561)new class_2588("text.yigd.gui.player_select.title"));
        ArrayList<UUID> playerIds = new ArrayList<UUID>();
        HashMap<UUID, List<DeadPlayerData>> nonEmpty = new HashMap<UUID, List<DeadPlayerData>>();
        HashMap<UUID, class_2960> playerSkinTextures = new HashMap<UUID, class_2960>();
        HashMap<UUID, GameProfile> graveOwners = new HashMap<UUID, GameProfile>();
        data.forEach((uuid, userData) -> {
            if (userData.size() > 0) {
                GameProfile profile = ((DeadPlayerData)userData.get((int)0)).graveOwner;
                playerIds.add((UUID)uuid);
                nonEmpty.put((UUID)uuid, (List<DeadPlayerData>)userData);
                graveOwners.put((UUID)uuid, profile);
                class_2960 defaultPlayerSkin = class_1068.method_4648((UUID)uuid);
                class_310 minecraftClient = class_310.method_1551();
                if (minecraftClient != null) {
                    Map map = minecraftClient.method_1582().method_4654(profile);
                    if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        playerSkinTextures.put((UUID)uuid, minecraftClient.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
                    } else {
                        playerSkinTextures.put((UUID)uuid, defaultPlayerSkin);
                    }
                } else {
                    playerSkinTextures.put((UUID)uuid, defaultPlayerSkin);
                }
            }
        });
        this.playerIds = playerIds;
        this.data = nonEmpty;
        this.playerSkinTextures = playerSkinTextures;
        this.page = page;
        this.graveOwners = graveOwners;
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode) || keyCode == 259) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredElement != null) {
            this.mouseIsClicked = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.mouseIsClicked = false;
        if (button == 0 && this.hoveredElement != null && this.field_22787 != null) {
            UUID parsedString;
            if (this.hoveredElement.equals("left") && this.page > 1) {
                PlayerSelectScreen screen = new PlayerSelectScreen(this.data, this.page - 1);
                this.field_22787.method_1507((class_437)screen);
            } else if (this.hoveredElement.equals("right") && this.data.size() > this.page * 4) {
                PlayerSelectScreen screen = new PlayerSelectScreen(this.data, this.page + 1);
                this.field_22787.method_1507((class_437)screen);
            } else if (this.isUuid(this.hoveredElement) && this.data.containsKey(parsedString = UUID.fromString(this.hoveredElement))) {
                GraveSelectScreen screen = new GraveSelectScreen(this.data.get(parsedString), 1, this);
                this.field_22787.method_1507((class_437)screen);
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int screenWidth = 220;
        int screenHeight = 200;
        int originX = this.field_22789 / 2;
        int originY = this.field_22790 / 2;
        int screenLeft = originX - 110;
        int screenTop = originY - 100;
        this.hoveredElement = null;
        RenderSystem.setShaderTexture((int)0, (class_2960)this.GRAVE_SELECT_TEXTURE);
        this.method_25302(matrices, screenLeft, screenTop, 0, 0, 220, 200);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > screenLeft + 6 && mouseX < screenLeft + 14 && mouseY > originY - 8 && mouseY < originY + 7) {
            this.hoveredElement = "left";
        } else if (mouseX > screenLeft + 220 - 14 && mouseX < screenLeft + 220 - 6 && mouseY > originY - 8 && mouseY < originY + 7) {
            this.hoveredElement = "right";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("left") && this.mouseIsClicked) {
            this.method_25302(matrices, screenLeft + 6, originY - 8, 16, 84, 8, 15);
        } else {
            this.method_25302(matrices, screenLeft + 6, originY - 8, 0, 84, 8, 15);
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("right") && this.mouseIsClicked) {
            this.method_25302(matrices, screenLeft + 220 - 14, originY - 8, 24, 84, 8, 15);
        } else {
            this.method_25302(matrices, screenLeft + 220 - 14, originY - 8, 8, 84, 8, 15);
        }
        int infoSize = this.playerIds.size();
        int startValue = (this.page - 1) * 4;
        int whileLessThan = startValue + Math.min(4, infoSize - startValue);
        for (int i = startValue; i < whileLessThan; ++i) {
            UUID playerId = this.playerIds.get(i);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
            int left = screenLeft + 19;
            int top = screenTop + 24 + 42 * i - startValue;
            int width = 182;
            int height = 42;
            if (mouseX > left && mouseX < left + width && mouseY > top && mouseY < top + height) {
                this.hoveredElement = playerId.toString();
            }
            if (this.hoveredElement != null && this.hoveredElement.equals(playerId.toString()) && this.mouseIsClicked) {
                this.method_25302(matrices, left, top, 0, height, width, height);
            } else {
                this.method_25302(matrices, left, top, 0, 0, width, height);
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)this.playerSkinTextures.get(playerId));
            this.method_25302(matrices, left + 5, top + 5, 32, 32, 32, 32);
            this.field_22793.method_1729(matrices, this.graveOwners.get(playerId).getName(), (float)(left + 42), (float)(top + 7), 39168);
            this.field_22793.method_1729(matrices, this.data.get(playerId).size() + " graves", (float)(left + 42), (float)(top + 22), 0x555555);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        String gravesDisplayed = startValue + 1 + "-" + whileLessThan + "/" + infoSize;
        this.field_22793.method_1729(matrices, "Players with graves", (float)screenLeft + 19.0f, (float)screenTop + 10.0f, 0x555555);
        int offset = this.field_22793.method_1727(gravesDisplayed);
        this.field_22793.method_1729(matrices, gravesDisplayed, (float)(screenLeft + 220) - 19.0f - (float)offset, (float)screenTop + 10.0f, 30464);
    }

    private boolean isUuid(String intString) {
        if (intString == null) {
            return false;
        }
        try {
            UUID.fromString(intString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

