/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.gui;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.client.gui.GraveViewScreen;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class GraveSelectScreen
extends class_437 {
    private final class_2960 GRAVE_SELECT_TEXTURE = new class_2960("yigd", "textures/gui/select_menu.png");
    private final class_2960 SELECT_ELEMENT_TEXTURE = new class_2960("yigd", "textures/gui/select_elements.png");
    private final List<DeadPlayerData> data;
    private final List<GuiGraveInfo> graveInfo;
    private final int page;
    private final class_437 previousScreen;
    private final GameProfile graveOwner;
    private boolean mouseIsClicked = false;
    private String hoveredElement = null;

    public GraveSelectScreen(List<DeadPlayerData> data, int page, class_437 previousScreen) {
        super((class_2561)new class_2588("text.yigd.gui.grave_select.title"));
        ArrayList<GuiGraveInfo> info = new ArrayList<GuiGraveInfo>();
        for (DeadPlayerData deadData : data) {
            int size = 0;
            for (class_1799 stack : deadData.inventory) {
                if (stack.method_7960()) continue;
                ++size;
            }
            for (int i = 0; i < deadData.modInventories.size(); ++i) {
                YigdApi yigdApi = Yigd.apiMods.get(i);
                size += yigdApi.getInventorySize(deadData.modInventories.get(i));
            }
            int points = deadData.xp;
            int i = 0;
            while (points >= 0) {
                points = i < 16 ? (points -= 2 * i + 7) : (i < 31 ? (points -= 5 * i - 38) : (points -= 9 * i - 158));
                ++i;
            }
            info.add(new GuiGraveInfo(deadData, size, i - 1));
        }
        this.data = data;
        this.graveInfo = info;
        this.page = page;
        this.previousScreen = previousScreen;
        this.graveOwner = data.size() > 0 ? data.get((int)0).graveOwner : null;
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        if (keyCode == 259) {
            if (this.previousScreen == null) {
                this.method_25419();
                return true;
            }
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.previousScreen);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredElement != null) {
            this.mouseIsClicked = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.mouseIsClicked = false;
        if (button == 0 && this.hoveredElement != null && this.field_22787 != null) {
            if (this.hoveredElement.equals("left") && this.page > 1) {
                GraveSelectScreen screen = new GraveSelectScreen(this.data, this.page - 1, this.previousScreen);
                this.field_22787.method_1507((class_437)screen);
            } else if (this.hoveredElement.equals("right") && this.graveInfo.size() > this.page * 4) {
                GraveSelectScreen screen = new GraveSelectScreen(this.data, this.page + 1, this.previousScreen);
                this.field_22787.method_1507((class_437)screen);
            } else if (this.isInt(this.hoveredElement)) {
                int parsedString = Integer.parseInt(this.hoveredElement) - 1;
                if (this.data.size() > parsedString && parsedString >= 0) {
                    GraveViewScreen screen = new GraveViewScreen(this.data.get(parsedString), this);
                    this.field_22787.method_1507((class_437)screen);
                }
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int screenWidth = 220;
        int screenHeight = 200;
        int originX = this.field_22789 / 2;
        int originY = this.field_22790 / 2;
        int screenLeft = originX - 110;
        int screenTop = originY - 100;
        this.hoveredElement = null;
        RenderSystem.setShaderTexture((int)0, (class_2960)this.GRAVE_SELECT_TEXTURE);
        this.method_25302(matrices, screenLeft, screenTop, 0, 0, 220, 200);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > screenLeft + 6 && mouseX < screenLeft + 14 && mouseY > originY - 8 && mouseY < originY + 7) {
            this.hoveredElement = "left";
        } else if (mouseX > screenLeft + 220 - 14 && mouseX < screenLeft + 220 - 6 && mouseY > originY - 8 && mouseY < originY + 7) {
            this.hoveredElement = "right";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("left") && this.mouseIsClicked) {
            this.method_25302(matrices, screenLeft + 6, originY - 8, 16, 84, 8, 15);
        } else {
            this.method_25302(matrices, screenLeft + 6, originY - 8, 0, 84, 8, 15);
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("right") && this.mouseIsClicked) {
            this.method_25302(matrices, screenLeft + 220 - 14, originY - 8, 24, 84, 8, 15);
        } else {
            this.method_25302(matrices, screenLeft + 220 - 14, originY - 8, 8, 84, 8, 15);
        }
        int infoSize = this.graveInfo.size();
        int startValue = infoSize - (this.page - 1) * 4;
        int whileMoreThan = Math.max(startValue - 4, 0);
        int iterations = 0;
        for (int i = startValue; i > whileMoreThan; --i) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
            int left = screenLeft + 19;
            int top = screenTop + 24 + 42 * iterations;
            int width = 182;
            int height = 42;
            if (mouseX > left && mouseX < left + width && mouseY > top && mouseY < top + height) {
                this.hoveredElement = "" + i;
            }
            if (this.isInt(this.hoveredElement) && Integer.parseInt(this.hoveredElement) == i && this.mouseIsClicked) {
                this.method_25302(matrices, left, top, 0, height, width, height);
            } else {
                this.method_25302(matrices, left, top, 0, 0, width, height);
            }
            GuiGraveInfo info = this.graveInfo.get(i - 1);
            this.field_22793.method_1729(matrices, info.data.gravePos.method_10263() + " " + info.data.gravePos.method_10264() + " " + info.data.gravePos.method_10260() + " " + info.data.dimensionName, (float)left + 5.0f, (float)top + 5.0f, 0xCC00CC);
            this.field_22793.method_1729(matrices, info.itemSize + " items", (float)left + 5.0f, (float)top + 17.0f, 204);
            this.field_22793.method_1729(matrices, info.xpLevels + " levels", (float)left + 5.0f, (float)top + 29.0f, 2725384);
            ++iterations;
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        int firstElement = (this.page - 1) * 4 + 1;
        String gravesDisplayed = firstElement + "-" + (firstElement + Math.min(3, infoSize - firstElement)) + "/" + infoSize;
        this.field_22793.method_1729(matrices, "Graves of " + this.graveOwner.getName(), (float)screenLeft + 19.0f, (float)screenTop + 10.0f, 0x555555);
        int offset = this.field_22793.method_1727(gravesDisplayed);
        this.field_22793.method_1729(matrices, gravesDisplayed, (float)(screenLeft + 220) - 19.0f - (float)offset, (float)screenTop + 10.0f, 30464);
    }

    private boolean isInt(String intString) {
        if (intString == null) {
            return false;
        }
        try {
            Integer.parseInt(intString);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private record GuiGraveInfo(DeadPlayerData data, int itemSize, int xpLevels) {
    }
}

