/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.block.entity;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.YigdConfig;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1303;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class GraveBlockEntity
extends class_2586 {
    private GameProfile graveOwner = null;
    private int storedXp = 0;
    private String customName;
    private class_2371<class_1799> storedInventory;
    private Map<String, Object> moddedInventories;
    private UUID killer;
    public int age;
    private boolean glowing;

    public GraveBlockEntity(class_2338 pos, class_2680 state) {
        this(null, pos, state);
    }

    public GraveBlockEntity(String customName, class_2338 pos, class_2680 state) {
        super(Yigd.GRAVE_BLOCK_ENTITY, pos, state);
        this.customName = customName;
        this.storedInventory = class_2371.method_10213((int)41, (Object)class_1799.field_8037);
        this.age = 0;
        this.glowing = YigdConfig.getConfig().graveSettings.graveRenderSettings.glowingGrave;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("StoredXp", this.storedXp);
        tag.method_10566("Items", (class_2520)class_1262.method_5427((class_2487)new class_2487(), this.storedInventory, (boolean)true));
        tag.method_10569("ItemCount", this.storedInventory.size());
        tag.method_10544("age", (long)this.age);
        if (this.graveOwner != null) {
            tag.method_10566("owner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveOwner));
        }
        if (this.customName != null) {
            tag.method_10582("CustomName", this.customName);
        }
        if (this.killer != null) {
            tag.method_25927("killer", this.killer);
        }
        if (this.moddedInventories != null) {
            class_2487 modNbt = new class_2487();
            for (YigdApi yigdApi : Yigd.apiMods) {
                String modName = yigdApi.getModName();
                if (modName == null || !this.moddedInventories.containsKey(modName)) continue;
                modNbt.method_10566(modName, (class_2520)yigdApi.writeNbt(this.moddedInventories.get(modName)));
            }
            tag.method_10566("ModdedInventoryItems", (class_2520)modNbt);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.storedInventory = class_2371.method_10213((int)tag.method_10550("ItemCount"), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag.method_10562("Items"), this.storedInventory);
        this.storedXp = tag.method_10550("StoredXp");
        this.age = tag.method_10550("age");
        if (tag.method_10545("owner")) {
            this.graveOwner = class_2512.method_10683((class_2487)tag.method_10562("owner"));
        }
        if (tag.method_10545("CustomName")) {
            this.customName = tag.method_10558("CustomName");
        }
        if (tag.method_10545("killer")) {
            this.killer = tag.method_25926("killer");
        }
        if (tag.method_10545("ModdedInventoryItems")) {
            this.moddedInventories = new HashMap<String, Object>();
            class_2487 modNbt = tag.method_10562("ModdedInventoryItems");
            for (YigdApi yigdApi : Yigd.apiMods) {
                String modName = yigdApi.getModName();
                class_2487 nbt = modNbt.method_10562(modName);
                this.moddedInventories.computeIfAbsent(modName, s -> yigdApi.readNbt(nbt));
            }
        }
        this.glowing = YigdConfig.getConfig().graveSettings.graveRenderSettings.glowingGrave;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 ignoredState, class_2586 blockEntity) {
        boolean timeHasPassed;
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return;
        }
        GraveBlockEntity grave = (GraveBlockEntity)blockEntity;
        if (world == null || world.field_9236) {
            return;
        }
        ++grave.age;
        if (grave.getGraveOwner() == null) {
            return;
        }
        YigdConfig.GraveDeletion deletion = YigdConfig.getConfig().graveSettings.graveDeletion;
        if (!deletion.canDelete) {
            return;
        }
        boolean bl = timeHasPassed = grave.age > deletion.afterTime * deletion.timeType.tickFactor();
        if (!timeHasPassed) {
            return;
        }
        if (deletion.dropInventory) {
            int xp = grave.getStoredXp();
            class_2371 dropItems = class_2371.method_10211();
            for (class_1799 stack : grave.getStoredInventory()) {
                if (stack.method_7960()) continue;
                dropItems.add((Object)stack);
            }
            for (YigdApi yigdApi : Yigd.apiMods) {
                Object o = grave.moddedInventories.get(yigdApi.getModName());
                dropItems.addAll(yigdApi.toStackList(o));
            }
            if (!dropItems.isEmpty()) {
                class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)dropItems);
            }
            if (xp > 0 && world instanceof class_3218) {
                class_3218 sWorld = (class_3218)world;
                class_1303.method_31493((class_3218)sWorld, (class_243)class_243.method_24954((class_2382)pos), (int)xp);
            }
        }
        world.method_8650(pos, false);
        if (world.method_8503() == null || grave.graveOwner == null) {
            return;
        }
        class_3222 graveOwner = world.method_8503().method_3760().method_14602(grave.graveOwner.getId());
        if (graveOwner == null) {
            Yigd.notNotifiedPlayers.add(grave.graveOwner.getId());
            return;
        }
        graveOwner.method_7353((class_2561)new class_2588("text.yigd.message.timeout" + (deletion.dropInventory ? ".dropped" : "")), false);
    }

    public void setGraveOwner(GameProfile owner) {
        this.graveOwner = owner;
    }

    public void setStoredXp(int xp) {
        this.storedXp = xp;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void setInventory(class_2371<class_1799> inventory) {
        this.storedInventory = inventory;
    }

    public void setModdedInventories(Map<String, Object> inventories) {
        this.moddedInventories = inventories;
    }

    public void setKiller(UUID killerId) {
        this.killer = killerId;
    }

    public GameProfile getGraveOwner() {
        return this.graveOwner;
    }

    public String getCustomName() {
        return this.customName;
    }

    public class_2371<class_1799> getStoredInventory() {
        return this.storedInventory;
    }

    public int getStoredXp() {
        return this.storedXp;
    }

    public Map<String, Object> getModdedInventories() {
        return this.moddedInventories;
    }

    public UUID getKiller() {
        return this.killer;
    }

    public boolean canGlow() {
        return this.glowing;
    }
}

