/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.block;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.config.DropTypeConfig;
import com.b1n_ry.yigd.config.RetrievalTypeConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.GraveHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6760;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GraveBlock
extends class_2237
implements class_2343,
class_3737 {
    public static JsonObject customModel;
    public static final class_2753 FACING;
    protected static class_265 SHAPE_NORTH;
    protected static final class_265 SHAPE_BASE_NORTH;
    protected static final class_265 SHAPE_FOOT_NORTH;
    protected static final class_265 SHAPE_CORE_NORTH;
    protected static final class_265 SHAPE_TOP_NORTH;
    protected static class_265 SHAPE_WEST;
    protected static final class_265 SHAPE_BASE_WEST;
    protected static final class_265 SHAPE_FOOT_WEST;
    protected static final class_265 SHAPE_CORE_WEST;
    protected static final class_265 SHAPE_TOP_WEST;
    protected static class_265 SHAPE_EAST;
    protected static final class_265 SHAPE_BASE_EAST;
    protected static final class_265 SHAPE_FOOT_EAST;
    protected static final class_265 SHAPE_CORE_EAST;
    protected static final class_265 SHAPE_TOP_EAST;
    protected static class_265 SHAPE_SOUTH;
    protected static final class_265 SHAPE_BASE_SOUTH;
    protected static final class_265 SHAPE_FOOT_SOUTH;
    protected static final class_265 SHAPE_CORE_SOUTH;
    protected static final class_265 SHAPE_TOP_SOUTH;
    protected static final class_2746 WATERLOGGED;
    private String customName = null;

    public GraveBlock(class_4970.class_2251 settings) {
        super(settings.method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    public static void reloadVoxelShapes(JsonObject graveModel) {
        if (graveModel == null) {
            return;
        }
        JsonElement shapesArray = graveModel.get("elements");
        if (shapesArray == null || !shapesArray.isJsonArray()) {
            return;
        }
        class_265 groundShapeNorth = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        class_265 groundShapeWest = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        class_265 groundShapeSouth = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        class_265 groundShapeEast = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        ArrayList<class_265> shapesNorth = new ArrayList<class_265>();
        ArrayList<class_265> shapesWest = new ArrayList<class_265>();
        ArrayList<class_265> shapesSouth = new ArrayList<class_265>();
        ArrayList<class_265> shapesEast = new ArrayList<class_265>();
        for (JsonElement e : (JsonArray)shapesArray) {
            if (!e.isJsonObject()) continue;
            JsonObject o = e.getAsJsonObject();
            if (o.get("name") != null && o.get("name").getAsString().equals("Base_Layer")) {
                Map<String, class_265> groundShapes = GraveBlock.getShapeFromJson(o);
                groundShapeNorth = groundShapes.get("NORTH");
                groundShapeWest = groundShapes.get("WEST");
                groundShapeSouth = groundShapes.get("SOUTH");
                groundShapeEast = groundShapes.get("EAST");
                continue;
            }
            Map<String, class_265> directionShapes = GraveBlock.getShapeFromJson(o);
            shapesNorth.add(directionShapes.get("NORTH"));
            shapesWest.add(directionShapes.get("WEST"));
            shapesSouth.add(directionShapes.get("SOUTH"));
            shapesEast.add(directionShapes.get("EAST"));
        }
        SHAPE_NORTH = class_259.method_17786((class_265)groundShapeNorth, (class_265[])shapesNorth.toArray(new class_265[0]));
        SHAPE_WEST = class_259.method_17786((class_265)groundShapeWest, (class_265[])shapesWest.toArray(new class_265[0]));
        SHAPE_SOUTH = class_259.method_17786((class_265)groundShapeSouth, (class_265[])shapesSouth.toArray(new class_265[0]));
        SHAPE_EAST = class_259.method_17786((class_265)groundShapeEast, (class_265[])shapesEast.toArray(new class_265[0]));
    }

    private static Map<String, class_265> getShapeFromJson(JsonObject object) {
        HashMap<String, class_265> shapes = new HashMap<String, class_265>();
        JsonArray from = object.get("from").getAsJsonArray();
        float x1 = from.get(0).getAsFloat();
        float y1 = from.get(1).getAsFloat();
        float z1 = from.get(2).getAsFloat();
        JsonArray to = object.getAsJsonArray("to").getAsJsonArray();
        float x2 = to.get(0).getAsFloat();
        float y2 = to.get(1).getAsFloat();
        float z2 = to.get(2).getAsFloat();
        shapes.put("NORTH", class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
        shapes.put("EAST", class_2248.method_9541((double)(16.0f - z2), (double)y1, (double)x1, (double)(16.0f - z1), (double)y2, (double)x2));
        shapes.put("SOUTH", class_2248.method_9541((double)(16.0f - x2), (double)y1, (double)(16.0f - z2), (double)(16.0f - x1), (double)y2, (double)(16.0f - z1)));
        shapes.put("WEST", class_2248.method_9541((double)z1, (double)y1, (double)(16.0f - x2), (double)z2, (double)y2, (double)(16.0f - x1)));
        return shapes;
    }

    public class_2464 method_9604(class_2680 state) {
        if (YigdConfig.getConfig().graveSettings.graveRenderSettings.useRenderFeatures) {
            return class_2464.field_11455;
        }
        return class_2464.field_11458;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481, WATERLOGGED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        RetrievalTypeConfig retrievalType = YigdConfig.getConfig().graveSettings.retrievalType;
        if (retrievalType == RetrievalTypeConfig.ON_USE || retrievalType == null) {
            this.RetrieveItems(player, world, pos);
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_1657 player;
        if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_STAND && entity instanceof class_1657) {
            class_1657 player2 = (class_1657)entity;
            this.RetrieveItems(player2, world, pos);
        } else if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_SNEAK && entity instanceof class_1657 && (player = (class_1657)entity).method_18276()) {
            this.RetrieveItems(player, world, pos);
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 be, class_1799 stack) {
        GraveBlockEntity graveBlockEntity;
        if (!(be instanceof GraveBlockEntity) || (graveBlockEntity = (GraveBlockEntity)be).getGraveOwner() == null) {
            super.method_9556(world, player, pos, state, be, stack);
            return;
        }
        if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_BREAK && this.RetrieveItems(player, world, pos, be)) {
            return;
        }
        boolean bs = world.method_8501(pos, state);
        if (bs) {
            world.method_8438(be);
        } else {
            Yigd.LOGGER.warn("Did not manage to safely replace grave data at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + ". If grave contained items they've been deleted as no data was found");
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        Yigd.LOGGER.info("Grave at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + " was replaced with " + newState.method_26204());
        super.method_9536(state, world, pos, newState, moved);
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GraveBlockEntity) {
            boolean timePassed;
            GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
            YigdConfig.GraveRobbing graveRobbing = YigdConfig.getConfig().graveSettings.graveRobbing;
            boolean canRobGrave = graveRobbing.enableRobbing && (!graveRobbing.onlyMurderer || graveEntity.getKiller() == player.method_5667());
            boolean bl = timePassed = graveEntity.age > graveRobbing.afterTime * graveRobbing.timeType.tickFactor();
            if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_BREAK && (player.method_7334().equals((Object)graveEntity.getGraveOwner()) || canRobGrave && timePassed) || graveEntity.getGraveOwner() == null) {
                return super.method_9594(state, player, world, pos);
            }
        }
        return 0.0f;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (itemStack.method_7938()) {
            this.customName = itemStack.method_7964().method_10851();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof GraveBlockEntity) {
                GraveBlockEntity graveBlockEntity = (GraveBlockEntity)blockEntity;
                graveBlockEntity.setCustomName(this.customName);
            }
        }
    }

    private class_265 getShape(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11043 -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11039 -> SHAPE_WEST;
            default -> class_259.method_1077();
        };
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ct) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        return this.getShape(dir);
    }

    public class_2680 method_9605(class_1750 context) {
        class_2338 blockPos = context.method_8037();
        class_3610 fluidState = context.method_8045().method_8316(blockPos);
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_8405().method_39363(class_6760.method_39410((Object)class_3612.field_15910, (class_2338)pos));
        }
        return direction.method_10166().method_10179() ? state : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return GraveBlock.method_31618(type, Yigd.GRAVE_BLOCK_ENTITY, GraveBlockEntity::tick);
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        return false;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GraveBlockEntity(this.customName, pos, state);
    }

    private void RetrieveItems(class_1657 player, class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        this.RetrieveItems(player, world, pos, blockEntity);
    }

    private boolean RetrieveItems(class_1657 player, class_1937 world, class_2338 pos, class_2586 blockEntity) {
        boolean timePassed;
        if (world.field_9236) {
            return false;
        }
        if (player == null || player.method_29504()) {
            return false;
        }
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return false;
        }
        GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
        GameProfile graveOwner = graveEntity.getGraveOwner();
        if (graveOwner == null) {
            return false;
        }
        if (graveEntity.getGraveOwner() != null && graveEntity.age < 20) {
            player.method_7353((class_2561)new class_2588("text.yigd.message.too_fast"), false);
            return false;
        }
        int xp = graveEntity.getStoredXp();
        class_2371<class_1799> items = graveEntity.getStoredInventory();
        if (items == null) {
            return false;
        }
        Map<String, Object> graveModItems = graveEntity.getModdedInventories();
        if (YigdConfig.getConfig().graveSettings.dropType == DropTypeConfig.ON_GROUND) {
            for (YigdApi yigdApi : Yigd.apiMods) {
                Object o = graveModItems.get(yigdApi.getModName());
                items.addAll(yigdApi.toStackList(o));
            }
            class_1264.method_17349((class_1937)world, (class_2338)pos, items);
            if (world instanceof class_3218) {
                class_3218 sWorld = (class_3218)world;
                class_1303.method_31493((class_3218)sWorld, (class_243)class_243.method_24954((class_2382)pos), (int)graveEntity.getStoredXp());
            }
            world.method_8650(pos, false);
            if (YigdConfig.getConfig().graveSettings.dropGraveBlock) {
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)Yigd.GRAVE_BLOCK.method_8389().method_7854());
            }
            return true;
        }
        YigdConfig.GraveRobbing graveRobbing = YigdConfig.getConfig().graveSettings.graveRobbing;
        boolean canRobGrave = graveRobbing.enableRobbing && (!graveRobbing.onlyMurderer || graveEntity.getKiller() == player.method_5667());
        int age = graveEntity.age;
        int requiredAge = graveRobbing.afterTime * graveRobbing.timeType.tickFactor();
        boolean isRobbing = false;
        boolean bl = timePassed = age > requiredAge;
        if (!player.method_7334().getId().equals(graveOwner.getId())) {
            if (!canRobGrave || !timePassed) {
                if (canRobGrave) {
                    double timeRemaining = ((double)requiredAge - (double)age) / 20.0;
                    int hours = (int)(timeRemaining / 3600.0);
                    int minutes = (int)((timeRemaining %= 3600.0) / 60.0);
                    int seconds = (int)(timeRemaining %= 60.0);
                    player.method_7353((class_2561)new class_2588("text.yigd.message.retrieve.rob_cooldown", new Object[]{hours, minutes, seconds}), true);
                } else {
                    player.method_7353((class_2561)new class_2588("text.yigd.message.retrieve.missing_permission"), true);
                }
                return false;
            }
            isRobbing = true;
        }
        if (YigdConfig.getConfig().graveSettings.dropGraveBlock) {
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)Yigd.GRAVE_BLOCK.method_8389().method_7854());
        }
        world.method_8650(pos, false);
        Yigd.LOGGER.info(player.method_5476().method_10851() + " is retrieving " + (isRobbing ? "someone else's" : "their") + " grave at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260());
        MinecraftServer server = world.method_8503();
        if (isRobbing && server != null) {
            UUID playerId = graveOwner.getId();
            class_3222 robbedPlayer = server.method_3760().method_14602(playerId);
            if (robbedPlayer != null) {
                robbedPlayer.method_7353((class_2561)new class_2588("text.yigd.message.robbed"), false);
            } else {
                Yigd.notNotifiedRobberies.add(playerId);
            }
        }
        GraveHelper.RetrieveItems(player, items, graveModItems, xp, isRobbing);
        List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(player.method_5667());
        if (deadPlayerData != null) {
            deadPlayerData.removeIf(data -> data.gravePos.equals((Object)pos));
        }
        DeathInfoManager.INSTANCE.method_80();
        return true;
    }

    static {
        FACING = class_2383.field_11177;
        SHAPE_BASE_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_NORTH = class_2248.method_9541((double)2.0, (double)1.0, (double)10.0, (double)14.0, (double)3.0, (double)15.0);
        SHAPE_CORE_NORTH = class_2248.method_9541((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)15.0, (double)14.0);
        SHAPE_TOP_NORTH = class_2248.method_9541((double)4.0, (double)15.0, (double)11.0, (double)12.0, (double)16.0, (double)14.0);
        SHAPE_BASE_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_EAST = class_2248.method_9541((double)1.0, (double)1.0, (double)2.0, (double)6.0, (double)3.0, (double)14.0);
        SHAPE_CORE_EAST = class_2248.method_9541((double)2.0, (double)3.0, (double)3.0, (double)5.0, (double)15.0, (double)13.0);
        SHAPE_TOP_EAST = class_2248.method_9541((double)2.0, (double)15.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0);
        SHAPE_BASE_WEST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_WEST = class_2248.method_9541((double)10.0, (double)1.0, (double)2.0, (double)15.0, (double)3.0, (double)14.0);
        SHAPE_CORE_WEST = class_2248.method_9541((double)11.0, (double)3.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0);
        SHAPE_TOP_WEST = class_2248.method_9541((double)11.0, (double)15.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0);
        SHAPE_BASE_SOUTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_SOUTH = class_2248.method_9541((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)3.0, (double)6.0);
        SHAPE_CORE_SOUTH = class_2248.method_9541((double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)15.0, (double)5.0);
        SHAPE_TOP_SOUTH = class_2248.method_9541((double)4.0, (double)15.0, (double)2.0, (double)12.0, (double)16.0, (double)5.0);
        SHAPE_NORTH = class_259.method_17786((class_265)SHAPE_BASE_NORTH, (class_265[])new class_265[]{SHAPE_FOOT_NORTH, SHAPE_CORE_NORTH, SHAPE_TOP_NORTH});
        SHAPE_WEST = class_259.method_17786((class_265)SHAPE_BASE_WEST, (class_265[])new class_265[]{SHAPE_FOOT_WEST, SHAPE_CORE_WEST, SHAPE_TOP_WEST});
        SHAPE_EAST = class_259.method_17786((class_265)SHAPE_BASE_EAST, (class_265[])new class_265[]{SHAPE_FOOT_EAST, SHAPE_CORE_EAST, SHAPE_TOP_EAST});
        SHAPE_SOUTH = class_259.method_17786((class_265)SHAPE_BASE_SOUTH, (class_265[])new class_265[]{SHAPE_FOOT_SOUTH, SHAPE_CORE_SOUTH, SHAPE_TOP_SOUTH});
        WATERLOGGED = class_2741.field_12508;
    }
}

