/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.thonk.croptopia.Croptopia;
import me.thonk.croptopia.config.ConfigurableSeed;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2378;

public class Options {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private File optionsFile;
    public boolean useHoeToCollectSeeds = true;
    public boolean disableSaltOre = false;

    public Options(String modID) {
        File configDirectory = new File(FabricLoader.getInstance().getConfigDir().toFile(), modID);
        if (!configDirectory.exists()) {
            configDirectory.mkdirs();
        }
        this.optionsFile = new File(configDirectory, "options.json");
    }

    private void checkForDefaults(File file) {
        try (FileReader reader = new FileReader(file);){
            JsonObject mainObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            JsonObject options = new JsonObject();
            if (!mainObject.has("options")) {
                options.add("_comment", (JsonElement)new JsonPrimitive("Set this to false if you want to get seeds anytime you break tall grass."));
                options.add("use-hoe-to-collect-seeds", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            } else {
                options = mainObject.getAsJsonObject("options");
            }
            if (!options.has("disable-salt-ore")) {
                options.add("disable-salt-ore", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            }
            mainObject.add("options", (JsonElement)options);
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson((JsonElement)mainObject, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<ConfigurableSeed> readConfiguredSeeds(File file) {
        ArrayList<ConfigurableSeed> seeds = new ArrayList<ConfigurableSeed>();
        try (FileReader reader = new FileReader(file);){
            JsonObject mainObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            JsonObject seedsCategory = mainObject.getAsJsonObject("seeds");
            for (Map.Entry entry : seedsCategory.entrySet()) {
                if (((String)entry.getKey()).contains("comment")) continue;
                JsonObject seedObject = (JsonObject)entry.getValue();
                String category = seedObject.getAsJsonPrimitive("biome-category").getAsString();
                float chance = seedObject.getAsJsonPrimitive("drop-chance").getAsFloat();
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(Croptopia.createIdentifier((String)entry.getKey()));
                class_1959.class_1961 biomeCategory = class_1959.class_1961.method_28424((String)category);
                if (biomeCategory == null) {
                    biomeCategory = class_1959.class_1961.field_9355;
                }
                seeds.add(new ConfigurableSeed((String)entry.getKey(), item, List.of(biomeCategory)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return seeds;
    }

    public void readOptionsFile(File file) {
        try (FileReader reader = new FileReader(file);){
            JsonObject mainObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            JsonObject options = mainObject.getAsJsonObject("options");
            this.useHoeToCollectSeeds = options.getAsJsonPrimitive("use-hoe-to-collect-seeds").getAsBoolean();
            this.disableSaltOre = options.getAsJsonPrimitive("disable-salt-ore").getAsBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean useHoeToCollectSeeds() {
        return this.useHoeToCollectSeeds;
    }

    public boolean disableSaltOre() {
        return this.disableSaltOre;
    }

    public File getOptionsFile() {
        return this.optionsFile;
    }
}

