/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard_biomes.world.biomes;

import com.finallion.graveyard_biomes.TheGraveyardBiomes;
import com.finallion.graveyard_biomes.init.TGBiomes;
import com.finallion.graveyard_biomes.world.surfacerules.TGSurfaceRules;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6686;
import terrablender.api.BiomeProvider;
import terrablender.worldgen.TBClimate;

public class TGBiomeProvider
extends BiomeProvider {
    public TGBiomeProvider(class_2960 name, int overworldWeight) {
        super(name, overworldWeight);
    }

    public void addOverworldBiomes(class_2378<class_1959> registry, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            List<String> configBiomes;
            if (TheGraveyardBiomes.config.getBiome((class_2960)new class_2960((String)"graveyard_biomes", (String)"haunted_forest")).canGenerate) {
                configBiomes = TheGraveyardBiomes.config.biomeConfigEntries.get((Object)"haunted_forest").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome), TGBiomes.HAUNTED_FOREST_KEY);
                }
            }
            if (TheGraveyardBiomes.config.getBiome((class_2960)new class_2960((String)"graveyard_biomes", (String)"eroded_haunted_forest")).canGenerate) {
                configBiomes = TheGraveyardBiomes.config.biomeConfigEntries.get((Object)"eroded_haunted_forest").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome), TGBiomes.ERODED_HAUNTED_FOREST_KEY);
                }
            }
            if (TheGraveyardBiomes.config.getBiome((class_2960)new class_2960((String)"graveyard_biomes", (String)"haunted_lakes")).canGenerate) {
                configBiomes = TheGraveyardBiomes.config.biomeConfigEntries.get((Object)"haunted_lakes").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome), TGBiomes.HAUNTED_LAKES_KEY);
                }
            }
            if (TheGraveyardBiomes.config.getBiome((class_2960)new class_2960((String)"graveyard_biomes", (String)"ancient_dead_coral_reef")).canGenerate) {
                configBiomes = TheGraveyardBiomes.config.biomeConfigEntries.get((Object)"ancient_dead_coral_reef").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome), TGBiomes.ANCIENT_DEAD_CORAL_REEF_KEY);
                }
            }
        });
    }

    public Optional<class_6686.class_6708> getOverworldSurfaceRules() {
        return Optional.of(TGSurfaceRules.makeRules());
    }

    private class_5321<class_1959> parseBiomeKeys(String configKey) {
        List biomeKeys = class_5458.field_25933.method_29722().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        for (class_5321 key : biomeKeys) {
            String biomeName = key.method_29177().method_12832();
            if (!biomeName.equals(configKey)) continue;
            return key;
        }
        TheGraveyardBiomes.LOGGER.error("Wrong biome key \"" + configKey + "\" in config!");
        return null;
    }
}

