/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard_biomes.config;

import com.finallion.graveyard_biomes.config.BiomeConfigEntry;
import com.finallion.graveyard_biomes.config.BiomeFogConfigEntry;
import draylar.omegaconfig.api.Comment;
import draylar.omegaconfig.api.Config;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class GraveyardBiomesConfig
implements Config {
    @Comment(value=" Welcome to The Graveyard Biomes Config!\n\n Set \"theGraveyardBiomesWeight\" to 0 to disable The Graveyard biomes.\n This may be necessary to reduce incompatibilities with other biome mods that don't use TerraBlender, especially Terralith.\n Configure the weight of the biomes by changing \"theGraveyardBiomesWeight\".\n Configure which minecraft biomes can be replaced by The Graveyard biomes.\n A full list of all the biomes can be found here https:minecraft.fandom.com/wiki/Biome#Biome_IDs.\n Configure fog density and fog height.\n\n")
    public final Map<String, BiomeConfigEntry> biomeConfigEntries = new HashMap<String, BiomeConfigEntry>();
    public final Map<String, BiomeFogConfigEntry> biomeFogConfigEntries = new HashMap<String, BiomeFogConfigEntry>();
    public final Map<String, Integer> biomeGeneration = new HashMap<String, Integer>();

    public String getName() {
        return "the-graveyard-biomes_config";
    }

    public String getExtension() {
        return "json5";
    }

    public boolean biomeFogSpawn(class_2960 id) {
        return this.getFog((class_2960)id).enabled;
    }

    public BiomeConfigEntry getBiome(class_2960 id) {
        for (Map.Entry<String, BiomeConfigEntry> entry : this.biomeConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.method_12832())) continue;
            return entry.getValue();
        }
        throw new NullPointerException("Tried BiomeConfigEntry with id: " + id + ", but it was null!");
    }

    public BiomeFogConfigEntry getFog(class_2960 id) {
        for (Map.Entry<String, BiomeFogConfigEntry> entry : this.biomeFogConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.method_12832())) continue;
            return entry.getValue();
        }
        throw new NullPointerException("Tried BiomeFogConfigEntry with id: " + id + ", but it was null!");
    }

    public void save() {
        this.biomeGeneration.putIfAbsent("theGraveyardBiomesWeight", 1);
        this.biomeConfigEntries.putIfAbsent("haunted_forest", BiomeConfigEntry.of(Arrays.asList("windswept_forest")));
        this.biomeConfigEntries.putIfAbsent("haunted_lakes", BiomeConfigEntry.of(Arrays.asList("swamp")));
        this.biomeConfigEntries.putIfAbsent("eroded_haunted_forest", BiomeConfigEntry.of(Arrays.asList("meadow")));
        this.biomeConfigEntries.putIfAbsent("ancient_dead_coral_reef", BiomeConfigEntry.of(Arrays.asList("beach")));
        this.biomeFogConfigEntries.putIfAbsent("haunted_forest_fog", BiomeFogConfigEntry.of(0.35f, 63, 148));
        this.biomeFogConfigEntries.putIfAbsent("haunted_lakes_fog", BiomeFogConfigEntry.of(0.3f, 63, 128));
        this.biomeFogConfigEntries.putIfAbsent("eroded_haunted_forest_fog", BiomeFogConfigEntry.of(0.35f, 93, 160));
        super.save();
    }
}

