/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lovely_snails.entity;

import dev.lambdaurora.lovely_snails.LovelySnails;
import dev.lambdaurora.lovely_snails.entity.goal.SnailFollowParentGoal;
import dev.lambdaurora.lovely_snails.entity.goal.SnailHideGoal;
import dev.lambdaurora.lovely_snails.mixin.DataTrackerAccessor;
import dev.lambdaurora.lovely_snails.mixin.PassiveEntityAccessor;
import dev.lambdaurora.lovely_snails.mixin.ShulkerEntityAccessor;
import dev.lambdaurora.lovely_snails.registry.LovelySnailsRegistry;
import dev.lambdaurora.lovely_snails.screen.SnailScreenHandler;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2577;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4970;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5146;
import net.minecraft.class_5275;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5815;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public class SnailEntity
extends class_1321
implements class_1265,
class_5146 {
    private static final class_1322 SCARED_ARMOR_BONUS = ShulkerEntityAccessor.lovely_snails$getCoveredArmorBonus();
    private static final class_2940<Boolean> CHILD = PassiveEntityAccessor.lovely_snails$getChild();
    private static final class_2940<Byte> SNAIL_FLAGS = class_2945.method_12791(SnailEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> CHEST_FLAGS = class_2945.method_12791(SnailEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> CARPET_COLOR = class_2945.method_12791(SnailEntity.class, (class_2941)class_2943.field_13327);
    private static final int SADDLED_FLAG = 1;
    private static final int SCARED_FLAG = 2;
    private static final int INTERACTION_COOLDOWN_FLAG = 4;
    public static final int SADDLE_SLOT = 0;
    public static final int CARPET_SLOT = 1;
    private static final int SATISFACTION_START = -256;
    private class_1277 inventory;
    private int satisfaction;
    private short interactionCooldown;
    private boolean reading;

    public SnailEntity(class_1299<? extends SnailEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.updateInventory();
        this.field_6013 = 1.0f;
    }

    public static class_5132.class_5133 createSnailAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 48.0);
    }

    public static boolean canSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, Random random) {
        class_2680 spawnBlock = world.method_8320(pos.method_10074());
        return world.method_22335(pos, 0) > 8 && spawnBlock.method_26164(LovelySnailsRegistry.SNAIL_SPAWN_BLOCKS);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.method_7217(true);
        this.satisfaction = -256 + this.field_5974.nextInt(10);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected boolean getSnailFlag(int bitmask) {
        return ((Byte)this.field_6011.method_12789(SNAIL_FLAGS) & bitmask) != 0;
    }

    protected void setSnailFlag(int bitmask, boolean flag) {
        byte b = (Byte)this.field_6011.method_12789(SNAIL_FLAGS);
        if (flag) {
            this.field_6011.method_12778(SNAIL_FLAGS, (Object)((byte)(b | bitmask)));
        } else {
            this.field_6011.method_12778(SNAIL_FLAGS, (Object)((byte)(b & ~bitmask)));
        }
    }

    public boolean isScared() {
        return this.getSnailFlag(2);
    }

    public void setScared(boolean scared) {
        this.setSnailFlag(2, scared);
        if (!this.field_6002.method_8608()) {
            this.method_5996(class_5134.field_23724).method_6202(SCARED_ARMOR_BONUS);
            if (scared) {
                this.method_5996(class_5134.field_23724).method_26837(SCARED_ARMOR_BONUS);
            }
        }
    }

    public int getSatisfaction() {
        if (this.field_6002.method_8608()) {
            return (Boolean)this.field_6011.method_12789(CHILD) != false ? -1 : 1;
        }
        return this.satisfaction;
    }

    public void setSatisfaction(int satisfaction) {
        this.satisfaction = satisfaction;
        this.method_7217(satisfaction < 0);
    }

    public void satisfies(int baseSatisfaction) {
        if (this.method_6109()) {
            this.putInteractionOnCooldown();
            int newSatisfaction = this.getSatisfaction() + baseSatisfaction + this.field_5974.nextInt(10);
            if (newSatisfaction >= 0) {
                class_4048 adultDimensions = this.method_5864().method_18386();
                float width = adultDimensions.field_18067 * 0.8f;
                float eyeHeight = this.method_18378(class_4050.field_18076, adultDimensions);
                class_2338 pos = new class_2338(this.method_23317(), this.method_23318() + (double)eyeHeight, this.method_23321());
                class_238 box = class_238.method_30048((class_243)new class_243(this.method_23317(), this.method_23318() + (double)eyeHeight, this.method_23321()), (double)width, (double)1.0E-6, (double)width);
                boolean willSuffocate = this.field_6002.method_29546(box).filter(Predicate.not(class_4970.class_4971::method_26215)).anyMatch(state -> state.method_26228((class_1922)this.field_6002, pos));
                if (willSuffocate) {
                    this.field_6002.method_8421((class_1297)this, (byte)10);
                    return;
                }
            }
            this.setSatisfaction(newSatisfaction);
        }
        this.field_6002.method_8421((class_1297)this, (byte)8);
    }

    public short getInteractionCooldown() {
        if (this.field_6002.method_8608()) {
            return (short)(this.getSnailFlag(4) ? 1 : 0);
        }
        return this.interactionCooldown;
    }

    public boolean canInteract() {
        return this.getInteractionCooldown() == 0;
    }

    public void setInteractionCooldown(int interactionCooldown) {
        boolean onCooldown = this.interactionCooldown > 0;
        if (onCooldown == (interactionCooldown == 0)) {
            this.setSnailFlag(4, interactionCooldown != 0);
        }
        this.interactionCooldown = (short)interactionCooldown;
    }

    public void putInteractionOnCooldown() {
        this.setInteractionCooldown(75 + this.field_5974.nextInt(10));
    }

    @Nullable
    public static class_1767 getColorFromCarpet(class_1799 color) {
        class_1767 class_17672;
        class_2248 block = class_2248.method_9503((class_1792)color.method_7909());
        if (block instanceof class_5815) {
            class_5815 dyedCarpetBlock = (class_5815)block;
            class_17672 = dyedCarpetBlock.method_33635();
        } else {
            class_17672 = null;
        }
        return class_17672;
    }

    public void setCarpetColor(@Nullable class_1767 color) {
        this.field_6011.method_12778(CARPET_COLOR, (Object)(color == null ? -1 : color.method_7789()));
    }

    @Nullable
    public class_1767 getCarpetColor() {
        int i = (Integer)this.field_6011.method_12789(CARPET_COLOR);
        return i == -1 ? null : class_1767.method_7791((int)i);
    }

    public double method_5621() {
        if (!this.method_6109()) {
            return this.method_18377((class_4050)class_4050.field_18076).field_18068 * 0.95f;
        }
        return super.method_5621();
    }

    public void method_5711(byte status) {
        if (status == 8) {
            for (int i = 0; i < 7; ++i) {
                double xOffset = this.field_5974.nextGaussian() * 0.02;
                double yOffset = this.field_5974.nextGaussian() * 0.02;
                double zOffset = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)(this.field_5974.nextBoolean() ? class_2398.field_11211 : class_2398.field_11201), this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), xOffset, yOffset, zOffset);
            }
        } else if (status == 9) {
            for (int i = 0; i < 7; ++i) {
                double xOffset = this.field_5974.nextGaussian() * 0.02;
                double yOffset = this.field_5974.nextGaussian() * 0.02;
                double zOffset = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)class_2398.field_11231, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), xOffset, yOffset, zOffset);
            }
        } else if (status == 10) {
            for (int i = 0; i < 7; ++i) {
                double xOffset = this.field_5974.nextGaussian() * 0.02;
                double yOffset = this.field_5974.nextGaussian() * 0.02;
                double zOffset = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)(this.field_5974.nextBoolean() ? class_2398.field_11231 : class_2398.field_11251), this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), xOffset, yOffset, zOffset);
            }
        } else {
            super.method_5711(status);
        }
    }

    protected void method_5693() {
        super.method_5693();
        ((DataTrackerAccessor)this.field_6011).lovely_snails$getEntry(CHILD).method_12799((Object)true);
        this.field_6011.method_12784(SNAIL_FLAGS, (Object)0);
        this.field_6011.method_12784(CHEST_FLAGS, (Object)0);
        this.field_6011.method_12784(CARPET_COLOR, (Object)-1);
    }

    public void method_5749(class_2487 nbt) {
        this.reading = true;
        super.method_5749(nbt);
        this.setSatisfaction(nbt.method_10573("satisfaction", 3) ? nbt.method_10550("satisfaction") : -256);
        this.setInteractionCooldown(nbt.method_10568("interaction_cooldown"));
        this.readSpecialSlot(nbt, "saddle", 0, stack -> stack.method_31574(class_1802.field_8175));
        this.readSpecialSlot(nbt, "decor", 1, stack -> {
            class_1747 blockItem;
            class_1792 patt12510$temp = stack.method_7909();
            return patt12510$temp instanceof class_1747 && (blockItem = (class_1747)patt12510$temp).method_7711() instanceof class_2577;
        });
        LovelySnails.readInventoryNbt(nbt, "chests", (class_1263)this.inventory, 2);
        LovelySnails.readInventoryNbt(nbt, "inventory", (class_1263)this.inventory, 5);
        this.syncInventoryToFlags();
        this.reading = false;
    }

    private void readSpecialSlot(class_2487 nbt, String name, int slot, Predicate<class_1799> predicate) {
        class_1799 stack;
        if (nbt.method_10573(name, 10) && predicate.test(stack = class_1799.method_7915((class_2487)nbt.method_10562(name)))) {
            this.inventory.method_5447(slot, stack);
            return;
        }
        this.inventory.method_5447(slot, class_1799.field_8037);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10551("Sitting");
        nbt.method_10569("satisfaction", this.getSatisfaction());
        nbt.method_10575("interaction_cooldown", this.getInteractionCooldown());
        this.writeSpecialSlot(nbt, "saddle", 0);
        this.writeSpecialSlot(nbt, "decor", 1);
        LovelySnails.writeInventoryNbt(nbt, "chests", (class_1263)this.inventory, 2, 5);
        LovelySnails.writeInventoryNbt(nbt, "inventory", (class_1263)this.inventory, 5, this.inventory.method_5439());
    }

    public void writeSpecialSlot(class_2487 nbt, String name, int slot) {
        if (!this.inventory.method_5438(slot).method_7960()) {
            nbt.method_10566(name, (class_2520)this.inventory.method_5438(slot).method_7953(new class_2487()));
        }
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(1, (class_1352)new SnailHideGoal(this, 5.0));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0, SnailEntity.class));
        this.field_6201.method_6277(4, (class_1352)new SnailFollowParentGoal(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.7));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public int getChestFlags() {
        return ((Byte)this.field_6011.method_12789(CHEST_FLAGS)).byteValue();
    }

    public class_1799 getChest(int slot) {
        int flags = this.getChestFlags();
        int chest = flags >> slot * 2 & 3;
        return switch (chest) {
            case 1 -> new class_1799((class_1935)class_1802.field_8106);
            case 2 -> new class_1799((class_1935)class_1802.field_8466);
            default -> class_1799.field_8037;
        };
    }

    public int getInventorySize() {
        return 50;
    }

    public class_1799 getSaddle() {
        return this.inventory.method_5438(0);
    }

    public void syncInventoryToFlags() {
        if (!this.field_6002.method_8608()) {
            this.setSnailFlag(1, !this.getSaddle().method_7960());
            this.setCarpetColor(SnailEntity.getColorFromCarpet(this.inventory.method_5438(1)));
            int chestFlags = 0;
            for (int chest = 0; chest < 3; ++chest) {
                class_1799 chestStack = this.inventory.method_5438(2 + chest);
                int flag = 0;
                if (chestStack.method_31574(class_1802.field_8106)) {
                    flag = 1;
                } else if (chestStack.method_31574(class_1802.field_8466)) {
                    flag = 2;
                }
                chestFlags |= flag << chest * 2;
            }
            this.field_6011.method_12778(CHEST_FLAGS, (Object)((byte)chestFlags));
        }
    }

    public void openInventory(class_1657 player) {
        if (!this.field_6002.method_8608() && (!this.method_5782() || this.method_5626((class_1297)player)) && this.method_6181()) {
            player.method_17355((class_3908)new SnailScreenHandlerFactory());
        }
    }

    public void openEnderChestInventory(class_1657 player) {
        if (!this.field_6002.method_8608() && (!this.method_5782() || this.method_5626((class_1297)player)) && this.method_6181()) {
            player.method_17355((class_3908)new class_747((syncId, playerInventory, playerEntity) -> class_1707.method_19245((int)syncId, (class_1661)playerInventory, (class_1263)player.method_7274()), (class_2561)new class_2588("container.enderchest")));
        }
    }

    public boolean isInventoryDifferent(class_1263 inventory) {
        return this.inventory != inventory;
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null) {
            for (int slot = 0; slot < this.inventory.method_5439(); ++slot) {
                class_1799 stack = this.inventory.method_5438(slot);
                if (stack.method_7960() || class_1890.method_8221((class_1799)stack)) continue;
                this.method_5775(stack);
            }
        }
    }

    protected void updateInventory() {
        class_1277 previousInventory = this.inventory;
        this.inventory = new class_1277(this.getInventorySize());
        if (previousInventory != null) {
            previousInventory.method_5488((class_1265)this);
            int maxSize = Math.min(previousInventory.method_5439(), this.inventory.method_5439());
            for (int slot = 0; slot < maxSize; ++slot) {
                class_1799 stack = previousInventory.method_5438(slot);
                if (stack.method_7960()) continue;
                this.inventory.method_5447(slot, stack.method_7972());
            }
        }
        this.inventory.method_5489((class_1265)this);
        this.syncInventoryToFlags();
    }

    public void method_5453(class_1263 sender) {
        boolean previouslySaddled = this.method_6725();
        boolean hadDecor = this.getCarpetColor() != null;
        this.syncInventoryToFlags();
        if (this.field_6012 > 20 && !previouslySaddled && this.method_6725()) {
            this.method_5783(class_3417.field_14704, 0.5f, 1.0f);
        }
        if (!this.reading && !this.field_6002.method_8608() && !hadDecor && this.getCarpetColor() != null && this.canInteract()) {
            class_1959 biome = this.field_6002.method_23753(this.method_24515());
            int baseSatisfaction = biome.method_39927(this.method_24515()) ? 15 : 5;
            this.satisfies(baseSatisfaction);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 handStack = player.method_5998(hand);
        if (this.method_6181() && player.method_21823()) {
            this.openInventory(player);
            return class_1269.method_29236((boolean)this.field_6002.method_8608());
        }
        if (this.method_5782()) {
            return super.method_5992(player, hand);
        }
        if (!handStack.method_7960()) {
            boolean saddle;
            class_1269 itemResult = handStack.method_7920(player, (class_1309)this, hand);
            if (itemResult.method_23665()) {
                return itemResult;
            }
            if (this.method_6481(handStack) && !this.isScared()) {
                if (this.method_6181()) {
                    int breedingAge = this.method_5618();
                    if (!this.field_6002.method_8608() && breedingAge == 0 && this.method_6482()) {
                        this.method_6475(player, hand, handStack);
                        this.method_6480(player);
                        this.method_33569(class_5712.field_28725, this.method_33575());
                        return class_1269.field_5812;
                    }
                    if (this.field_6002.method_8608()) {
                        return class_1269.field_21466;
                    }
                } else {
                    this.method_6475(player, hand, handStack);
                    if (this.field_5974.nextInt(3) == 0) {
                        this.method_6170(player);
                        this.field_6002.method_8421((class_1297)this, (byte)7);
                    } else {
                        this.field_6002.method_8421((class_1297)this, (byte)6);
                    }
                    this.method_5971();
                    return class_1269.method_29236((boolean)this.field_6002.method_8608());
                }
            }
            if (!this.method_6181()) {
                return class_1269.field_21466;
            }
            boolean bl = saddle = !this.method_6109() && !this.method_6725() && handStack.method_31574(class_1802.field_8175);
            if (SnailEntity.getColorFromCarpet(handStack) != null || saddle) {
                this.openInventory(player);
                return class_1269.method_29236((boolean)this.field_6002.method_8608());
            }
        }
        if (this.method_6181()) {
            if (!this.method_6109()) {
                if (!this.field_6002.method_8608()) {
                    player.method_36456(this.method_36454());
                    player.method_36457(this.method_36455());
                    player.method_5804((class_1297)this);
                }
                return class_1269.method_29236((boolean)this.field_6002.method_8608());
            }
            if (this.canInteract() && this.method_6177() == player) {
                boolean likeItem = handStack.method_31573(LovelySnailsRegistry.SNAIL_FOOD_ITEMS);
                if (handStack.method_7960() || likeItem) {
                    if (likeItem) {
                        this.method_6475(player, hand, handStack);
                    }
                    if (!this.field_6002.method_8608()) {
                        this.satisfies(likeItem ? 20 : 10);
                    }
                    return class_1269.method_29236((boolean)this.field_6002.method_8608());
                }
                if (handStack.method_31574(class_1802.field_8635)) {
                    if (!this.field_6002.method_8608()) {
                        this.method_6475(player, hand, handStack);
                        this.setSatisfaction(this.getSatisfaction() - 4000);
                        this.putInteractionOnCooldown();
                        this.field_6002.method_8421((class_1297)this, (byte)9);
                    }
                    return class_1269.method_29236((boolean)this.field_6002.method_8608());
                }
            }
        }
        return super.method_5992(player, hand);
    }

    public void onWaterSplashed(class_1297 waterOwner) {
        if (this.method_6177() != waterOwner) {
            return;
        }
        if (this.canInteract()) {
            class_1959 biome = this.field_6002.method_23753(this.method_24515());
            float downfall = biome.method_8715();
            int baseSatisfaction = downfall < 0.4f ? 20 : (biome.method_39927(this.method_24515()) ? 10 : 15);
            this.satisfies(baseSatisfaction);
        }
    }

    public boolean method_6765() {
        return this.method_5805() && !this.method_6109() && this.method_6181();
    }

    public void method_6576(@Nullable class_3419 sound) {
        this.inventory.method_5447(0, new class_1799((class_1935)class_1802.field_8175));
        if (sound != null) {
            this.field_6002.method_8449(null, (class_1297)this, class_3417.field_14704, sound, 0.5f, 1.0f);
        }
    }

    public boolean method_6725() {
        return this.getSnailFlag(1);
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_31483();
    }

    public boolean method_5956() {
        return this.method_5642() instanceof class_1309;
    }

    @Nullable
    private class_243 tryDismountTowards(class_243 vec3d, class_1309 livingEntity) {
        double targetX = this.method_23317() + vec3d.field_1352;
        double targetY = this.method_5829().field_1322;
        double targetZ = this.method_23321() + vec3d.field_1350;
        class_2338.class_2339 pos = new class_2338.class_2339();
        block0: for (class_4050 pose : livingEntity.method_24831()) {
            pos.method_10102(targetX, targetY, targetZ);
            double maxDismountY = this.method_5829().field_1325 + 0.75;
            do {
                class_243 vec3d2;
                class_238 poseBoundingBox;
                double dismountHeight = this.field_6002.method_30347((class_2338)pos);
                if ((double)pos.method_10264() + dismountHeight > maxDismountY) continue block0;
                if (class_5275.method_27932((double)dismountHeight) && class_5275.method_27933((class_1941)this.field_6002, (class_1309)livingEntity, (class_238)(poseBoundingBox = livingEntity.method_24833(pose)).method_997(vec3d2 = new class_243(targetX, (double)pos.method_10264() + dismountHeight, targetZ)))) {
                    livingEntity.method_18380(pose);
                    return vec3d2;
                }
                pos.method_10098(class_2350.field_11036);
            } while ((double)pos.method_10264() < maxDismountY);
        }
        return null;
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 rightDismountOffset = SnailEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(this.method_36454() + (passenger.method_6068() == class_1306.field_6183 ? 90.0f : -90.0f)));
        class_243 dismountPos = this.tryDismountTowards(rightDismountOffset, passenger);
        if (dismountPos != null) {
            return dismountPos;
        }
        class_243 leftDismountOffset = SnailEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(this.method_36454() + (passenger.method_6068() == class_1306.field_6182 ? 90.0f : -90.0f)));
        dismountPos = this.tryDismountTowards(leftDismountOffset, passenger);
        return dismountPos != null ? dismountPos : this.method_19538();
    }

    public void method_6007() {
        super.method_6007();
        if (!this.field_6002.method_8608() && this.method_5805()) {
            short interactionCooldown;
            if (this.field_5974.nextInt(900) == 0 && this.field_6213 == 0) {
                this.method_6025(1.0f);
            }
            if ((interactionCooldown = this.getInteractionCooldown()) != 0) {
                this.setInteractionCooldown(interactionCooldown - 1);
            }
        }
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5805()) {
            if (this.method_5782() && this.method_5956() && this.method_6725()) {
                if (this.isScared()) {
                    this.method_5852();
                    return;
                }
                class_1309 primaryPassenger = (class_1309)this.method_5642();
                this.method_36456(primaryPassenger.method_36454());
                this.field_5982 = this.method_36454();
                this.method_36457(primaryPassenger.method_36455() * 0.5f);
                this.method_5710(this.method_36454(), this.method_36455());
                this.field_6241 = this.field_6283 = this.method_36454();
                float sidewaysSpeed = primaryPassenger.field_6212 * 0.25f;
                float forwardSpeed = primaryPassenger.field_6250 * 0.4f;
                if (forwardSpeed <= 0.0f) {
                    forwardSpeed *= 0.25f;
                }
                this.field_6281 = this.method_6029() * 0.1f;
                if (this.method_5787()) {
                    this.method_6125((float)this.method_26825(class_5134.field_23719));
                    super.method_6091(new class_243((double)sidewaysSpeed, movementInput.field_1351, (double)forwardSpeed));
                } else if (primaryPassenger instanceof class_1657) {
                    this.method_18799(class_243.field_1353);
                }
                this.method_29242((class_1309)this, false);
                this.method_36974();
            } else {
                this.field_6281 = 0.02f;
                super.method_6091(movementInput);
            }
        }
    }

    public boolean method_5810() {
        return !this.method_5782();
    }

    protected boolean method_6062() {
        return super.method_6062() && this.method_5782() && this.method_6725();
    }

    protected class_3414 method_6011(class_1282 source) {
        return LovelySnailsRegistry.SNAIL_HURT_SOUND_EVENT;
    }

    protected class_3414 method_6002() {
        return LovelySnailsRegistry.SNAIL_DEATH_SOUND_EVENT;
    }

    public void method_5614(int age) {
        this.field_5950 = age;
    }

    protected void method_5619() {
        if (!this.field_6002.method_8608() && !this.method_6109() && this.field_6002.method_8450().method_8355(class_1928.field_19391)) {
            this.method_5775(new class_1799((class_1935)class_1802.field_8777, 1 + this.field_5974.nextInt(2)));
        }
    }

    public boolean method_6109() {
        return (Boolean)this.field_6011.method_12789(CHILD);
    }

    public void method_7217(boolean baby) {
        Boolean wasBaby = (Boolean)this.field_6011.method_12789(CHILD);
        this.field_6011.method_12778(CHILD, (Object)baby);
        this.method_18382();
        if (wasBaby.booleanValue() && !baby && !this.reading) {
            this.method_5619();
        }
    }

    public class_1296 method_5613(class_3218 world, class_1296 otherParent) {
        SnailEntity child = (SnailEntity)LovelySnailsRegistry.SNAIL_ENTITY_TYPE.method_5883((class_1937)world);
        if (otherParent instanceof SnailEntity && this.method_6181()) {
            child.method_6174(this.method_6139());
            child.method_6173(true);
        }
        return child;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(LovelySnailsRegistry.SNAIL_BREEDING_ITEMS);
    }

    public float method_17825() {
        return this.method_6109() ? 0.35f : 1.0f;
    }

    private class SnailScreenHandlerFactory
    implements ExtendedScreenHandlerFactory {
        private SnailScreenHandlerFactory() {
        }

        private SnailEntity snail() {
            return SnailEntity.this;
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.method_10804(this.snail().method_5628());
            buf.writeByte(SnailScreenHandler.getOpeningStoragePage((class_1263)this.snail().inventory));
        }

        public class_2561 method_5476() {
            return this.snail().method_5476();
        }

        public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
            class_1277 snailInv = this.snail().inventory;
            return new SnailScreenHandler(syncId, inv, snailInv, this.snail(), SnailScreenHandler.getOpeningStoragePage((class_1263)snailInv));
        }
    }
}

