/*
 * Decompiled with CFR 0.152.
 */
package digidigi.mtmechs.entity;

import digidigi.mtmechs.MagitekMechs;
import digidigi.mtmechs.NetIdentifiers;
import digidigi.mtmechs.compat.FlanCompat;
import digidigi.mtmechs.compat.GOMLCompat;
import digidigi.mtmechs.screen.TunnelArmorScreenHandler;
import digidigi.mtmechs.sound.DrillingSoundInstance;
import digidigi.mtmechs.sound.GrindingSoundInstance;
import digidigi.mtmechs.sound.WheelSoundInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1113;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class TunnelArmorEntity
extends class_1314
implements IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int syncedMagiciteSlotted = -1;
    public int syncedFuelSlotted = 0;
    public int syncedEnergyStored = 0;
    public int syncedAddonSlotted = 0;
    public int energyStored = 0;
    public int energyMaximum = 0;
    public static class_2940<Byte> TA_FLAGS = class_2945.method_12791(TunnelArmorEntity.class, (class_2941)class_2943.field_13319);
    public static class_2940<Integer> ENERGY_STORED = class_2945.method_12791(TunnelArmorEntity.class, (class_2941)class_2943.field_13327);
    public static class_2940<Boolean> DRILL_GRINDING = class_2945.method_12791(TunnelArmorEntity.class, (class_2941)class_2943.field_13323);
    public static class_2940<Boolean> WHEELS_ROLLING = class_2945.method_12791(TunnelArmorEntity.class, (class_2941)class_2943.field_13323);
    public static class_2940<Optional<UUID>> OWNER = class_2945.method_12791(TunnelArmorEntity.class, (class_2941)class_2943.field_13313);
    public boolean hadPassengers = false;
    public double lastcollectspeed = 0.0;
    public double collectspeed = 0.0;
    public double moving = 0.0;
    public WheelSoundInstance rollsound;
    public GrindingSoundInstance grindsound;
    public DrillingSoundInstance drillsound;
    public boolean isGrinding = false;
    public boolean isRolling = false;
    public boolean isDrilling = false;
    public boolean isLifting = false;
    public boolean isLifted = false;
    public int liftTimer = 0;
    public boolean animLift = false;
    public boolean isOn = false;
    public boolean wasOn = false;
    public List<class_2338> blocksPositions = new ArrayList<class_2338>();
    public List<Integer> blocksProgress = new ArrayList<Integer>();
    public List<class_2338> newBlocksPositions = new ArrayList<class_2338>();
    public List<Integer> newBlocksProgress = new ArrayList<Integer>();
    public class_1277 inventory;
    public int smokecounter = 0;
    private long serverCurrentTime;
    private long serverDeltaTime;
    private long serverLastTime;
    private class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return TunnelArmorEntity.this.syncedMagiciteSlotted;
            }
            if (index == 1) {
                return TunnelArmorEntity.this.syncedAddonSlotted;
            }
            if (index == 2) {
                return TunnelArmorEntity.this.syncedEnergyStored;
            }
            return -1;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                TunnelArmorEntity.this.syncedMagiciteSlotted = value;
            }
            if (index == 1) {
                TunnelArmorEntity.this.syncedAddonSlotted = value;
            }
            if (index == 2) {
                TunnelArmorEntity.this.syncedEnergyStored = value;
            }
        }

        public int method_17389() {
            return 5;
        }
    };

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TA_FLAGS, (Object)0);
        this.field_6011.method_12784(ENERGY_STORED, (Object)0);
        this.field_6011.method_12784(DRILL_GRINDING, (Object)false);
        this.field_6011.method_12784(WHEELS_ROLLING, (Object)false);
        this.field_6011.method_12784(OWNER, Optional.empty());
    }

    public void dataSetIsOn(boolean truth) {
        if (this.isOn != truth) {
            byte b = (Byte)this.field_6011.method_12789(TA_FLAGS);
            this.field_6011.method_12778(TA_FLAGS, (Object)(truth ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE)));
            this.isOn = truth;
        }
    }

    public boolean dataGetIsOn() {
        return ((Byte)this.field_6011.method_12789(TA_FLAGS) & 1) != 0;
    }

    public void dataSetDrilling(boolean truth) {
        if (this.isDrilling != truth) {
            byte b = (Byte)this.field_6011.method_12789(TA_FLAGS);
            this.field_6011.method_12778(TA_FLAGS, (Object)(truth ? (byte)(b | 2) : (byte)(b & 0xFFFFFFFD)));
            this.isDrilling = truth;
        }
    }

    public boolean dataGetDrilling() {
        return ((Byte)this.field_6011.method_12789(TA_FLAGS) & 2) != 0;
    }

    public void dataSetLifting(boolean truth) {
        if (this.isLifting != truth) {
            byte b = (Byte)this.field_6011.method_12789(TA_FLAGS);
            this.field_6011.method_12778(TA_FLAGS, (Object)(truth ? (byte)(b | 4) : (byte)(b & 0xFFFFFFFB)));
            this.isLifting = truth;
        }
    }

    public boolean dataGetLifting() {
        return ((Byte)this.field_6011.method_12789(TA_FLAGS) & 4) != 0;
    }

    public void dataSetLifted(boolean truth) {
        if (this.isLifted != truth) {
            byte b = (Byte)this.field_6011.method_12789(TA_FLAGS);
            this.field_6011.method_12778(TA_FLAGS, (Object)(truth ? (byte)(b | 8) : (byte)(b & 0xFFFFFFF7)));
            this.isLifted = truth;
        }
    }

    public boolean dataGetLifted() {
        return ((Byte)this.field_6011.method_12789(TA_FLAGS) & 8) != 0;
    }

    public void dataSetFuel(int energy) {
        this.field_6011.method_12778(ENERGY_STORED, (Object)energy);
    }

    public int dataGetFuel() {
        return (Integer)this.field_6011.method_12789(ENERGY_STORED);
    }

    public void dataSetDrillGrinding(boolean truth) {
        this.field_6011.method_12778(DRILL_GRINDING, (Object)truth);
    }

    public boolean dataGetDrillGrinding() {
        return (Boolean)this.field_6011.method_12789(DRILL_GRINDING);
    }

    public void dataSetOwner(UUID owner) {
        this.field_6011.method_12778(OWNER, Optional.of(owner));
    }

    public Optional<UUID> dataGetOwner() {
        return (Optional)this.field_6011.method_12789(OWNER);
    }

    public boolean hasSidewaysVelocity() {
        return this.method_18798().field_1352 != 0.0 | this.method_18798().field_1350 != 0.0;
    }

    private <E extends IAnimatable> PlayState predicateLift(AnimationEvent<E> event) {
        if (!this.dataGetIsOn() || this.dataGetFuel() == 0 || !this.dataGetDrilling()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tunnelarmor.liftdefault", Boolean.valueOf(true)));
            this.animLift = false;
            return PlayState.CONTINUE;
        }
        if (this.dataGetLifted()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tunnelarmor.liftextended", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.getController().getAnimationState() == AnimationState.Stopped) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tunnelarmor.liftextended", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.dataGetLifting() && !this.animLift) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tunnelarmor.lift", Boolean.valueOf(false)));
            this.animLift = true;
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateDrill(AnimationEvent<E> event) {
        if (!this.dataGetIsOn() || this.dataGetFuel() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tunnelarmor.liftdefault", Boolean.valueOf(true)));
            return PlayState.STOP;
        }
        if (this.dataGetDrilling()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tunnelarmor.drills", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public double getforward() {
        double vx = this.method_18798().method_10216();
        double vy = 0.0;
        double vz = this.method_18798().method_10215();
        class_243 velocity = new class_243(vx, vy, vz);
        vx = this.method_5735().method_10163().method_10263();
        vz = this.method_5735().method_10163().method_10260();
        class_243 facing = new class_243(vx, vy, vz);
        double dot = velocity.method_1026(facing);
        return dot;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.hasSidewaysVelocity() && !this.method_5685().isEmpty() && this.energyStored > 0) {
            this.moving = 1.0;
            this.lastcollectspeed = this.collectspeed;
            this.collectspeed += this.getforward() * 25.0;
        } else {
            this.moving = 0.0;
        }
        GeckoLibCache.getInstance().parser.setValue("variable.collectspeed", this.collectspeed);
        GeckoLibCache.getInstance().parser.setValue("variable.moving", this.moving);
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tunnelarmor.wheelsforward", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controllerDrill", 0.0f, this::predicateDrill));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controllerLift", 0.0f, this::predicateLift));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public TunnelArmorEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6013 = 1.0f;
        this.method_36456(0.0f);
        this.method_5660(true);
        this.inventory = new class_1277(12);
    }

    @Nullable
    public class_1297 getControllingPassenger() {
        return this.method_5685().isEmpty() ? null : (class_1297)this.method_5685().get(0);
    }

    @Environment(value=EnvType.CLIENT)
    public void tickSmoke() {
        if (this.field_6002.field_9236 && this.energyStored > 0) {
            ++this.smokecounter;
            if (this.smokecounter == 5) {
                this.smokecounter = 0;
            }
            if (this.smokecounter == 0) {
                double fz;
                class_243 p = this.method_19538();
                double aim = Math.toRadians(this.method_36454() * -1.0f);
                double fx = Math.sin(aim);
                double sx = fz = Math.cos(aim);
                double sz = fx * -1.0;
                if (this.isRolling) {
                    class_243 lp = new class_243(p.field_1352 + sx * 0.32 + fx * -1.1, 0.0, p.field_1350 + sz * 0.32 + fz * -1.1);
                    class_243 rp = new class_243(p.field_1352 - sx * 0.32 + fx * -1.1, 0.0, p.field_1350 - sz * 0.32 + fz * -1.1);
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, lp.field_1352, p.field_1351 + 2.0, lp.field_1350, 0.0 - fx * 0.05, 0.0, 0.0 - fz * 0.05);
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, rp.field_1352, p.field_1351 + 2.0, rp.field_1350, 0.0 - fx * 0.05, 0.0, 0.0 - fz * 0.05);
                }
                if (this.isOn) {
                    class_243 blp = new class_243(p.field_1352 + sx * 0.77 + fx * -0.77, 0.0, p.field_1350 + sz * 0.77 + fz * -0.77);
                    class_243 brp = new class_243(p.field_1352 - sx * 0.77 + fx * -0.77, 0.0, p.field_1350 - sz * 0.77 + fz * -0.77);
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, blp.field_1352, p.field_1351 + 2.2, blp.field_1350, 0.0 - fx * 0.05, 0.0, 0.0 - fz * 0.05);
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, brp.field_1352, p.field_1351 + 2.2, brp.field_1350, 0.0 - fx * 0.05, 0.0, 0.0 - fz * 0.05);
                }
                if (this.isDrilling) {
                    class_243 flp = new class_243(p.field_1352 + sx * 0.77 + fx * -0.17, 0.0, p.field_1350 + sz * 0.77 + fz * -0.17);
                    class_243 frp = new class_243(p.field_1352 - sx * 0.77 + fx * -0.17, 0.0, p.field_1350 - sz * 0.77 + fz * -0.17);
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, flp.field_1352, p.field_1351 + 2.3, flp.field_1350, 0.0, 0.0, 0.0);
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, frp.field_1352, p.field_1351 + 2.3, frp.field_1350, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean checkIfAir(class_2338 bp) {
        class_2680 bs = this.field_6002.method_8320(bp);
        float hardness = bs.method_26214((class_1922)this.field_6002, bp);
        if (!bs.method_26215()) {
            return !((double)hardness > 0.0);
        }
        return true;
    }

    public int updateBlockProgress(class_2338 currentblock, int existingprog) {
        if (existingprog < 10) {
            this.field_6002.method_8517(this.method_5628(), currentblock, ++existingprog);
        } else {
            existingprog = 0;
            if (!this.field_6002.field_9236) {
                this.field_6002.method_22352(currentblock, true);
            }
        }
        return existingprog;
    }

    public void manageBlocks(class_2338 bp) {
        class_2680 bs = this.field_6002.method_8320(bp);
        float hardness = bs.method_26214((class_1922)this.field_6002, bp);
        if ((double)hardness > 0.0) {
            if (this.blocksPositions.contains(bp)) {
                int idx = this.blocksPositions.indexOf(bp);
                this.newBlocksPositions.add(bp);
                int prog = this.updateBlockProgress(bp, this.blocksProgress.get(idx));
                this.newBlocksProgress.add(prog);
            } else {
                this.newBlocksPositions.add(bp);
                int prog = this.updateBlockProgress(bp, 0);
                this.newBlocksProgress.add(prog);
            }
        }
    }

    public void tickFuel() {
        if (!this.field_6002.field_9236) {
            int spEnergyStored = 0;
            if (this.energyStored == 0) {
                if (this.syncedMagiciteSlotted == 1) {
                    class_1799 fuelStackA = this.inventory.method_5438(9);
                    class_1799 fuelStackB = this.inventory.method_5438(10);
                    if (fuelStackA != null && fuelStackB != null) {
                        class_1792 fuelItemA = fuelStackA.method_7909();
                        class_1792 fuelItemB = fuelStackB.method_7909();
                        if (fuelItemA != null && fuelItemA == fuelItemB && FuelRegistry.INSTANCE.get((class_1935)fuelItemA) != null) {
                            int fuelAmount = (Integer)FuelRegistry.INSTANCE.get((class_1935)fuelItemA);
                            if (fuelItemA instanceof class_1755) {
                                this.inventory.method_5447(9, class_1802.field_8550.method_7854());
                                this.inventory.method_5447(10, class_1802.field_8550.method_7854());
                            } else {
                                this.inventory.method_5434(9, 1);
                                this.inventory.method_5434(10, 1);
                            }
                            this.energyStored += fuelAmount;
                            this.energyMaximum = fuelAmount;
                        }
                    }
                }
            } else {
                --this.energyStored;
                if (this.energyStored < 0) {
                    this.energyStored = 0;
                }
                float dv = (float)((double)this.energyMaximum / 10.0);
                spEnergyStored = (int)Math.ceil((float)this.energyStored / dv);
            }
            this.propertyDelegate.method_17391(2, spEnergyStored);
            this.dataSetFuel(this.energyStored);
        }
    }

    public void tickDrill() {
        if (this.method_5685().isEmpty()) {
            this.isRolling = false;
        } else if (this.isDrilling && this.isOn) {
            this.field_6013 = 0.0f;
            double aim = Math.toRadians(this.method_36454() * -1.0f);
            double fx = Math.sin(aim);
            double fz = Math.cos(aim);
            class_243 tapos = this.method_19538();
            class_243 robpos = new class_243(tapos.field_1352 + fx * 2.0, tapos.field_1351, tapos.field_1350 + fz * 2.0);
            class_243 roblpos = new class_243(robpos.field_1352 + fz, robpos.field_1351, robpos.field_1350 + fx * -1.0);
            class_243 robrpos = new class_243(robpos.field_1352 + fz * -1.0, robpos.field_1351, robpos.field_1350 + fx);
            class_243 rompos = new class_243(tapos.field_1352 + fx * 2.0, robpos.field_1351 + 1.0, tapos.field_1350 + fz * 2.0);
            class_243 rolpos = new class_243(robpos.field_1352 + fz, robpos.field_1351 + 1.0, robpos.field_1350 + fx * -1.0);
            class_243 rorpos = new class_243(robpos.field_1352 + fz * -1.0, robpos.field_1351 + 1.0, robpos.field_1350 + fx);
            class_243 rotpos = new class_243(tapos.field_1352 + fx * 2.0, robpos.field_1351 + 2.0, tapos.field_1350 + fz * 2.0);
            class_243 rotlpos = new class_243(robpos.field_1352 + fz, robpos.field_1351 + 2.0, robpos.field_1350 + fx * -1.0);
            class_243 rotrpos = new class_243(robpos.field_1352 + fz * -1.0, robpos.field_1351 + 2.0, robpos.field_1350 + fx);
            class_2338 bp_rob = new class_2338(robpos);
            class_2338 bp_robl = new class_2338(roblpos);
            class_2338 bp_robr = new class_2338(robrpos);
            class_2338 bp_rom = new class_2338(rompos);
            class_2338 bp_rol = new class_2338(rolpos);
            class_2338 bp_ror = new class_2338(rorpos);
            class_2338 bp_rot = new class_2338(rotpos);
            class_2338 bp_rotl = new class_2338(rotlpos);
            class_2338 bp_rotr = new class_2338(rotrpos);
            if (!this.method_5685().isEmpty()) {
                if (!this.field_6002.field_9236) {
                    class_3222 pilot = (class_3222)this.method_5685().get(0);
                    if (!FlanCompat.hasPermission(this.field_6002, bp_rob, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_rob, pilot)) {
                        return;
                    }
                    if (!FlanCompat.hasPermission(this.field_6002, bp_robl, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_robl, pilot)) {
                        return;
                    }
                    if (!FlanCompat.hasPermission(this.field_6002, bp_robr, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_robr, pilot)) {
                        return;
                    }
                    if (!FlanCompat.hasPermission(this.field_6002, bp_rom, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_rom, pilot)) {
                        return;
                    }
                    if (!FlanCompat.hasPermission(this.field_6002, bp_rol, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_rol, pilot)) {
                        return;
                    }
                    if (!FlanCompat.hasPermission(this.field_6002, bp_ror, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_ror, pilot)) {
                        return;
                    }
                    if (!FlanCompat.hasPermission(this.field_6002, bp_rot, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_rot, pilot)) {
                        return;
                    }
                    if (!FlanCompat.hasPermission(this.field_6002, bp_rotl, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_rotl, pilot)) {
                        return;
                    }
                    if (!FlanCompat.hasPermission(this.field_6002, bp_rotr, pilot)) {
                        return;
                    }
                    if (!GOMLCompat.hasPermission(this.field_6002, bp_rotr, pilot)) {
                        return;
                    }
                }
            } else {
                return;
            }
            if (this.field_6002.field_9236) {
                this.makeDrillSound(fx, fz);
                if (!this.isGrinding) {
                    boolean blockIsAir = true;
                    blockIsAir = this.checkIfAir(bp_rob) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_robl) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_robr) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rom) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rol) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_ror) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rot) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rotl) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rotr) & blockIsAir;
                    if (!blockIsAir) {
                        this.isGrinding = true;
                        this.makeGrindSound(fx, fz);
                    }
                } else {
                    boolean blockIsAir = true;
                    blockIsAir = this.checkIfAir(bp_rob) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_robl) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_robr) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rom) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rol) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_ror) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rot) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rotl) & blockIsAir;
                    blockIsAir = this.checkIfAir(bp_rotr) & blockIsAir;
                    if (blockIsAir) {
                        this.isGrinding = false;
                        this.stopGrindSound();
                    }
                }
            }
            if (!this.newBlocksPositions.isEmpty()) {
                this.newBlocksPositions.clear();
                this.newBlocksProgress.clear();
            }
            this.manageBlocks(bp_rob);
            this.manageBlocks(bp_robl);
            this.manageBlocks(bp_robr);
            this.manageBlocks(bp_rom);
            this.manageBlocks(bp_rol);
            this.manageBlocks(bp_ror);
            this.manageBlocks(bp_rot);
            this.manageBlocks(bp_rotl);
            this.manageBlocks(bp_rotr);
            if (!this.blocksPositions.isEmpty()) {
                this.blocksPositions.clear();
                this.blocksProgress.clear();
            }
            this.blocksPositions.addAll(this.newBlocksPositions);
            this.blocksProgress.addAll(this.newBlocksProgress);
            if (!this.blocksPositions.isEmpty()) {
                this.dataSetDrillGrinding(true);
            } else {
                this.dataSetDrillGrinding(false);
            }
        } else {
            this.field_6013 = 1.0f;
        }
    }

    public void tickGravity() {
        if (!this.method_5782() && (this.method_6034() || this.method_5787())) {
            double d = -0.0784000015258789;
            if (this.field_6002.method_8320(this.method_24515().method_10069(0, -1, 0)).method_26204() == class_2246.field_10124) {
                this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
                this.method_18799(this.method_18798().method_1031(0.0, d, 0.0));
                this.method_5784(class_1313.field_6308, this.method_18798());
            } else {
                this.method_18799(new class_243(0.0, -0.3, 0.0));
                this.method_5784(class_1313.field_6308, this.method_18798());
            }
        }
    }

    public void method_5773() {
        boolean magitekSlotDT;
        if (!this.method_5685().isEmpty() && !this.hadPassengers) {
            this.hadPassengers = true;
        } else if (this.method_5685().isEmpty() && this.hadPassengers) {
            this.hadPassengers = false;
            this.dataSetDrillGrinding(false);
            this.dataSetDrilling(false);
            this.dataSetLifted(false);
            this.isDrilling = false;
            this.isGrinding = false;
            this.isLifting = false;
            this.isLifted = false;
            if (this.field_6002.field_9236) {
                this.stopSounds();
            }
        }
        this.tickGravity();
        this.tickFuel();
        int magitekSlotPD = this.propertyDelegate.method_17390(0);
        this.isOn = magitekSlotDT = this.dataGetIsOn();
        if (magitekSlotDT) {
            if (!this.wasOn) {
                if (this.field_6002.field_9236 && class_310.method_1551().field_1724.field_7512 instanceof TunnelArmorScreenHandler) {
                    class_310.method_1551().field_1724.method_5783(MagitekMechs.mechon, 1.0f, 1.0f);
                }
                this.wasOn = true;
            }
        } else if (this.wasOn) {
            if (this.field_6002.field_9236 && class_310.method_1551().field_1724.field_7512 instanceof TunnelArmorScreenHandler) {
                class_310.method_1551().field_1724.method_5783(MagitekMechs.mechoff, 1.0f, 1.0f);
            }
            this.wasOn = false;
        }
        if (this.field_6002.field_9236) {
            this.tickSmoke();
            this.energyStored = this.dataGetFuel();
        } else if (magitekSlotPD == 1) {
            this.dataSetIsOn(true);
        } else {
            this.dataSetIsOn(false);
        }
        if (!this.field_6002.field_9236) {
            this.serverCurrentTime = System.currentTimeMillis();
            this.serverDeltaTime = this.serverCurrentTime - this.serverLastTime;
            this.serverLastTime = this.serverCurrentTime;
            if (this.dataGetLifting() && !this.dataGetLifted()) {
                if (this.liftTimer < 500) {
                    this.liftTimer = (int)((long)this.liftTimer + this.serverDeltaTime);
                } else {
                    this.dataSetLifting(false);
                    this.dataSetLifted(true);
                    this.liftTimer = 0;
                }
            }
            if (this.isOn && this.energyStored <= 0) {
                this.isOn = false;
            }
        } else {
            this.continueDrillSound();
            this.continueGrindSound();
        }
        super.method_5773();
        this.tickDrill();
        if (this.field_6002.field_9236) {
            if ((int)this.collectspeed != (int)this.lastcollectspeed) {
                if (!this.isRolling && !this.method_5685().isEmpty()) {
                    this.isRolling = true;
                }
            } else if (this.isRolling) {
                this.stopRollSound();
                this.isRolling = false;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void makeRollSound(double xoff, double zoff) {
    }

    @Environment(value=EnvType.CLIENT)
    public void stopRollSound() {
        if (this.rollsound != null) {
            this.rollsound.soundManager.method_4870((class_1113)this.rollsound);
            this.rollsound = null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void continueRollSound() {
    }

    @Environment(value=EnvType.CLIENT)
    public void makeGrindSound(double xoff, double zoff) {
        if (this.grindsound == null) {
            this.grindsound = new GrindingSoundInstance(this, MagitekMechs.grind_loop, class_3419.field_15256, 100.0f, 1.0f, this.method_23317() + xoff, this.method_23318(), this.method_23321() + zoff);
            this.grindsound.soundManager.method_4873((class_1113)this.grindsound);
        } else {
            this.grindsound.moveSound();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void stopGrindSound() {
        if (this.grindsound != null) {
            this.grindsound.soundManager.method_4870((class_1113)this.grindsound);
            this.grindsound = null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void continueGrindSound() {
        if (this.isOn) {
            if (this.dataGetDrillGrinding()) {
                if (this.grindsound != null) {
                    this.grindsound.method_16896();
                }
            } else {
                this.stopGrindSound();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void makeDrillSound(double xoff, double zoff) {
        if (this.drillsound == null) {
            this.drillsound = new DrillingSoundInstance(this, MagitekMechs.drill_loop, class_3419.field_15256, 100.0f, 0.92f, this.method_23317() + xoff, this.method_23318(), this.method_23321() + zoff);
            this.drillsound.soundManager.method_4873((class_1113)this.drillsound);
        } else {
            this.drillsound.finished = false;
            this.drillsound.moveSound();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void stopDrillSound() {
        if (this.drillsound != null) {
            this.drillsound.soundManager.method_4870((class_1113)this.drillsound);
            this.drillsound = null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void continueDrillSound() {
        this.isDrilling = this.dataGetDrilling();
        if (this.isOn) {
            if (this.isDrilling) {
                if (this.drillsound != null) {
                    this.drillsound.method_16896();
                }
            } else {
                this.stopDrillSound();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void stopSounds() {
        if (this.drillsound != null) {
            this.drillsound.soundManager.method_4870((class_1113)this.drillsound);
            this.drillsound.finished = true;
        }
        if (this.grindsound != null) {
            this.grindsound.soundManager.method_4870((class_1113)this.grindsound);
            this.grindsound.finished = true;
        }
        if (this.rollsound != null) {
            this.rollsound.soundManager.method_4870((class_1113)this.rollsound);
            this.rollsound.finished = true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void drillToggle() {
        if (!this.isDrilling) {
            if (this.dataGetIsOn() && this.dataGetFuel() != 0) {
                this.isDrilling = true;
                this.isLifting = true;
                this.sendDrillToggle(true);
            }
        } else {
            this.isDrilling = false;
            this.isLifting = false;
            this.sendDrillToggle(false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void sendDrillToggle(Boolean toggle) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(toggle.booleanValue());
        ClientPlayNetworking.send((class_2960)NetIdentifiers.ta_p_to_server, (class_2540)buf);
        if (!toggle.booleanValue()) {
            this.stopGrindSound();
            this.stopDrillSound();
        }
    }

    public static void receiveDrillToggleServer(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        Boolean drillstate = buf.readBoolean();
        class_1297 vehicle = player.method_5854();
        TunnelArmorEntity taentity = (TunnelArmorEntity)vehicle;
        if (!drillstate.booleanValue()) {
            taentity.liftTimer = 0;
            taentity.dataSetLifting(false);
            taentity.dataSetLifted(false);
            taentity.dataSetDrilling(false);
            taentity.dataSetDrillGrinding(false);
        } else {
            taentity.dataSetLifting(true);
            taentity.dataSetLifted(false);
            taentity.dataSetDrilling(true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void receiveDismount(class_634 handler1, PacketSender sender1, class_310 client1, class_2540 buf) {
        class_1297 vehicle;
        class_1297 player;
        int entityid = buf.readInt();
        if (client1.field_1687 != null && (player = client1.field_1687.method_8469(entityid)) != null && (vehicle = player.method_5854()) != null) {
            player.method_5854().method_5628();
            TunnelArmorEntity taentity = (TunnelArmorEntity)vehicle;
            if (taentity != null) {
                taentity.isGrinding = false;
                taentity.isRolling = false;
                taentity.isDrilling = false;
                taentity.isLifting = false;
                taentity.stopGrindSound();
                taentity.stopDrillSound();
            }
        }
    }

    public class_243 method_24829(class_1309 passenger) {
        this.isGrinding = false;
        this.isRolling = false;
        this.dataSetDrilling(false);
        this.dataSetLifting(false);
        this.dataSetLifted(false);
        MinecraftServer server = this.field_6002.method_8503();
        class_3222 player = (class_3222)passenger;
        Collection players = PlayerLookup.around((class_3218)server.method_3847(player.field_6002.method_27983()), (class_243)player.method_19538(), (double)1000.0);
        for (class_3222 otherplayer : players) {
            if (otherplayer == player) continue;
            class_2540 buf2 = PacketByteBufs.create();
            buf2.writeInt(player.method_5628());
            ServerPlayNetworking.send((class_3222)otherplayer, (class_2960)NetIdentifiers.ta_dismount_to_clients, (class_2540)buf2);
        }
        return new class_243(this.method_23317(), this.method_5829().field_1325 - 1.0, this.method_23321());
    }

    public void method_6091(class_243 pos) {
        if (this.method_5805() && this.method_5782() && this.isOn) {
            class_1309 livingentity = (class_1309)this.getControllingPassenger();
            this.method_36456(livingentity.method_36454());
            this.field_5982 = this.method_36454();
            this.method_36457(livingentity.method_36455() * 0.5f);
            this.method_5710(this.method_36454(), this.method_36455());
            this.method_5636(this.method_36454());
            this.method_5847(this.method_36454());
            float f = livingentity.field_6212 * 0.25f;
            float f1 = livingentity.field_6250 * 0.5f;
            if (f1 <= 0.0f) {
                f1 *= 0.5f;
            }
            this.method_6125(0.4f);
            if (this.energyStored > 0 && this.isOn) {
                super.method_6091(new class_243((double)f, pos.field_1351, (double)f1));
            } else {
                super.method_6091(new class_243(0.0, 0.0, 0.0));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void clientOpeningSound(class_1657 player) {
        player.method_5783(MagitekMechs.opening, 1.0f, 1.0f);
    }

    public boolean method_5698(class_1297 attacker) {
        if (!this.field_6002.method_8608() && MagitekMechs.attachedMods.contains("techreborn")) {
            class_1657 player = (class_1657)attacker;
            if (!this.field_6002.method_8450().method_8355(MagitekMechs.MECH_OWNERSHIP) || player.method_5667().equals(this.dataGetOwner().orElse(new UUID(0L, 0L)))) {
                int slot = player.method_31548().field_7545;
                class_1799 mainStack = player.method_31548().method_5438(slot);
                if (mainStack != null) {
                    String[] itemRegFullName = class_2378.field_11142.method_10221((Object)mainStack.method_7909()).toString().split(":");
                    String itemRegName = itemRegFullName[itemRegFullName.length - 1];
                    Pattern p = Pattern.compile("_wrench");
                    Pattern p2 = Pattern.compile("^wrench$");
                    Matcher m = p.matcher(itemRegName);
                    boolean b = m.find();
                    m = p2.matcher(itemRegName);
                    boolean b2 = m.find();
                    if (b || b2) {
                        this.method_16078();
                        class_1264.method_5449((class_1937)this.field_6002, (double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321(), (class_1799)MagitekMechs.TA_WHOLE_ITEM.method_7854());
                        this.method_31745(class_1297.class_5529.field_26999);
                        return true;
                    }
                }
            }
        }
        return super.method_5698(attacker);
    }

    @Nullable
    public class_1297 method_5642() {
        return super.method_5642();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.dataGetOwner().isEmpty()) {
            this.writeOwner(player.method_5667());
        }
        if (this.field_6002.method_8450().method_8355(MagitekMechs.MECH_OWNERSHIP) && !player.method_5667().equals(this.dataGetOwner().orElse(null))) {
            player.method_7353((class_2561)new class_2588("misc.mtmechs.locked"), true);
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (player.method_21823()) {
            class_1799 handstack = player.method_5998(hand);
            if (this.field_6002.field_9236) {
                this.clientOpeningSound(player);
            }
            this.openScreen(player, this.inventory, handstack);
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (!this.field_6002.field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
        return class_1269.method_29236((boolean)this.field_6002.field_9236);
    }

    private void openScreen(class_1657 player, final class_1277 minventory, final class_1799 handstack) {
        if (player.field_6002 != null && !player.field_6002.field_9236) {
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
                    packetByteBuf.method_10793(handstack);
                }

                public class_2561 method_5476() {
                    return new class_2588("inventory.mtmechs.tunnelarmor");
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new TunnelArmorScreenHandler(syncId, inv, (class_1263)minventory, TunnelArmorEntity.this.propertyDelegate);
                }
            });
        }
    }

    public int getMagiciteSlot() {
        return 11;
    }

    public void writeOwner(UUID owner) {
        this.dataSetOwner(owner);
        class_2487 compoundTag = new class_2487();
        compoundTag.method_25927("owner", owner);
        this.method_5647(compoundTag);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        class_2499 listTag = new class_2499();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)i);
            itemStack.method_7953(compoundTag);
            listTag.add((Object)compoundTag);
        }
        tag.method_10566("Items", (class_2520)listTag);
        class_2487 energyStoredTag = new class_2487();
        energyStoredTag.method_10569("EnergyStored", this.energyStored);
        class_2487 energyMaxTag = new class_2487();
        energyMaxTag.method_10569("EnergyMaximum", this.energyMaximum);
        class_2499 energyListTag = new class_2499();
        energyListTag.add((Object)energyStoredTag);
        energyListTag.add((Object)energyMaxTag);
        tag.method_10566("Energy", (class_2520)energyListTag);
        if (!this.dataGetOwner().isEmpty()) {
            tag.method_25927("owner", this.dataGetOwner().orElse(new UUID(0L, 0L)));
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        class_2499 listTag = tag.method_10554("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag = listTag.method_10602(i);
            int j = compoundTag.method_10571("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.method_5439()) continue;
            class_1799 is = class_1799.method_7915((class_2487)compoundTag);
            if (j == this.getMagiciteSlot() && is.method_7909() == MagitekMechs.MAGICITE_ITEM) {
                this.dataSetIsOn(true);
                this.propertyDelegate.method_17391(0, 1);
            }
            this.inventory.method_5447(j, is);
        }
        class_2499 energyListTag = tag.method_10554("Energy", 10);
        class_2487 energyStoredTag = energyListTag.method_10602(0);
        class_2487 energyMaxTag = energyListTag.method_10602(1);
        this.energyStored = energyStoredTag.method_10550("EnergyStored");
        this.energyMaximum = energyMaxTag.method_10550("EnergyMaximum");
        if (tag.method_10545("owner")) {
            this.dataSetOwner(tag.method_25926("owner"));
        }
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource == class_1282.field_5855) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        if (this.field_6002.field_9236) {
            this.stopSounds();
        }
    }

    public boolean method_5753() {
        return true;
    }

    public double method_5621() {
        return 0.75;
    }

    protected void method_16078() {
        super.method_16078();
        class_1264.method_5451((class_1937)this.field_6002, (class_2338)this.method_24515(), (class_1263)this.inventory);
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_5956() {
        return true;
    }

    public boolean method_6094() {
        return true;
    }

    public boolean method_5788() {
        return true;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }
}

