/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPanelWithInsets;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import java.util.Objects;

public class WBox
extends WPanelWithInsets {
    protected int spacing = 4;
    protected Axis axis;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;

    public WBox(Axis axis) {
        this.axis = Objects.requireNonNull(axis, "axis");
    }

    public void add(WWidget widget, int width, int height) {
        widget.setParent(this);
        this.children.add(widget);
        if (this.canResize()) {
            widget.setSize(width, height);
        }
    }

    public void add(WWidget widget) {
        this.add(widget, 18, 18);
    }

    @Override
    public void layout() {
        int dimension = this.axis.choose(this.insets.left(), this.insets.top());
        if (this.axis == Axis.HORIZONTAL && this.horizontalAlignment != HorizontalAlignment.LEFT) {
            int widgetWidth = this.spacing * (this.children.size() - 1);
            for (WWidget child : this.children) {
                widgetWidth += child.getWidth();
            }
            dimension = this.horizontalAlignment == HorizontalAlignment.CENTER ? (this.getWidth() - widgetWidth) / 2 : this.getWidth() - widgetWidth;
        } else if (this.verticalAlignment != VerticalAlignment.TOP) {
            int widgetHeight = this.spacing * (this.children.size() - 1);
            for (WWidget child : this.children) {
                widgetHeight += child.getHeight();
            }
            dimension = this.verticalAlignment == VerticalAlignment.CENTER ? (this.getHeight() - widgetHeight) / 2 : this.getHeight() - widgetHeight;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            WWidget child = (WWidget)this.children.get(i);
            if (this.axis == Axis.HORIZONTAL) {
                int y = switch (this.verticalAlignment) {
                    default -> throw new IncompatibleClassChangeError();
                    case VerticalAlignment.TOP -> this.insets.top();
                    case VerticalAlignment.CENTER -> this.insets.top() + (this.getHeight() - this.insets.top() - this.insets.bottom() - child.getHeight()) / 2;
                    case VerticalAlignment.BOTTOM -> this.getHeight() - this.insets.bottom() - child.getHeight();
                };
                child.setLocation(dimension, y);
            } else {
                int x = switch (this.horizontalAlignment) {
                    default -> throw new IncompatibleClassChangeError();
                    case HorizontalAlignment.LEFT -> this.insets.left();
                    case HorizontalAlignment.CENTER -> this.insets.left() + (this.getWidth() - this.insets.left() - this.insets.right() - child.getWidth()) / 2;
                    case HorizontalAlignment.RIGHT -> this.getWidth() - this.insets.right() - child.getWidth();
                };
                child.setLocation(x, dimension);
            }
            if (child instanceof WPanel) {
                ((WPanel)child).layout();
            }
            this.expandToFit(child, this.insets);
            if (i != this.children.size() - 1) {
                dimension += this.spacing;
            }
            dimension += this.axis.choose(child.getWidth(), child.getHeight()).intValue();
        }
    }

    public int getSpacing() {
        return this.spacing;
    }

    public WBox setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public WBox setAxis(Axis axis) {
        this.axis = Objects.requireNonNull(axis, "axis");
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WBox setHorizontalAlignment(HorizontalAlignment alignment) {
        this.horizontalAlignment = Objects.requireNonNull(alignment, "alignment");
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WBox setVerticalAlignment(VerticalAlignment alignment) {
        this.verticalAlignment = Objects.requireNonNull(alignment, "alignment");
        return this;
    }

    @Override
    public WBox setInsets(Insets insets) {
        super.setInsets(insets);
        return this;
    }
}

