/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen;

import com.google.common.collect.ImmutableList;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.conditional.MermaidsBrushBlock;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.worldgen.SpectrumFeatures;
import de.dafuqs.spectrum.worldgen.features.WeightedRandomFeatureConfig;
import de.dafuqs.spectrum.worldgen.features.WeightedRandomFeaturePatchConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1767;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3175;
import net.minecraft.class_3481;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.class_4643;
import net.minecraft.class_4646;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_5140;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5458;
import net.minecraft.class_5585;
import net.minecraft.class_5586;
import net.minecraft.class_5587;
import net.minecraft.class_5589;
import net.minecraft.class_5843;
import net.minecraft.class_5925;
import net.minecraft.class_5929;
import net.minecraft.class_6005;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6333;
import net.minecraft.class_6646;
import net.minecraft.class_6655;
import net.minecraft.class_6658;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6803;
import net.minecraft.class_6806;
import net.minecraft.class_6817;
import net.minecraft.class_6819;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

public class SpectrumConfiguredFeatures {
    public static class_2975<?, ?> CITRINE_GEODE;
    public static class_2975<?, ?> TOPAZ_GEODE;
    public static class_2975<?, ?> MOONSTONE_GEODE;
    public static HashMap<class_1767, class_2975<class_4643, ?>> COLORED_TREE_CONFIGURED_FEATURES;
    public static class_6796 RANDOM_COLORED_TREES_FEATURE;

    public static void register() {
        SpectrumConfiguredFeatures.registerGeodes();
        SpectrumConfiguredFeatures.registerOres();
        SpectrumConfiguredFeatures.registerColoredTrees();
        SpectrumConfiguredFeatures.registerPlants();
    }

    private static <FC extends class_3037> class_2975<?, ?> registerConfiguredFeature(class_2960 identifier, class_2975<?, ?> configuredFeature) {
        return (class_2975)class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)identifier, configuredFeature);
    }

    private static class_6796 registerPlacedFeature(class_2960 identifier, class_6796 placedFeature) {
        return (class_6796)class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)identifier, (Object)placedFeature);
    }

    private static class_6796 registerConfiguredAndPlacedFeature(class_2960 identifier, class_2975<?, ?> configuredFeature, List<class_6797> placementModifiers) {
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)identifier, configuredFeature);
        class_6796 placedFeature = configuredFeature.method_39593(placementModifiers);
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)identifier, (Object)placedFeature);
        return placedFeature;
    }

    private static void registerOres() {
        class_2680 sparklestoneOre = SpectrumBlocks.SPARKLESTONE_ORE.method_9564();
        class_2680 deepslateSparklestoneOre = SpectrumBlocks.DEEPSLATE_SPARKLESTONE_ORE.method_9564();
        class_2680 azuriteOre = SpectrumBlocks.AZURITE_ORE.method_9564();
        class_2680 deepslateAzuriteOre = SpectrumBlocks.DEEPSLATE_AZURITE_ORE.method_9564();
        class_2680 scarletOre = SpectrumBlocks.SCARLET_ORE.method_9564();
        class_2680 paleturOre = SpectrumBlocks.PALETUR_ORE.method_9564();
        class_2960 sparklestoneOreIdentifier = new class_2960("spectrum", "sparklestone_ore");
        class_2960 azuriteOreIdentifier = new class_2960("spectrum", "azurite_ore");
        class_2960 scarletOreIdentifier = new class_2960("spectrum", "scarlet_ore");
        class_2960 paleturOreIdentifier = new class_2960("spectrum", "paletur_ore");
        ImmutableList SPARKLESTONE_ORE_TARGETS = ImmutableList.of((Object)class_3124.method_33994((class_3825)class_6806.field_35858, (class_2680)sparklestoneOre), (Object)class_3124.method_33994((class_3825)class_6806.field_35859, (class_2680)deepslateSparklestoneOre));
        ImmutableList AZURITE_ORE_TARGETS = ImmutableList.of((Object)class_3124.method_33994((class_3825)class_6806.field_35858, (class_2680)azuriteOre), (Object)class_3124.method_33994((class_3825)class_6806.field_35859, (class_2680)deepslateAzuriteOre));
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(sparklestoneOreIdentifier, class_3031.field_13517.method_23397((class_3037)new class_3124((List)SPARKLESTONE_ORE_TARGETS, 8)), List.of(class_6795.method_39634((class_5843)class_5843.method_33846((int)48), (class_5843)class_5843.method_33841((int)128)), class_6793.method_39623((int)9)));
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(azuriteOreIdentifier, class_3031.field_13517.method_23397((class_3037)new class_3124((List)AZURITE_ORE_TARGETS, 5, 0.5f)), List.of(class_6795.method_39637((class_5843)class_5843.method_33840(), (class_5843)class_5843.method_33846((int)32)), class_6793.method_39623((int)6)));
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(scarletOreIdentifier, class_3031.field_13517.method_23397((class_3037)new class_3124(class_6806.field_35861, scarletOre, 6)), List.of(class_6795.method_39634((class_5843)class_5843.method_33846((int)10), (class_5843)class_5843.method_33849((int)64)), class_6793.method_39623((int)8)));
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(paleturOreIdentifier, class_3031.field_13517.method_23397((class_3037)new class_3124(Rules.END_STONE, paleturOre, 4, 0.3f)), List.of(class_6795.method_39634((class_5843)class_5843.method_33840(), (class_5843)class_5843.method_33845()), class_6793.method_39623((int)6)));
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)sparklestoneOreIdentifier));
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)azuriteOreIdentifier));
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)scarletOreIdentifier));
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheEnd(), (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)paleturOreIdentifier));
    }

    private static void registerColoredTree(@NotNull class_1767 dyeColor) {
        String identifierString = dyeColor + "_tree";
        class_5321 configuredFeatureRegistryKey = class_5321.method_29179((class_5321)class_2378.field_25914, (class_2960)new class_2960("spectrum", identifierString));
        class_2975 configuredFeature = class_3031.field_24134.method_23397((class_3037)new class_4643.class_4644((class_4651)class_4651.method_38433((class_2680)SpectrumBlocks.getColoredLogBlock(dyeColor).method_9564()), (class_5141)new class_5140(4, 2, 2), (class_4651)class_4651.method_38433((class_2680)SpectrumBlocks.getColoredLeavesBlock(dyeColor).method_9564()), (class_4647)new class_4646((class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)0), 3), (class_5201)new class_5204(1, 0, 1)).method_27374().method_23445());
        COLORED_TREE_CONFIGURED_FEATURES.put(dyeColor, (class_2975)class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)configuredFeatureRegistryKey.method_29177(), (Object)configuredFeature));
    }

    private static void registerColoredTrees() {
        for (class_1767 dyeColor : class_1767.values()) {
            SpectrumConfiguredFeatures.registerColoredTree(dyeColor);
        }
        ArrayList treeList = new ArrayList();
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7966));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7955));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7942));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7951));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7961));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7958));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7946));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7954));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7945));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7964));
        treeList.add(COLORED_TREE_CONFIGURED_FEATURES.get(class_1767.field_7947));
        ArrayList<Integer> weightList = new ArrayList<Integer>();
        weightList.add(25);
        weightList.add(75);
        weightList.add(25);
        weightList.add(25);
        weightList.add(25);
        weightList.add(75);
        weightList.add(25);
        weightList.add(25);
        weightList.add(25);
        weightList.add(25);
        weightList.add(75);
        List<class_6658> treePlacementModifiers = List.of(class_6819.field_36134, class_6817.field_36081, class_6658.method_39618((class_6646)class_6646.method_39009((class_2680)SpectrumBlocks.RED_SAPLING.method_9564(), (class_2382)class_2338.field_10980)));
        ArrayList<class_6796> placedTreeFeatures = new ArrayList<class_6796>();
        for (class_2975 class_29752 : treeList) {
            placedTreeFeatures.add(class_29752.method_39593(treePlacementModifiers));
        }
        class_2960 randomColoredTreesFeatureIdentifier = new class_2960("spectrum", "random_colored_trees");
        RANDOM_COLORED_TREES_FEATURE = SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(randomColoredTreesFeatureIdentifier, SpectrumFeatures.WEIGHTED_RANDOM_FEATURE_PATCH.method_23397((class_3037)new WeightedRandomFeaturePatchConfig(5, 4, 3, new WeightedRandomFeatureConfig(placedTreeFeatures, weightList))), List.of(class_6799.method_39659((int)SpectrumCommon.CONFIG.ColoredTreePatchChanceChunk), class_5925.method_39638((class_2902.class_2903)class_2902.class_2903.field_13194), class_6792.method_39614()));
        Predicate predicate = BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355, class_1959.class_1961.field_9357, class_1959.class_1961.field_9358, class_1959.class_1961.field_9370, class_1959.class_1961.field_9364, class_1959.class_1961.field_9354, class_1959.class_1961.field_34464, class_1959.class_1961.field_9368, class_1959.class_1961.field_9362, class_1959.class_1961.field_9356, class_1959.class_1961.field_9361});
        BiomeModifications.addFeature((Predicate)predicate, (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)randomColoredTreesFeatureIdentifier));
    }

    private static void registerGeodes() {
        class_2680 AIR = class_2246.field_10124.method_9564();
        class_2680 CALCITE = class_2246.field_27114.method_9564();
        class_2680 SMOOTH_BASALT = class_2246.field_29032.method_9564();
        class_2680 CITRINE_BLOCK = SpectrumBlocks.CITRINE_BLOCK.method_9564();
        class_2680 BUDDING_CITRINE = SpectrumBlocks.BUDDING_CITRINE.method_9564();
        class_2680 SMALL_CITRINE_BUD = SpectrumBlocks.SMALL_CITRINE_BUD.method_9564();
        class_2680 MEDIUM_CITRINE_BUD = SpectrumBlocks.MEDIUM_CITRINE_BUD.method_9564();
        class_2680 LARGE_CITRINE_BUD = SpectrumBlocks.LARGE_CITRINE_BUD.method_9564();
        class_2680 CITRINE_CLUSTER = SpectrumBlocks.CITRINE_CLUSTER.method_9564();
        class_2680 TOPAZ_BLOCK = SpectrumBlocks.TOPAZ_BLOCK.method_9564();
        class_2680 BUDDING_TOPAZ = SpectrumBlocks.BUDDING_TOPAZ.method_9564();
        class_2680 SMALL_TOPAZ_BUD = SpectrumBlocks.SMALL_TOPAZ_BUD.method_9564();
        class_2680 MEDIUM_TOPAZ_BUD = SpectrumBlocks.MEDIUM_TOPAZ_BUD.method_9564();
        class_2680 LARGE_TOPAZ_BUD = SpectrumBlocks.LARGE_TOPAZ_BUD.method_9564();
        class_2680 TOPAZ_CLUSTER = SpectrumBlocks.TOPAZ_CLUSTER.method_9564();
        class_2680 MOONSTONE_BLOCK = SpectrumBlocks.MOONSTONE_BLOCK.method_9564();
        class_2680 BUDDING_MOONSTONE = SpectrumBlocks.BUDDING_MOONSTONE.method_9564();
        class_2680 MOONSTONE_CLUSTER = SpectrumBlocks.MOONSTONE_CLUSTER.method_9564();
        class_2960 citrineGeodeFeatureIdentifier = new class_2960("spectrum", "citrine_geode");
        class_2960 topazGeodeFeatureIdentifier = new class_2960("spectrum", "topaz_geode");
        class_2960 moonstoneGeodeFeatureIdentifier = new class_2960("spectrum", "moonstone_geode");
        CITRINE_GEODE = SpectrumFeatures.AIR_CHECK_GEODE.method_23397((class_3037)new class_5589(new class_5585((class_4651)class_4651.method_38433((class_2680)AIR), (class_4651)class_4651.method_38433((class_2680)CITRINE_BLOCK), (class_4651)class_4651.method_38433((class_2680)BUDDING_CITRINE), (class_4651)class_4651.method_38433((class_2680)CALCITE), (class_4651)class_4651.method_38433((class_2680)SMOOTH_BASALT), (List)ImmutableList.of((Object)SMALL_CITRINE_BUD, (Object)MEDIUM_CITRINE_BUD, (Object)LARGE_CITRINE_BUD, (Object)CITRINE_CLUSTER), class_3481.field_33757.method_26791(), class_3481.field_33863.method_26791()), new class_5587(1.3, 1.7, 2.5, 3.1), new class_5586(0.98, 2.0, 2), 0.35, 0.093, true, (class_6017)class_6019.method_35017((int)4, (int)6), (class_6017)class_6019.method_35017((int)3, (int)4), (class_6017)class_6019.method_35017((int)1, (int)2), -16, 16, 0.05, 0));
        TOPAZ_GEODE = SpectrumFeatures.AIR_CHECK_GEODE.method_23397((class_3037)new class_5589(new class_5585((class_4651)class_4651.method_38433((class_2680)AIR), (class_4651)class_4651.method_38433((class_2680)TOPAZ_BLOCK), (class_4651)class_4651.method_38433((class_2680)BUDDING_TOPAZ), (class_4651)class_4651.method_38433((class_2680)CALCITE), (class_4651)class_4651.method_38433((class_2680)SMOOTH_BASALT), (List)ImmutableList.of((Object)SMALL_TOPAZ_BUD, (Object)MEDIUM_TOPAZ_BUD, (Object)LARGE_TOPAZ_BUD, (Object)TOPAZ_CLUSTER), class_3481.field_33757.method_26791(), class_3481.field_33863.method_26791()), new class_5587(1.9, 2.5, 3.9, 5.0), new class_5586(0.6, 2.0, 2), 0.35, 0.073, true, (class_6017)class_6019.method_35017((int)4, (int)6), (class_6017)class_6019.method_35017((int)3, (int)4), (class_6017)class_6019.method_35017((int)1, (int)2), -16, 16, 0.05, 1));
        MOONSTONE_GEODE = class_3031.field_27312.method_23397((class_3037)new class_5589(new class_5585((class_4651)class_4651.method_38433((class_2680)AIR), (class_4651)class_4651.method_38433((class_2680)MOONSTONE_BLOCK), (class_4651)class_4651.method_38433((class_2680)BUDDING_MOONSTONE), (class_4651)class_4651.method_38433((class_2680)CALCITE), (class_4651)class_4651.method_38433((class_2680)SMOOTH_BASALT), (List)ImmutableList.of((Object)MOONSTONE_CLUSTER), class_3481.field_33757.method_26791(), class_3481.field_33863.method_26791()), new class_5587(4.0, 5.0, 6.0, 7.5), new class_5586(0.95, 4.0, 4), 1.0, 0.1, true, (class_6017)class_6019.method_35017((int)4, (int)6), (class_6017)class_6019.method_35017((int)3, (int)4), (class_6017)class_6019.method_35017((int)1, (int)2), -16, 16, 0.05, 1));
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(citrineGeodeFeatureIdentifier, CITRINE_GEODE, List.of(class_6799.method_39659((int)SpectrumCommon.CONFIG.CitrineGeodeChunkChance), class_5450.method_39639(), class_6795.method_39634((class_5843)class_5843.method_33846((int)SpectrumCommon.CONFIG.CitrineGeodeMinAboveBottomGenerationHeight), (class_5843)class_5843.method_33841((int)SpectrumCommon.CONFIG.CitrineGeodeFixedMaxGenerationHeight)), class_6792.method_39614()));
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(topazGeodeFeatureIdentifier, TOPAZ_GEODE, List.of(class_6799.method_39659((int)SpectrumCommon.CONFIG.TopazGeodeChunkChance), class_5450.method_39639(), class_6795.method_39634((class_5843)class_5843.method_33841((int)SpectrumCommon.CONFIG.TopazGeodeMinFixedGenerationHeight), (class_5843)class_5843.method_33849((int)SpectrumCommon.CONFIG.TopazGeodeMaxBelowTopGenerationHeight)), class_6792.method_39614()));
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(moonstoneGeodeFeatureIdentifier, MOONSTONE_GEODE, List.of(class_6799.method_39659((int)SpectrumCommon.CONFIG.MoonstoneGeodeChunkChance), class_5450.method_39639(), class_6795.method_39634((class_5843)class_5843.method_33846((int)16), (class_5843)class_5843.method_33849((int)128)), class_6792.method_39614()));
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13172, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)citrineGeodeFeatureIdentifier));
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13172, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)topazGeodeFeatureIdentifier));
    }

    private static void registerPlants() {
        class_2960 mermaidsBrushIdentifier = new class_2960("spectrum", "mermaids_brush");
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(mermaidsBrushIdentifier, class_3031.field_13518.method_23397((class_3037)new class_3175((class_4651)new class_5929((class_4651)class_4656.method_38432((class_2248)SpectrumBlocks.MERMAIDS_BRUSH), MermaidsBrushBlock.AGE, (class_6017)class_6019.method_35017((int)5, (int)6)))), List.of(class_6792.method_39614(), class_6799.method_39659((int)16), class_6793.method_39624((class_6017)class_6019.method_35017((int)2, (int)3)), class_5450.method_39639(), class_6817.field_36079, class_6658.method_39618((class_6646)class_6646.method_38882((class_6646[])new class_6646[]{class_6646.method_39009((class_2680)SpectrumBlocks.MERMAIDS_BRUSH.method_9564(), (class_2382)class_2338.field_10980)}))));
        ArrayList<class_5321> oceans = new ArrayList<class_5321>();
        for (String biomeString : SpectrumCommon.CONFIG.MermaidsBrushGenerationBiomes) {
            class_5321 biomeKey = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960(biomeString));
            if (biomeKey == null) {
                SpectrumCommon.log(Level.ERROR, "Mermaids Brush is configured to spawn in biome " + biomeString + ", but that does not exist!");
                continue;
            }
            oceans.add(biomeKey);
        }
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(oceans), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)mermaidsBrushIdentifier));
        class_2960 quitoxicReedsIdentifier = new class_2960("spectrum", "quitoxic_reeds");
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(quitoxicReedsIdentifier, class_3031.field_35072.method_23397((class_3037)class_6655.method_38910((class_6017)class_6333.method_36249((int)2, (int)4), (class_4651)class_4651.method_38432((class_2248)SpectrumBlocks.QUITOXIC_REEDS))), List.of(class_6792.method_39614(), class_6793.method_39623((int)25), class_5450.method_39639(), class_6817.field_36079, class_6658.method_39618((class_6646)class_6646.method_38882((class_6646[])new class_6646[]{class_6646.method_39009((class_2680)SpectrumBlocks.QUITOXIC_REEDS.method_9564(), (class_2382)class_2338.field_10980)}))));
        ArrayList<class_5321> swamps = new ArrayList<class_5321>();
        for (String biomeString : SpectrumCommon.CONFIG.QuitoxicReedsGenerationBiomes) {
            class_5321 biomeKey = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960(biomeString));
            if (biomeKey == null) {
                SpectrumCommon.log(Level.ERROR, "Quitoxic Reeds are configured to spawn in biome " + biomeString + " but that does not exist!");
                continue;
            }
            swamps.add(biomeKey);
        }
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(swamps), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)quitoxicReedsIdentifier));
        class_2960 cloversIdentifier = new class_2960("spectrum", "clovers");
        class_6005 cloverBlockDataPool = class_6005.method_34971().method_34975((Object)SpectrumBlocks.CLOVER.method_9564(), 9).method_34975((Object)SpectrumBlocks.FOUR_LEAF_CLOVER.method_9564(), 1).method_34974();
        SpectrumConfiguredFeatures.registerConfiguredAndPlacedFeature(cloversIdentifier, class_3031.field_21220.method_23397((class_3037)class_6803.method_39706((class_2975)class_3031.field_13518.method_23397((class_3037)new class_3175((class_4651)new class_4657(cloverBlockDataPool))), List.of(class_2246.field_10219), (int)4)), List.of(class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614()));
        BiomeModifications.addFeature((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)cloversIdentifier));
    }

    static {
        COLORED_TREE_CONFIGURED_FEATURES = new HashMap();
    }

    public static final class Rules {
        public static final class_3825 END_STONE = new class_3819(class_2246.field_10471);
    }
}

