/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.sound;

import de.dafuqs.spectrum.SpectrumClient;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlock;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1102;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class BlockBoundSoundInstance
extends class_1102
implements class_1117 {
    private static List<BlockBoundSoundInstance> playingSoundInstances = new ArrayList<BlockBoundSoundInstance>();
    class_5321<class_1937> worldKey;
    class_2338 sourceBlockPos;
    class_2248 sourceBlock;
    int maxDurationTicks;
    private int ticksPlayed = 0;
    private float distance = 0.0f;
    private boolean done;

    protected BlockBoundSoundInstance(class_3414 soundEvent, class_5321<class_1937> worldKey, class_2338 sourceBlockPos, class_2248 sourceBlock, int maxDurationTicks) {
        super(soundEvent, class_3419.field_15245);
        this.worldKey = worldKey;
        this.sourceBlockPos = sourceBlockPos;
        this.sourceBlock = sourceBlock;
        this.maxDurationTicks = maxDurationTicks;
        this.field_5446 = true;
        this.field_5451 = 0;
        this.field_5442 = 1.0f;
    }

    public boolean method_4793() {
        return this.done;
    }

    public boolean method_4785() {
        return true;
    }

    public void method_16896() {
        ++this.ticksPlayed;
        this.distance = class_3532.method_15363((float)(this.distance + 0.0025f), (float)0.0f, (float)1.0f);
        this.field_5442 = Math.max(0.0f, 0.5f - (float)this.sourceBlockPos.method_19455((class_2382)class_310.method_1551().field_1724.method_24515()) / 128.0f);
        if (this.ticksPlayed == this.maxDurationTicks) {
            this.field_5442 /= 2.0f;
        }
        if (this.ticksPlayed > this.maxDurationTicks || !Objects.equals(this.worldKey, class_310.method_1551().field_1687.method_27983()) || this.shouldStopPlaying()) {
            this.setDone();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void startSoundInstance(class_3414 soundEvent, class_2338 sourceBlockPos, class_2248 sourceBlock, int maxDurationTicks) {
        BlockBoundSoundInstance.stopPlayingOnPos(sourceBlockPos);
        BlockBoundSoundInstance newInstance = new BlockBoundSoundInstance(soundEvent, (class_5321<class_1937>)class_310.method_1551().field_1687.method_27983(), sourceBlockPos, sourceBlock, maxDurationTicks);
        playingSoundInstances.add(newInstance);
        SpectrumClient.minecraftClient.method_1483().method_4873((class_1113)newInstance);
    }

    private boolean shouldStopPlaying() {
        class_2680 blockState = class_310.method_1551().field_1687.method_8320(this.sourceBlockPos);
        if (!blockState.method_26204().equals(this.sourceBlock)) {
            return true;
        }
        if (blockState.method_26204() instanceof PedestalBlock) {
            return false;
        }
        if (blockState.method_26204() instanceof FusionShrineBlock) {
            class_2586 blockEntity = class_310.method_1551().field_1687.method_8321(this.sourceBlockPos);
            return !(blockEntity instanceof FusionShrineBlockEntity);
        }
        return false;
    }

    protected final void setDone() {
        this.ticksPlayed = this.maxDurationTicks;
        this.done = true;
        this.field_5446 = false;
    }

    public static void stopPlayingOnPos(class_2338 blockPos) {
        ArrayList<BlockBoundSoundInstance> newInstances = new ArrayList<BlockBoundSoundInstance>();
        for (BlockBoundSoundInstance soundInstance : playingSoundInstances) {
            if (soundInstance.sourceBlockPos.equals((Object)blockPos)) {
                soundInstance.setDone();
                continue;
            }
            newInstances.add(soundInstance);
        }
        playingSoundInstances = newInstances;
    }
}

