/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries.color;

import de.dafuqs.spectrum.registries.color.FluidColorRegistry;
import de.dafuqs.spectrum.registries.color.ItemColorRegistry;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.class_1160;
import net.minecraft.class_1767;
import net.minecraft.class_2960;

public abstract class ColorRegistry<T> {
    public static ItemColorRegistry ITEM_COLORS;
    public static FluidColorRegistry FLUID_COLORS;

    public static void registerColorRegistries() {
        ITEM_COLORS = new ItemColorRegistry();
        FLUID_COLORS = new FluidColorRegistry();
    }

    public abstract void registerColorMapping(class_2960 var1, class_1767 var2);

    public abstract void registerColorMapping(T var1, class_1767 var2);

    public abstract Optional<class_1767> getMapping(T var1);

    public static class_1160 getColor(class_1767 dyeColor) {
        return switch (dyeColor) {
            case class_1767.field_7963 -> new class_1160(0.1f, 0.1f, 0.1f);
            case class_1767.field_7966 -> new class_1160(0.05f, 0.011f, 0.95f);
            case class_1767.field_7957 -> new class_1160(0.31f, 0.16f, 0.05f);
            case class_1767.field_7955 -> new class_1160(0.0f, 1.0f, 1.0f);
            case class_1767.field_7944 -> new class_1160(0.3f, 0.3f, 0.3f);
            case class_1767.field_7942 -> new class_1160(0.14f, 0.24f, 0.0f);
            case class_1767.field_7951 -> new class_1160(0.0f, 0.75f, 0.95f);
            case class_1767.field_7967 -> new class_1160(0.68f, 0.68f, 0.68f);
            case class_1767.field_7961 -> new class_1160(0.0f, 0.86f, 0.0f);
            case class_1767.field_7958 -> new class_1160(1.0f, 0.0f, 1.0f);
            case class_1767.field_7946 -> new class_1160(0.93f, 0.39f, 0.0f);
            case class_1767.field_7954 -> new class_1160(1.0f, 0.78f, 0.87f);
            case class_1767.field_7945 -> new class_1160(0.43f, 0.0f, 0.68f);
            case class_1767.field_7964 -> new class_1160(0.95f, 0.0f, 0.0f);
            case class_1767.field_7952 -> new class_1160(0.97f, 0.97f, 0.97f);
            default -> new class_1160(0.93f, 0.93f, 0.0f);
        };
    }

    public static Color colorFromRGB(int r, int g, int b) {
        return ColorRegistry.colorFromRGBA(r, g, b, 255.0f);
    }

    public static Color colorFromRGB(float r, float g, float b) {
        return ColorRegistry.colorFromRGBA(r, g, b, 1.0f);
    }

    public static Color colorFromRGBA(float r, float g, float b, float a) {
        return new Color((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5), (int)((double)(a * 255.0f) + 0.5));
    }
}

