/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.multiblock.StateMatcher;

public class SpectrumMultiblocks {
    public static final Map<class_2960, IMultiblock> MULTIBLOCKS = new ConcurrentHashMap<class_2960, IMultiblock>();
    public static class_2960 PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK;
    public static class_2960 PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_PLACE;
    public static class_2960 PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK;
    public static class_2960 PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_PLACE;
    public static class_2960 PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK;
    public static class_2960 PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_PLACE;
    public static class_2960 FUSION_SHRINE_IDENTIFIER;
    public static class_2960 ENCHANTER_IDENTIFIER;

    private static class_2960 registerMultiBlock(String identifierString, String[][] structure, Object[] targetBlocks) {
        class_2960 identifier = new class_2960("spectrum", identifierString);
        IMultiblock multiblock = PatchouliAPI.get().makeMultiblock(structure, targetBlocks);
        MULTIBLOCKS.put(identifier, PatchouliAPI.get().registerMultiblock(identifier, multiblock));
        return identifier;
    }

    public static void register() {
        SpectrumMultiblocks.registerPedestal();
        SpectrumMultiblocks.registerFusionShrine();
        SpectrumMultiblocks.registerEnchanter();
    }

    private static void registerFusionShrine() {
        Object[] targetBlocks = new Object[]{Character.valueOf('X'), "#spectrum:polished_base_blocks", Character.valueOf('P'), "#spectrum:pillar_base_blocks", Character.valueOf('L'), "#spectrum:polished_base_block_slabs", Character.valueOf('S'), "#spectrum:gemstone_storage_blocks", Character.valueOf('C'), "#spectrum:chiseled_base_blocks", Character.valueOf('F'), "#spectrum:fusion_shrines", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), "#spectrum:polished_base_blocks"};
        String[][] structure = new String[][]{{"_________", "_L_____L_", "_________", "_________", "_________", "_________", "_________", "_L_ ___L_", "_________"}, {"_________", "_S_____S_", "_________", "_________", "_________", "_________", "_________", "_S_____S_", "_________"}, {"_________", "_P_____P_", "_________", "_________", "_________", "_________", "_________", "_P_____P_", "_________"}, {"__XXXXX__", "_P_____P_", "X_______X", "X_______X", "X___F___X", "X_______X", "X_______X", "_P_____P_", "__XXXXX__"}, {"__XXXXX__", "_XXXXXXX_", "XXCXXXCXX", "XXXLLLXXX", "XXXL0LXXX", "XXXLLLXXX", "XXCXXXCXX", "_XXXXXXX_", "__XXXXX__"}};
        FUSION_SHRINE_IDENTIFIER = SpectrumMultiblocks.registerMultiBlock("fusion_shrine_structure", structure, targetBlocks);
    }

    private static void registerEnchanter() {
        Object[] targetBlocks = new Object[]{Character.valueOf('X'), "#spectrum:polished_base_blocks", Character.valueOf('P'), "#spectrum:pillar_base_blocks", Character.valueOf('B'), "#spectrum:polished_base_block_slabs", Character.valueOf('L'), "#spectrum:gemstone_lamps", Character.valueOf('G'), "#spectrum:gemstone_storage_blocks", Character.valueOf('F'), "spectrum:enchanter", Character.valueOf('C'), "spectrum:liquid_crystal", Character.valueOf('I'), "#spectrum:item_bowls", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), "#spectrum:polished_base_blocks"};
        String[][] structure = new String[][]{{"__I_____I__", "___________", "I_________I", "___________", "___________", "_____F_____", "___________", "___________", "I_________I", "___________", "__I_____I__"}, {"__L_____L__", "___________", "L_G_____G_L", "____BBB____", "___BXXXB___", "___BXXXB___", "___BXXXB___", "____BBB____", "L_G_____G_L", "___________", "__L_____L__"}, {"__P_____P__", "____BBB____", "P_P_XXX_P_P", "____XXX____", "_BXXXXXXXB_", "_BXXXXXXXB_", "_BXXXXXXXB_", "____XXX____", "P_P_XXX_P_P", "____BBB____", "__P_____P__"}, {"_XXXXXXXXX_", "XCCCXXXCCCX", "XCXCXXXCXCX", "XCCCXXXCCCX", "XXXXXXXXXXX", "XXXXX0XXXXX", "XXXXXXXXXXX", "XCCCXXXCCCX", "XCXCXXXCXCX", "XCCCXXXCCCX", "_XXXXXXXXX_"}, {"___________", "_XXX___XXX_", "_X_X___X_X_", "_XXX___XXX_", "___________", "___________", "___________", "_XXX___XXX_", "_X_X___X_X_", "_XXX___XXX_", "___________"}};
        ENCHANTER_IDENTIFIER = SpectrumMultiblocks.registerMultiBlock("enchanter_structure", structure, targetBlocks);
    }

    private static void registerPedestal() {
        Object[] targetBlocksCheck = new Object[]{Character.valueOf('X'), "#spectrum:polished_base_blocks", Character.valueOf('T'), "#spectrum:crest_base_blocks", Character.valueOf('t'), "#spectrum:crest_base_blocks", Character.valueOf('Q'), "#spectrum:pillar_base_blocks", Character.valueOf('L'), "#spectrum:gemstone_lamps", Character.valueOf('S'), "#spectrum:gemstone_storage_blocks", Character.valueOf('C'), "#spectrum:chiseled_base_blocks", Character.valueOf('K'), "#spectrum:notched_base_blocks", Character.valueOf('R'), "#spectrum:basic_gemstone_chiseled_base_blocks", Character.valueOf('O'), "#spectrum:onyx_chiseled_base_blocks", Character.valueOf('m'), "#spectrum:moonstone_chiseled_base_blocks", Character.valueOf('M'), "#spectrum:moonstone_chiseled_base_blocks", Character.valueOf('2'), "#spectrum:pedestals", Character.valueOf('3'), "#spectrum:pedestals", Character.valueOf('4'), "#spectrum:pedestals", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), StateMatcher.ANY};
        Object[] targetBlocksPlace = new Object[]{Character.valueOf('X'), "spectrum:polished_basalt", Character.valueOf('T'), "spectrum:polished_basalt_crest[cardinal_facing=true]", Character.valueOf('t'), "spectrum:polished_basalt_crest[cardinal_facing=false]", Character.valueOf('Q'), "spectrum:polished_basalt_pillar[axis=y]", Character.valueOf('L'), "spectrum:amethyst_basalt_lamp", Character.valueOf('S'), "spectrum:amethyst_storage_block", Character.valueOf('C'), "spectrum:chiseled_polished_basalt", Character.valueOf('K'), "spectrum:notched_polished_basalt", Character.valueOf('R'), "spectrum:amethyst_chiseled_basalt", Character.valueOf('O'), "spectrum:onyx_chiseled_basalt", Character.valueOf('m'), "spectrum:moonstone_chiseled_basalt[axis=x]", Character.valueOf('M'), "spectrum:moonstone_chiseled_basalt[axis=y]", Character.valueOf('2'), "spectrum:pedestal_all_basic", Character.valueOf('3'), "spectrum:pedestal_onyx", Character.valueOf('4'), "spectrum:pedestal_moonstone", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), StateMatcher.ANY};
        String[][] tier1Structure = new String[][]{{"C_________C", "___________", "___________", "___________", "___________", "___________", "___________", "___________", "___________", "___________", "C_________C"}, {"Q_________Q", "___________", "__S_____S__", "___________", "___________", "___________", "___________", "___________", "__S_____S__", "___________", "Q_________Q"}, {"K_________K", "___________", "__Q_____Q__", "___________", "___________", "_____2_____", "___________", "___________", "__Q_____Q__", "___________", "K_________K"}, {"___________", "___XXXXX___", "__XXXXXXX__", "_XXXXXXXXX_", "_XXXXXXXXX_", "_XXXX0XXXX_", "_XXXXXXXXX_", "_XXXXXXXXX_", "__XXXXXXX__", "___XXXXX___", "___________"}};
        PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK = SpectrumMultiblocks.registerMultiBlock("pedestal_simple_structure_check", tier1Structure, targetBlocksCheck);
        PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_PLACE = SpectrumMultiblocks.registerMultiBlock("pedestal_simple_structure_place", tier1Structure, targetBlocksPlace);
        String[][] tier2Structure = new String[][]{{"_____________", "_SttR___RttS_", "_T_________T_", "_T_________T_", "_R_________R_", "_____________", "_____________", "_____________", "_R_________R_", "_T_________T_", "_T_________T_", "_SttR___RttS_", "_____________"}, {"_____________", "_Q__Q___Q__Q_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_Q__Q___Q__Q_", "_____________"}, {"_____________", "_C__Q___Q__C_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_C__Q___Q__C_", "_____________"}, {"_____________", "_Q__L___L__Q_", "_____________", "___S_____S___", "_L_________L_", "_____________", "_____________", "_____________", "_L_________L_", "___S_____S___", "_____________", "_Q__L___L__Q_", "_____________"}, {"_____________", "_K__Q___Q__K_", "_____________", "___Q_____Q___", "_Q_________Q_", "_____________", "______3______", "_____________", "_Q_________Q_", "___Q_____Q___", "_____________", "_K__Q___Q__K_", "_____________"}, {"XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXRXRXXXXX", "XXXXRXXXRXXXX", "XXXXXX0XXXXXX", "XXXXRXXXRXXXX", "XXXXXRXRXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX"}};
        PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK = SpectrumMultiblocks.registerMultiBlock("pedestal_advanced_structure_check", tier2Structure, targetBlocksCheck);
        PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_PLACE = SpectrumMultiblocks.registerMultiBlock("pedestal_advanced_structure_place", tier2Structure, targetBlocksPlace);
        String[][] tier3Structure = new String[][]{{"_____________", "____XtStX____", "_____________", "_____________", "_X__OtttO__X_", "_T__T___T__T_", "_S__T___T__S_", "_T__T___T__T_", "_X__OtttO__X_", "_____________", "_____________", "____XtStX____", "_____________"}, {"_____________", "_SttR___RttS_", "_T__T___T__T_", "_T__T___T__T_", "_RttX___XttR_", "_____________", "_____________", "_____________", "_RttX___XttR_", "_T__T___T__T_", "_T__T___T__T_", "_SttR___RttS_", "_____________"}, {"_____________", "_Q__Q___Q__Q_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_Q__Q___Q__Q_", "_____________"}, {"_____________", "_C__Q___Q__C_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_C__Q___Q__C_", "_____________"}, {"_____________", "_Q__L___L__Q_", "_____________", "___S_____S___", "_L_________L_", "_____________", "_____________", "_____________", "_L_________L_", "___S_____S___", "_____________", "_Q__L___L__Q_", "_____________"}, {"_____________", "_K__Q___Q__K_", "_____________", "___Q_____Q___", "_Q_________Q_", "_____________", "______4______", "_____________", "_Q_________Q_", "___Q_____Q___", "_____________", "_K__Q___Q__K_", "_____________"}, {"XXXXXXXXXXXXX", "XXmmXmmmXmmXX", "XMXXXXXXXXXMX", "XMXXXXXXXXXMX", "XXXXXRXRXXXXX", "XMXXRXXXRXXMX", "XMXXXX0XXXXMX", "XMXXRXXXRXXMX", "XXXXXRXRXXXXX", "XMXXXXXXXXXMX", "XMXXXXXXXXXMX", "XXmmXmmmXmmXX", "XXXXXXXXXXXXX"}};
        PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK = SpectrumMultiblocks.registerMultiBlock("pedestal_complex_structure_check", tier3Structure, targetBlocksCheck);
        PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_PLACE = SpectrumMultiblocks.registerMultiBlock("pedestal_complex_structure_place", tier3Structure, targetBlocksPlace);
    }

    @Contract(pure=true)
    @Nullable
    public static class_2960 getDisplayStructureIdentifierForTier(@NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case COMPLEX: {
                return PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK;
            }
            case ADVANCED: {
                return PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK;
            }
            case SIMPLE: {
                return PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK;
            }
        }
        return null;
    }

    @Nullable
    public static class_2588 getPedestalStructureText(@NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case COMPLEX: {
                return new class_2588("multiblock.spectrum.pedestal.complex_structure");
            }
            case ADVANCED: {
                return new class_2588("multiblock.spectrum.pedestal.advanced_structure");
            }
            case SIMPLE: {
                return new class_2588("multiblock.spectrum.pedestal.simple_structure");
            }
        }
        return null;
    }
}

