/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.enums.GemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.mixin.AccessorShapedRecipe;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Level;

public class PedestalCraftingRecipeSerializer<T extends PedestalCraftingRecipe>
implements class_1865<T> {
    public final RecipeFactory<T> recipeFactory;

    public PedestalCraftingRecipeSerializer(RecipeFactory<T> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public T read(class_2960 identifier, JsonObject jsonObject) {
        int amount;
        String group = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
        Map<String, class_1856> map = AccessorShapedRecipe.invokeReadSymbols(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
        String[] strings = AccessorShapedRecipe.invokeRemovePadding(AccessorShapedRecipe.invokeGetPattern(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern")));
        int width = strings[0].length();
        int height = strings.length;
        class_2371<class_1856> craftingInputs = AccessorShapedRecipe.invokeCreatePatternMatrix(strings, map, width, height);
        class_1799 output = RecipeUtils.outputWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        PedestalRecipeTier tier = PedestalRecipeTier.valueOf(class_3518.method_15253((JsonObject)jsonObject, (String)"tier", (String)"basic").toUpperCase(Locale.ROOT));
        float experience = class_3518.method_15277((JsonObject)jsonObject, (String)"experience", (float)0.0f);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        boolean noBenefitsFromYieldUpgrades = false;
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"disable_yield_upgrades")) {
            noBenefitsFromYieldUpgrades = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_upgrades", (boolean)false);
        }
        HashMap<GemstoneColor, Integer> gemInputs = new HashMap<GemstoneColor, Integer>();
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"cyan")) {
            amount = class_3518.method_15282((JsonObject)jsonObject, (String)"cyan", (int)0);
            gemInputs.put(GemstoneColor.CYAN, amount);
        }
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"magenta")) {
            amount = class_3518.method_15282((JsonObject)jsonObject, (String)"magenta", (int)0);
            gemInputs.put(GemstoneColor.MAGENTA, amount);
        }
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"yellow")) {
            amount = class_3518.method_15282((JsonObject)jsonObject, (String)"yellow", (int)0);
            gemInputs.put(GemstoneColor.YELLOW, amount);
        }
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"white")) {
            amount = class_3518.method_15282((JsonObject)jsonObject, (String)"white", (int)0);
            gemInputs.put(GemstoneColor.WHITE, amount);
        }
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"black")) {
            amount = class_3518.method_15282((JsonObject)jsonObject, (String)"black", (int)0);
            gemInputs.put(GemstoneColor.BLACK, amount);
        }
        ArrayList<class_2960> requiredAdvancementIdentifiers = new ArrayList<class_2960>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"required_advancements")) {
            JsonArray requiredAdvancementsArray = class_3518.method_15261((JsonObject)jsonObject, (String)"required_advancements");
            for (int i = 0; i < requiredAdvancementsArray.size(); ++i) {
                class_2960 requiredAdvancementIdentifier = class_2960.method_12829((String)requiredAdvancementsArray.get(i).getAsString());
                requiredAdvancementIdentifiers.add(requiredAdvancementIdentifier);
            }
        } else {
            SpectrumCommon.log(Level.WARN, "Pedestal Recipe " + identifier.method_12832() + " does not specify advancements to unlock.");
        }
        return this.recipeFactory.create(identifier, group, tier, width, height, craftingInputs, gemInputs, output, experience, craftingTime, noBenefitsFromYieldUpgrades, requiredAdvancementIdentifiers);
    }

    public void write(class_2540 packetByteBuf, T pedestalRecipe) {
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).width);
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).height);
        packetByteBuf.method_10814(((PedestalCraftingRecipe)pedestalRecipe).group);
        for (class_1856 ingredient : ((PedestalCraftingRecipe)pedestalRecipe).craftingInputs) {
            ingredient.method_8088(packetByteBuf);
        }
        packetByteBuf.method_10793(((PedestalCraftingRecipe)pedestalRecipe).output);
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).tier.ordinal());
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).getGemstonePowderAmount(GemstoneColor.MAGENTA));
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).getGemstonePowderAmount(GemstoneColor.CYAN));
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).getGemstonePowderAmount(GemstoneColor.YELLOW));
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).getGemstonePowderAmount(GemstoneColor.BLACK));
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).getGemstonePowderAmount(GemstoneColor.WHITE));
        packetByteBuf.writeFloat(((PedestalCraftingRecipe)pedestalRecipe).experience);
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).craftingTime);
        packetByteBuf.writeBoolean(((PedestalCraftingRecipe)pedestalRecipe).noBenefitsFromYieldUpgrades);
        packetByteBuf.writeInt(((PedestalCraftingRecipe)pedestalRecipe).requiredAdvancementIdentifiers.size());
        for (int i = 0; i < ((PedestalCraftingRecipe)pedestalRecipe).requiredAdvancementIdentifiers.size(); ++i) {
            packetByteBuf.method_10812(((PedestalCraftingRecipe)pedestalRecipe).requiredAdvancementIdentifiers.get(i));
        }
    }

    public T read(class_2960 identifier, class_2540 packetByteBuf) {
        int width = packetByteBuf.readInt();
        int height = packetByteBuf.readInt();
        String group = packetByteBuf.method_19772();
        class_2371 craftingInputs = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        for (int k = 0; k < craftingInputs.size(); ++k) {
            craftingInputs.set(k, (Object)class_1856.method_8086((class_2540)packetByteBuf));
        }
        class_1799 output = packetByteBuf.method_10819();
        PedestalRecipeTier tier = PedestalRecipeTier.values()[packetByteBuf.readInt()];
        int magenta = packetByteBuf.readInt();
        int cyan = packetByteBuf.readInt();
        int yellow = packetByteBuf.readInt();
        int black = packetByteBuf.readInt();
        int white = packetByteBuf.readInt();
        float experience = packetByteBuf.readFloat();
        int craftingTime = packetByteBuf.readInt();
        boolean noBenefitsFromYieldUpgrades = packetByteBuf.readBoolean();
        int requiredAdvancementAmount = packetByteBuf.readInt();
        ArrayList<class_2960> requiredAdvancementIdentifiers = new ArrayList<class_2960>();
        for (int i = 0; i < requiredAdvancementAmount; ++i) {
            requiredAdvancementIdentifiers.add(packetByteBuf.method_10810());
        }
        HashMap<GemstoneColor, Integer> gemInputs = new HashMap<GemstoneColor, Integer>();
        if (magenta > 0) {
            gemInputs.put(GemstoneColor.MAGENTA, magenta);
        }
        if (cyan > 0) {
            gemInputs.put(GemstoneColor.CYAN, cyan);
        }
        if (yellow > 0) {
            gemInputs.put(GemstoneColor.YELLOW, yellow);
        }
        if (black > 0) {
            gemInputs.put(GemstoneColor.BLACK, black);
        }
        if (white > 0) {
            gemInputs.put(GemstoneColor.WHITE, white);
        }
        return this.recipeFactory.create(identifier, group, tier, width, height, (class_2371<class_1856>)craftingInputs, gemInputs, output, experience, craftingTime, noBenefitsFromYieldUpgrades, requiredAdvancementIdentifiers);
    }

    public static interface RecipeFactory<T extends PedestalCraftingRecipe> {
        public T create(class_2960 var1, String var2, PedestalRecipeTier var3, int var4, int var5, class_2371<class_1856> var6, HashMap<GemstoneColor, Integer> var7, class_1799 var8, float var9, int var10, boolean var11, List<class_2960> var12);
    }
}

