/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import de.dafuqs.spectrum.SpectrumClient;
import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlock;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockItem;
import de.dafuqs.spectrum.enums.GemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.progression.ClientRecipeToastManager;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3956;

public class PedestalCraftingRecipe
implements class_1860<class_1263> {
    protected final class_2960 id;
    protected final String group;
    protected final int width;
    protected final int height;
    protected final PedestalRecipeTier tier;
    protected final class_2371<class_1856> craftingInputs;
    protected final HashMap<GemstoneColor, Integer> gemstoneDustInputs;
    protected final class_1799 output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean noBenefitsFromYieldUpgrades;
    protected final List<class_2960> requiredAdvancementIdentifiers;

    public PedestalCraftingRecipe(class_2960 id, String group, PedestalRecipeTier tier, int width, int height, class_2371<class_1856> craftingInputs, HashMap<GemstoneColor, Integer> gemstoneDustInputs, class_1799 output, float experience, int craftingTime, boolean noBenefitsFromYieldUpgrades, List<class_2960> requiredAdvancementIdentifiers) {
        this.id = id;
        this.group = group;
        this.tier = tier;
        this.width = width;
        this.height = height;
        this.craftingInputs = craftingInputs;
        this.gemstoneDustInputs = gemstoneDustInputs;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.noBenefitsFromYieldUpgrades = noBenefitsFromYieldUpgrades;
        this.requiredAdvancementIdentifiers = requiredAdvancementIdentifiers;
        if (SpectrumClient.minecraftClient != null) {
            this.registerInClientToastManager();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void registerInClientToastManager() {
        ClientRecipeToastManager.registerUnlockablePedestalRecipe(this);
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        if (!this.matchesGrid(inv)) {
            return false;
        }
        int topazPowderAmount = this.gemstoneDustInputs.get((Object)GemstoneColor.CYAN);
        int amethystPowderAmount = this.gemstoneDustInputs.get((Object)GemstoneColor.MAGENTA);
        int citrinePowderAmount = this.gemstoneDustInputs.get((Object)GemstoneColor.YELLOW);
        int onyxPowderAmount = this.gemstoneDustInputs.get((Object)GemstoneColor.BLACK);
        int moonstonePowderAmount = this.gemstoneDustInputs.get((Object)GemstoneColor.WHITE);
        return !(topazPowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(9), SpectrumItems.TOPAZ_POWDER, topazPowderAmount) || amethystPowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(10), SpectrumItems.AMETHYST_POWDER, amethystPowderAmount) || citrinePowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(11), SpectrumItems.CITRINE_POWDER, citrinePowderAmount) || onyxPowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(12), SpectrumItems.ONYX_POWDER, onyxPowderAmount) || moonstonePowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(13), SpectrumItems.MOONSTONE_POWDER, moonstonePowderAmount));
    }

    public boolean matchesGrid(class_1263 inv) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.matchesPattern(inv, i, j, true)) {
                    return true;
                }
                if (!this.matchesPattern(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesPattern(class_1263 inv, int offsetX, int offsetY, boolean flipped) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                class_1856 ingredient = class_1856.field_9017;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = flipped ? (class_1856)this.craftingInputs.get(this.width - k - 1 + l * this.width) : (class_1856)this.craftingInputs.get(k + l * this.width);
                }
                if (ingredient.method_8093(inv.method_5438(i + j * 3))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof PedestalCraftingRecipe) {
            return ((PedestalCraftingRecipe)object).method_8114().equals((Object)this.method_8114());
        }
        return false;
    }

    private boolean isStackAtLeast(class_1799 sourceItemStack, class_1792 item, int amount) {
        return sourceItemStack.method_7909().equals(item) && sourceItemStack.method_7947() >= amount;
    }

    public class_2371<class_1856> method_8117() {
        return this.craftingInputs;
    }

    public class_1799 method_8116(class_1263 inv) {
        return this.output.method_7972();
    }

    public class_2371<class_1856> getPreviewInputs() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.addAll(this.craftingInputs);
        return defaultedList;
    }

    public PedestalRecipeTier getTier() {
        return this.tier;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.PEDESTAL_BASIC_AMETHYST);
    }

    public boolean method_8118() {
        return true;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.PEDESTAL_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.PEDESTAL;
    }

    public int getGemstonePowderAmount(GemstoneColor gemstoneColor) {
        return this.gemstoneDustInputs.getOrDefault((Object)gemstoneColor, 0);
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public HashMap<GemstoneColor, Integer> getGemstonePowderInputs() {
        return this.gemstoneDustInputs;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public class_3414 getSoundEvent(Random random) {
        int i;
        ArrayList<class_3414> choices = new ArrayList<class_3414>();
        for (i = 0; i < this.gemstoneDustInputs.get((Object)GemstoneColor.MAGENTA); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_AMETHYST);
        }
        for (i = 0; i < this.gemstoneDustInputs.get((Object)GemstoneColor.YELLOW); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_CITRINE);
        }
        for (i = 0; i < this.gemstoneDustInputs.get((Object)GemstoneColor.CYAN); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_TOPAZ);
        }
        for (i = 0; i < this.gemstoneDustInputs.get((Object)GemstoneColor.BLACK); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_ONYX);
        }
        for (i = 0; i < this.gemstoneDustInputs.get((Object)GemstoneColor.WHITE); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_MOONSTONE);
        }
        if (choices.size() == 0) {
            return SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_GENERIC;
        }
        return (class_3414)choices.get(random.nextInt(choices.size()));
    }

    public boolean canCraft(PedestalBlockEntity pedestalBlockEntity) {
        class_1657 playerEntity = pedestalBlockEntity.getPlayerEntityIfOnline(pedestalBlockEntity.method_10997());
        if (playerEntity == null) {
            return false;
        }
        return this.canPlayerCraft(playerEntity) && pedestalBlockEntity.getHighestAvailableRecipeTierWithStructure().ordinal() >= this.tier.ordinal();
    }

    public boolean canPlayerCraft(class_1657 playerEntity) {
        return PedestalRecipeTier.hasUnlockedRequiredTier(playerEntity, this.tier) && this.hasUnlockedRequiredAdvancements(playerEntity);
    }

    public boolean hasUnlockedRequiredAdvancements(class_1657 playerEntity) {
        for (class_2960 advancementIdentifier : this.requiredAdvancementIdentifiers) {
            if (Support.hasAdvancement(playerEntity, advancementIdentifier)) continue;
            return false;
        }
        return true;
    }

    public static PedestalBlock.PedestalVariant getUpgradedPedestalVariantForOutput(class_1799 outputItemStack) {
        if (outputItemStack.method_7909() instanceof PedestalBlockItem) {
            return ((PedestalBlockItem)outputItemStack.method_7909()).getVariant();
        }
        return null;
    }

    public List<class_2960> getRequiredAdvancementIdentifiers() {
        return this.requiredAdvancementIdentifiers;
    }

    public String method_8112() {
        return this.group;
    }

    public boolean areYieldUpgradesDisabled() {
        return this.noBenefitsFromYieldUpgrades;
    }
}

