/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.fusion_shrine;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldCondition;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.apache.logging.log4j.Level;

public class FusionShrineRecipeSerializer<T extends FusionShrineRecipe>
implements class_1865<T> {
    public final RecipeFactory<T> recipeFactory;

    public FusionShrineRecipeSerializer(RecipeFactory<T> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public T read(class_2960 identifier, JsonObject jsonObject) {
        class_2960 requiredAdvancementIdentifier;
        String group = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
        JsonArray ingredientArray = class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients");
        class_2371 craftingInputs = class_2371.method_37434((int)ingredientArray.size());
        for (int i = 0; i < ingredientArray.size(); ++i) {
            craftingInputs.add((Object)class_1856.method_8102((JsonElement)ingredientArray.get(i)));
        }
        class_3611 fluid = class_3612.field_15906;
        if (class_3518.method_15289((JsonObject)jsonObject, (String)"fluid")) {
            class_2960 fluidIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"fluid"));
            fluid = (class_3611)class_2378.field_11154.method_10223(fluidIdentifier);
        }
        class_1799 output = class_3518.method_34923((JsonObject)jsonObject, (String)"result") ? RecipeUtils.outputWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result")) : class_1799.field_8037;
        float experience = class_3518.method_15277((JsonObject)jsonObject, (String)"experience", (float)0.0f);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        boolean noBenefitsFromYieldUpgrades = false;
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"disable_yield_upgrades")) {
            noBenefitsFromYieldUpgrades = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_upgrades", (boolean)false);
        }
        if (class_3518.method_15289((JsonObject)jsonObject, (String)"required_advancement")) {
            requiredAdvancementIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"required_advancement"));
        } else {
            SpectrumCommon.log(Level.WARN, "Fusion Shrine Recipe " + identifier + " has no unlock advancement set. Will be set to impossible");
            requiredAdvancementIdentifier = new class_2960("spectrum", "impossible");
        }
        ArrayList<FusionShrineRecipeWorldCondition> worldConditions = new ArrayList<FusionShrineRecipeWorldCondition>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"world_conditions")) {
            JsonArray conditionsArray = class_3518.method_15261((JsonObject)jsonObject, (String)"world_conditions");
            for (int i = 0; i < conditionsArray.size(); ++i) {
                String conditionString = conditionsArray.get(i).getAsString().toUpperCase(Locale.ROOT);
                worldConditions.add(FusionShrineRecipeWorldCondition.valueOf(conditionString));
            }
        }
        FusionShrineRecipeWorldEffect startWorldEffect = class_3518.method_15289((JsonObject)jsonObject, (String)"start_crafting_effect") ? FusionShrineRecipeWorldEffect.valueOf(class_3518.method_15265((JsonObject)jsonObject, (String)"start_crafting_effect").toUpperCase(Locale.ROOT)) : FusionShrineRecipeWorldEffect.NOTHING;
        ArrayList<FusionShrineRecipeWorldEffect> duringWorldEffects = new ArrayList<FusionShrineRecipeWorldEffect>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"during_crafting_effects")) {
            JsonArray worldEffectsArray = class_3518.method_15261((JsonObject)jsonObject, (String)"during_crafting_effects");
            for (int i = 0; i < worldEffectsArray.size(); ++i) {
                String effectString = worldEffectsArray.get(i).getAsString().toUpperCase(Locale.ROOT);
                duringWorldEffects.add(FusionShrineRecipeWorldEffect.valueOf(effectString));
            }
        }
        FusionShrineRecipeWorldEffect finishWorldEffect = class_3518.method_15289((JsonObject)jsonObject, (String)"finish_crafting_effect") ? FusionShrineRecipeWorldEffect.valueOf(class_3518.method_15265((JsonObject)jsonObject, (String)"finish_crafting_effect").toUpperCase(Locale.ROOT)) : FusionShrineRecipeWorldEffect.NOTHING;
        class_2588 description = class_3518.method_15289((JsonObject)jsonObject, (String)"description") ? new class_2588(class_3518.method_15265((JsonObject)jsonObject, (String)"description")) : null;
        return this.recipeFactory.create(identifier, group, (class_2371<class_1856>)craftingInputs, fluid, output, experience, craftingTime, noBenefitsFromYieldUpgrades, requiredAdvancementIdentifier, worldConditions, startWorldEffect, duringWorldEffects, finishWorldEffect, (class_2561)description);
    }

    public void write(class_2540 packetByteBuf, T fusionShrineRecipe) {
        packetByteBuf.method_10814(((FusionShrineRecipe)fusionShrineRecipe).group);
        packetByteBuf.writeShort(((FusionShrineRecipe)fusionShrineRecipe).craftingInputs.size());
        for (class_1856 ingredient : ((FusionShrineRecipe)fusionShrineRecipe).craftingInputs) {
            ingredient.method_8088(packetByteBuf);
        }
        packetByteBuf.method_10812(class_2378.field_11154.method_10221((Object)((FusionShrineRecipe)fusionShrineRecipe).fluidInput));
        packetByteBuf.method_10793(((FusionShrineRecipe)fusionShrineRecipe).output);
        packetByteBuf.writeFloat(((FusionShrineRecipe)fusionShrineRecipe).experience);
        packetByteBuf.writeInt(((FusionShrineRecipe)fusionShrineRecipe).craftingTime);
        packetByteBuf.writeBoolean(((FusionShrineRecipe)fusionShrineRecipe).noBenefitsFromYieldUpgrades);
        packetByteBuf.method_10812(((FusionShrineRecipe)fusionShrineRecipe).requiredAdvancementIdentifier);
        packetByteBuf.writeShort(((FusionShrineRecipe)fusionShrineRecipe).worldConditions.size());
        for (FusionShrineRecipeWorldCondition worldCondition : ((FusionShrineRecipe)fusionShrineRecipe).worldConditions) {
            packetByteBuf.writeInt(worldCondition.ordinal());
        }
        packetByteBuf.writeInt(((FusionShrineRecipe)fusionShrineRecipe).startWorldEffect.ordinal());
        packetByteBuf.writeInt(((FusionShrineRecipe)fusionShrineRecipe).duringWorldEffects.size());
        for (FusionShrineRecipeWorldEffect effect : ((FusionShrineRecipe)fusionShrineRecipe).duringWorldEffects) {
            packetByteBuf.writeInt(effect.ordinal());
        }
        packetByteBuf.writeInt(((FusionShrineRecipe)fusionShrineRecipe).finishWorldEffect.ordinal());
        if (((FusionShrineRecipe)fusionShrineRecipe).getDescription().isEmpty()) {
            packetByteBuf.method_10805((class_2561)new class_2585(""));
        } else {
            packetByteBuf.method_10805(((FusionShrineRecipe)fusionShrineRecipe).getDescription().get());
        }
    }

    public T read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        short craftingInputCount = packetByteBuf.readShort();
        class_2371 ingredients = class_2371.method_10213((int)craftingInputCount, (Object)class_1856.field_9017);
        for (short i = 0; i < craftingInputCount; i = (short)(i + 1)) {
            ingredients.set((int)i, (Object)class_1856.method_8086((class_2540)packetByteBuf));
        }
        class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(packetByteBuf.method_10810());
        class_1799 output = packetByteBuf.method_10819();
        float experience = packetByteBuf.readFloat();
        int craftingTime = packetByteBuf.readInt();
        boolean noBenefitsFromYieldUpgrades = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = packetByteBuf.method_10810();
        short worldConditionCount = packetByteBuf.readShort();
        ArrayList<FusionShrineRecipeWorldCondition> worldConditions = new ArrayList<FusionShrineRecipeWorldCondition>();
        for (short i = 0; i < worldConditionCount; i = (short)(i + 1)) {
            worldConditions.add(FusionShrineRecipeWorldCondition.values()[packetByteBuf.readInt()]);
        }
        FusionShrineRecipeWorldEffect startWorldEffect = FusionShrineRecipeWorldEffect.values()[packetByteBuf.readInt()];
        int duringWorldEventCount = packetByteBuf.readInt();
        ArrayList<FusionShrineRecipeWorldEffect> duringWorldEffects = new ArrayList<FusionShrineRecipeWorldEffect>();
        for (int i = 0; i < duringWorldEventCount; ++i) {
            duringWorldEffects.add(FusionShrineRecipeWorldEffect.values()[packetByteBuf.readInt()]);
        }
        FusionShrineRecipeWorldEffect finishWorldEffect = FusionShrineRecipeWorldEffect.values()[packetByteBuf.readInt()];
        class_2561 description = packetByteBuf.method_10808();
        return this.recipeFactory.create(identifier, group, (class_2371<class_1856>)ingredients, fluid, output, experience, craftingTime, noBenefitsFromYieldUpgrades, requiredAdvancementIdentifier, worldConditions, startWorldEffect, duringWorldEffects, finishWorldEffect, description);
    }

    public static interface RecipeFactory<T extends FusionShrineRecipe> {
        public T create(class_2960 var1, String var2, class_2371<class_1856> var3, class_3611 var4, class_1799 var5, float var6, int var7, boolean var8, class_2960 var9, List<FusionShrineRecipeWorldCondition> var10, FusionShrineRecipeWorldEffect var11, List<FusionShrineRecipeWorldEffect> var12, FusionShrineRecipeWorldEffect var13, class_2561 var14);
    }
}

