/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.fusion_shrine;

import de.dafuqs.spectrum.SpectrumClient;
import de.dafuqs.spectrum.progression.ClientRecipeToastManager;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldCondition;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldEffect;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineRecipe
implements class_1860<class_1263> {
    protected final class_2960 id;
    protected final String group;
    protected final class_2371<class_1856> craftingInputs;
    protected final class_3611 fluidInput;
    protected final class_1799 output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean noBenefitsFromYieldUpgrades;
    protected final List<FusionShrineRecipeWorldCondition> worldConditions;
    @NotNull
    protected final FusionShrineRecipeWorldEffect startWorldEffect;
    @NotNull
    protected final List<FusionShrineRecipeWorldEffect> duringWorldEffects;
    @NotNull
    protected final FusionShrineRecipeWorldEffect finishWorldEffect;
    @Nullable
    protected final class_2960 requiredAdvancementIdentifier;
    @Nullable
    protected final class_2561 description;

    public FusionShrineRecipe(class_2960 id, String group, class_2371<class_1856> craftingInputs, class_3611 fluidInput, class_1799 output, float experience, int craftingTime, boolean noBenefitsFromYieldUpgrades, class_2960 requiredAdvancementIdentifier, List<FusionShrineRecipeWorldCondition> worldConditions, FusionShrineRecipeWorldEffect startWorldEffect, List<FusionShrineRecipeWorldEffect> duringWorldEffects, FusionShrineRecipeWorldEffect finishWorldEffect, class_2561 description) {
        this.id = id;
        this.group = group;
        this.craftingInputs = craftingInputs;
        this.fluidInput = fluidInput;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.noBenefitsFromYieldUpgrades = noBenefitsFromYieldUpgrades;
        this.worldConditions = worldConditions;
        this.startWorldEffect = startWorldEffect;
        this.duringWorldEffects = duringWorldEffects;
        this.finishWorldEffect = finishWorldEffect;
        this.requiredAdvancementIdentifier = requiredAdvancementIdentifier;
        this.description = description;
        if (SpectrumClient.minecraftClient != null) {
            this.registerInClientToastManager();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void registerInClientToastManager() {
        ClientRecipeToastManager.registerUnlockableFusionShrineRecipe(this);
    }

    public boolean equals(Object object) {
        if (object instanceof FusionShrineRecipe) {
            return ((FusionShrineRecipe)object).method_8114().equals((Object)this.method_8114());
        }
        return false;
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        for (class_1856 ingredient : this.craftingInputs) {
            boolean found = false;
            for (int i = 0; i < inv.method_5439(); ++i) {
                if (!ingredient.method_8093(inv.method_5438(i))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_8116(class_1263 inv) {
        return null;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.FUSION_SHRINE_BASALT);
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.FUSION_SHRINE_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.FUSION_SHRINE;
    }

    public class_2371<class_1856> method_8117() {
        return this.craftingInputs;
    }

    public float getExperience() {
        return this.experience;
    }

    @Nullable
    public class_2960 getRequiredAdvancementIdentifier() {
        return this.requiredAdvancementIdentifier;
    }

    public boolean areConditionMetCurrently(class_1937 world) {
        for (FusionShrineRecipeWorldCondition worldCondition : this.worldConditions) {
            if (worldCondition.isMetCurrently(world)) continue;
            return false;
        }
        return true;
    }

    public class_3611 getFluidInput() {
        return this.fluidInput;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public FusionShrineRecipeWorldEffect getWorldEffectForTick(int tick) {
        if (tick == 1) {
            return this.startWorldEffect;
        }
        if (tick == this.craftingTime) {
            return this.finishWorldEffect;
        }
        if (this.duringWorldEffects.size() == 0) {
            return null;
        }
        if (this.duringWorldEffects.size() == 1) {
            return this.duringWorldEffects.get(0);
        }
        float parts = (float)this.craftingTime / (float)this.duringWorldEffects.size();
        int index = (int)((float)tick / parts);
        FusionShrineRecipeWorldEffect effect = this.duringWorldEffects.get(index);
        if (effect.isOneTimeEffect(effect) && index != (int)parts) {
            return null;
        }
        return effect;
    }

    public Optional<class_2561> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return Optional.of(this.description);
    }

    public boolean areYieldUpgradesDisabled() {
        return this.noBenefitsFromYieldUpgrades;
    }
}

