/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.enchantment_upgrade;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class EnchantmentUpgradeRecipeSerializer<T extends EnchantmentUpgradeRecipe>
implements class_1865<T> {
    public static List<EnchantmentUpgradeRecipe> enchantmentUpgradeRecipesToInject = new ArrayList<EnchantmentUpgradeRecipe>();
    public final RecipeFactory<T> recipeFactory;

    public EnchantmentUpgradeRecipeSerializer(RecipeFactory<T> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public T read(class_2960 identifier, JsonObject jsonObject) {
        class_2960 enchantmentIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"enchantment"));
        if (!class_2378.field_11160.method_10250(enchantmentIdentifier)) {
            throw new JsonParseException("Enchantment Upgrade Recipe " + identifier + " has a enchantment set that does not exist or is disabled: " + enchantmentIdentifier);
        }
        class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(enchantmentIdentifier);
        class_2960 requiredAdvancementIdentifier = null;
        if (class_3518.method_15289((JsonObject)jsonObject, (String)"required_advancement")) {
            requiredAdvancementIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"required_advancement"));
        }
        JsonArray levelArray = class_3518.method_15261((JsonObject)jsonObject, (String)"levels");
        Object recipe = null;
        for (int i = 0; i < levelArray.size(); ++i) {
            JsonObject currentElement = levelArray.get(i).getAsJsonObject();
            int level = i + 2;
            int requiredExperience = class_3518.method_15260((JsonObject)currentElement, (String)"experience");
            class_1792 requiredItem = (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)class_3518.method_15265((JsonObject)currentElement, (String)"item")));
            int requiredItemCount = class_3518.method_15260((JsonObject)currentElement, (String)"item_count");
            recipe = this.recipeFactory.create(new class_2960("spectrum", identifier.method_12832() + "_level_" + (i + 2)), enchantment, level, requiredExperience, requiredItem, requiredItemCount, requiredAdvancementIdentifier);
            if (enchantmentUpgradeRecipesToInject.contains(recipe)) continue;
            enchantmentUpgradeRecipesToInject.add((EnchantmentUpgradeRecipe)recipe);
        }
        return (T)recipe;
    }

    public void write(class_2540 packetByteBuf, T enchantmentUpgradeRecipe) {
        packetByteBuf.method_10812(class_2378.field_11160.method_10221((Object)((EnchantmentUpgradeRecipe)enchantmentUpgradeRecipe).enchantment));
        packetByteBuf.writeInt(((EnchantmentUpgradeRecipe)enchantmentUpgradeRecipe).enchantmentDestinationLevel);
        packetByteBuf.writeInt(((EnchantmentUpgradeRecipe)enchantmentUpgradeRecipe).requiredExperience);
        packetByteBuf.method_10812(class_2378.field_11142.method_10221((Object)((EnchantmentUpgradeRecipe)enchantmentUpgradeRecipe).requiredItem));
        packetByteBuf.writeInt(((EnchantmentUpgradeRecipe)enchantmentUpgradeRecipe).requiredItemCount);
        packetByteBuf.method_10812(((EnchantmentUpgradeRecipe)enchantmentUpgradeRecipe).requiredAdvancementIdentifier);
    }

    public T read(class_2960 identifier, class_2540 packetByteBuf) {
        class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(packetByteBuf.method_10810());
        int enchantmentDestinationLevel = packetByteBuf.readInt();
        int requiredExperience = packetByteBuf.readInt();
        class_1792 requiredItem = (class_1792)class_2378.field_11142.method_10223(packetByteBuf.method_10810());
        int requiredItemCount = packetByteBuf.readInt();
        class_2960 requiredAdvancementIdentifier = packetByteBuf.method_10810();
        return this.recipeFactory.create(identifier, enchantment, enchantmentDestinationLevel, requiredExperience, requiredItem, requiredItemCount, requiredAdvancementIdentifier);
    }

    public static interface RecipeFactory<T extends EnchantmentUpgradeRecipe> {
        public T create(class_2960 var1, class_1887 var2, int var3, int var4, class_1792 var5, int var6, @Nullable class_2960 var7);
    }
}

